/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.Arrays;
import java.util.Set;
import org.squashtest.tm.domain.NodeType;

public enum NodeScopeType {
    LIBRARY(Set.of(NodeType.TEST_CASE_LIBRARY)),
    NODE(Set.of(NodeType.TEST_CASE_FOLDER, NodeType.TEST_CASE));

    private final Set<NodeType> compatibleNodeTypes;

    private NodeScopeType(Set<NodeType> compatibleNodeTypes) {
        this.compatibleNodeTypes = compatibleNodeTypes;
    }

    public boolean isCompatibleWith(NodeType nodeType) {
        return this.compatibleNodeTypes.contains(nodeType);
    }

    public static NodeScopeType fromNodeType(NodeType nodeType) {
        return Arrays.stream(NodeScopeType.values()).filter(scopeType -> scopeType.isCompatibleWith(nodeType)).findFirst().orElseThrow(() -> new IllegalArgumentException("No NodeScopeType found for NodeType: " + String.valueOf(nodeType)));
    }
}

