/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.exception.testautomation.DuplicateTMLabelException;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.TestAutomationProjectDao;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.TestAutomationServerNoCredentialsException;

@Transactional
@Service(value="squashtest.tm.service.TestAutomationProjectManagementService")
public class TestAutomationProjectManagerServiceImpl
implements TestAutomationProjectManagerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationConnector.class);
    private final TestAutomationProjectDao projectDao;
    private final TestAutomationConnectorRegistry connectorRegistry;
    private final GenericProjectDao genericProjectDao;
    private final CredentialsProvider credentialsProvider;
    private final MessageSource i18nHelper;
    private final PermissionEvaluationService permissionEvaluationService;

    public TestAutomationProjectManagerServiceImpl(TestAutomationProjectDao projectDao, TestAutomationConnectorRegistry connectorRegistry, GenericProjectDao genericProjectDao, CredentialsProvider credentialsProvider, MessageSource i18nHelper, PermissionEvaluationService permissionEvaluationService) {
        this.projectDao = projectDao;
        this.connectorRegistry = connectorRegistry;
        this.genericProjectDao = genericProjectDao;
        this.credentialsProvider = credentialsProvider;
        this.i18nHelper = i18nHelper;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    private String getMessage(String i18nKey) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.i18nHelper.getMessage(i18nKey, null, locale);
    }

    @Override
    public void persist(TestAutomationProject newProject) {
        this.projectDao.persist(newProject);
    }

    @Override
    public TestAutomationProject findProjectById(long projectId) {
        return this.projectDao.findById(projectId);
    }

    @Override
    public void deleteProject(long projectId) {
        this.projectDao.deleteProjectsByIds(Collections.singletonList(projectId));
    }

    @Override
    public void deleteAllForTMProject(long tmProjectId) {
        Collection<Long> allprojects = this.projectDao.findAllByTMProject(tmProjectId);
        this.projectDao.deleteProjectsByIds(allprojects);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeLabel(long projectId, String label) {
        List<String> taProjectNames;
        TestAutomationProject project = this.projectDao.findById(projectId);
        if (!project.getLabel().equals(label) && (taProjectNames = this.genericProjectDao.findBoundTestAutomationProjectLabels(project.getTmProject().getId())).contains(label)) {
            throw new DuplicateTMLabelException(label);
        }
        project.setLabel(label);
    }

    private void changeJobName(long projectId, String jobName) {
        TestAutomationProject project = this.projectDao.findById(projectId);
        project.setJobName(jobName);
    }

    private void changeSlaves(long projectId, String slaveList) {
        TestAutomationProject project = this.projectDao.findById(projectId);
        project.setSlaves(slaveList);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeCanRunGherkin(long projectId, boolean canRunGherkin) {
        TestAutomationProject project = this.projectDao.findById(projectId);
        if (canRunGherkin) {
            this.setUniqueBddProject(projectId);
        } else {
            project.setCanRunGherkin(false);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void editProject(long projectId, TestAutomationProject newValues) {
        this.changeJobName(projectId, newValues.getJobName());
        this.changeLabel(projectId, newValues.getLabel());
        this.changeSlaves(projectId, newValues.getSlaves());
        if (newValues.isCanRunGherkin()) {
            this.setUniqueBddProject(projectId);
        } else {
            this.changeCanRunGherkin(projectId, newValues.isCanRunGherkin());
        }
    }

    @Override
    public Collection<Long> findAllIdsByTMProject(Long projectId) {
        return this.projectDao.findAllByTMProject(projectId);
    }

    @Override
    public Collection<TestAutomationProject> listProjectsOnServer(TestAutomationServer server) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        Optional<Credentials> maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
        Supplier<TestAutomationServerNoCredentialsException> throwIfNull = () -> {
            throw new TestAutomationServerNoCredentialsException(String.format(this.getMessage("message.testAutomationServer.noCredentials"), server.getName()));
        };
        Credentials credentials = maybeCredentials.orElseThrow(throwIfNull);
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (!connector.supports(protocol)) {
            throw new UnsupportedAuthenticationModeException(protocol.toString());
        }
        try {
            connector.checkCredentials(server, credentials);
            return connector.listProjectsOnServer(server, credentials);
        }
        catch (TestAutomationException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Test Automation : failed to list projects on server : ", (Throwable)((Object)ex));
            }
            throw ex;
        }
    }

    @Override
    public Collection<TestAutomationProject> listProjectsOnServerForCurrentUser(TestAutomationServer server) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        Optional<Credentials> optionalCredentials = this.credentialsProvider.getCurrentUserCredentials((ThirdPartyServer)server);
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        try {
            Credentials credentials = optionalCredentials.orElseThrow();
            connector.checkCredentials(server, credentials);
            return connector.listProjectsOnServer(server, credentials);
        }
        catch (TestAutomationException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Test Automation : failed to list projects on server : ", (Throwable)((Object)ex));
            }
            throw ex;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to list projects on server {} with url {} because no Credentials are stored for the current user.", new Object[]{server.getName(), server.getUrl(), noSuchElementException});
            }
            throw noSuchElementException;
        }
    }

    @Override
    public URL findProjectURL(TestAutomationProject testAutomationProject) {
        TestAutomationServer server = testAutomationProject.getServer();
        TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(server.getKind());
        return connector.findTestAutomationProjectURL(testAutomationProject);
    }

    @Override
    public boolean haveExecutedTests(Collection<Long> taProjectIds) {
        return this.projectDao.haveExecutedTestsByIds(taProjectIds);
    }

    @Override
    public boolean haveExecutedTestsByTmProjectId(long tmProjectId) {
        return this.projectDao.haveExecutedTestsByTmProjectId(tmProjectId);
    }

    @Override
    public List<TestAutomationProjectDto> findAllByTMProject(long tmProjectId) {
        return this.projectDao.findAllByTMProject(tmProjectId).stream().map(this.projectDao::findById).map(TestAutomationProjectDto::fromPersistedTestAutomationProject).toList();
    }

    @Override
    public void setUniqueBddProject(long projectId) {
        TestAutomationProject taProject = this.projectDao.findById(projectId);
        Collection<Long> allProjectsOnServer = this.projectDao.findAllByTMProject(taProject.getTmProject().getId());
        allProjectsOnServer.stream().filter(Objects::nonNull).forEach(testAutomationProjectId -> {
            TestAutomationProject testAutomationProject = this.projectDao.findById((Long)testAutomationProjectId);
            testAutomationProject.setCanRunGherkin(testAutomationProjectId.equals(projectId));
        });
    }
}

