/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.lang.Couple;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.testautomation.TaParametersBuilder;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.internal.testautomation.model.IterationTestPlanItemWithCustomFields;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.service.testautomation.model.SquashAutomExecutionConfiguration;
import org.squashtest.tm.service.testautomation.model.SuiteExecutionConfiguration;
import org.squashtest.tm.service.testautomation.spi.InvalidSquashOrchestratorConfigurationException;
import org.squashtest.tm.service.testautomation.spi.ServerConnectionFailed;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;
import org.squashtest.tm.service.testautomation.spi.TestAutomationException;
import org.squashtest.tm.service.testautomation.spi.UnknownConnectorKind;

@Service
public class AutomatedSuiteStartService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuiteStartService.class);
    private static final String START_COLLECTING_AUTOMATED_EXECUTIONS_FOR = "-- START COLLECTING AUTOMATED EXECUTIONS FOR ";
    private static final String END_COLLECTING_AUTOMATED_EXECUTIONS_FOR = "-- END COLLECTING AUTOMATED EXECUTIONS FOR ";
    private static final String START_SENDING_AUTOMATED_EXECUTIONS_FOR = "-- START SENDING AUTOMATED EXECUTIONS FOR ";
    private static final String END_SENDING_AUTOMATED_EXECUTIONS_FOR = "-- END SENDING AUTOMATED EXECUTIONS FOR ";
    private static final String TEST_AUTOMATION_UNKNOWN_CONNECTOR = "Test Automation : unknown connector :";
    private static final String TEST_AUTOMATION_ERROR_OCCURRED = "Test Automation : an error occurred :";
    private final PermissionEvaluationService permissionEvaluationService;
    private final TestAutomationConnectorRegistry connectorRegistry;
    private final AutomatedSuiteDao automatedSuiteDao;
    private final Provider<TaParametersBuilder> parametersBuilderProvider;
    private final CustomFieldValueFinderService customFieldValueFinder;
    private final CredentialsProvider credentialsProvider;

    public AutomatedSuiteStartService(PermissionEvaluationService permissionEvaluationService, TestAutomationConnectorRegistry connectorRegistry, AutomatedSuiteDao automatedSuiteDao, Provider<TaParametersBuilder> parametersBuilderProvider, CustomFieldValueFinderService customFieldValueFinder, CredentialsProvider credentialsProvider) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.connectorRegistry = connectorRegistry;
        this.automatedSuiteDao = automatedSuiteDao;
        this.parametersBuilderProvider = parametersBuilderProvider;
        this.customFieldValueFinder = customFieldValueFinder;
        this.credentialsProvider = credentialsProvider;
    }

    void start(AutomatedSuite suite, Collection<SuiteExecutionConfiguration> configuration) {
        List<AutomatedExecutionExtender> executionExtenders = this.getOptimizedExecutionsExtenders(suite);
        String uuid = suite.getUuid();
        LOGGER.debug("- START CHECKING EXECUTIONS PERMISSIONS {}", new Object[]{new Date()});
        this.permissionEvaluationService.checkPermission(executionExtenders, Permissions.EXECUTE.name());
        LOGGER.debug("- END CHECKING EXECUTIONS PERMISSIONS {}", new Object[]{new Date()});
        LOGGER.debug("- START SORTING EXECUTIONS {}", new Object[]{new Date()});
        ExtenderSorter sorter = new ExtenderSorter(suite, configuration);
        LOGGER.debug("- END SORTING EXECUTIONS {}", new Object[]{new Date()});
        LOGGER.debug("- START COLLECTING AND SENDING ALL AUTOMATED EXECUTIONS {}", new Object[]{new Date()});
        Iteration iteration = AutomatedSuiteStartService.getIteration(suite, executionExtenders);
        while (sorter.hasNext()) {
            this.collectAndSendExecutions(sorter, uuid, iteration);
        }
        LOGGER.debug("- END COLLECTING AND SENDING ALL EXECUTIONS {}", new Object[]{new Date()});
    }

    void start(AutomatedSuiteWithSquashAutomAutomatedITPIs suite, Collection<SuiteExecutionConfiguration> jenkinsConfigurations, Collection<SquashAutomExecutionConfiguration> squashAutomConfigurations) {
        AutomatedSuite automatedSuite = suite.getSuite();
        Long suiteId = automatedSuite.getId();
        String uuid = automatedSuite.getUuid();
        List<AutomatedExecutionExtender> executionExtenders = this.getOptimizedExecutionsExtenders(automatedSuite);
        List<TestPlanItem> itpis = suite.getSquashAutomAutomatedItems();
        LOGGER.debug("- START CHECKING EXECUTIONS PERMISSIONS {}", new Object[]{new Date()});
        this.permissionEvaluationService.checkPermission(executionExtenders, Permissions.EXECUTE.name());
        LOGGER.debug("- END CHECKING EXECUTIONS PERMISSIONS {}", new Object[]{new Date()});
        LOGGER.debug("- START CHECKING ITPIS PERMISSIONS {}", new Object[]{new Date()});
        this.permissionEvaluationService.checkPermission(itpis, Permissions.EXECUTE.name());
        LOGGER.debug("- END CHECKING ITPIS PERMISSIONS {}", new Object[]{new Date()});
        LOGGER.debug("- START SORTING EXECUTIONS {}", new Object[]{new Date()});
        ExtenderSorter extenderSorter = new ExtenderSorter(automatedSuite, jenkinsConfigurations);
        LOGGER.debug("- END SORTING EXECUTIONS {}", new Object[]{new Date()});
        LOGGER.debug("- START SORTING ITPIS {}", new Object[]{new Date()});
        ITPISorter itpiSorter = new ITPISorter(itpis);
        LOGGER.debug("- END SORTING ITPIS {}", new Object[]{new Date()});
        LOGGER.debug("- START COLLECTING AND SENDING ALL AUTOMATED EXECUTIONS {}", new Object[]{new Date()});
        Iteration iteration = AutomatedSuiteStartService.getIteration(automatedSuite, executionExtenders);
        while (extenderSorter.hasNext()) {
            this.collectAndSendExecutions(extenderSorter, uuid, iteration);
        }
        LOGGER.debug("- END COLLECTING AND SENDING ALL EXECUTIONS {}", new Object[]{new Date()});
        LOGGER.debug("- START COLLECTING AND SENDING ALL AUTOMATED ITPIS {}", new Object[]{new Date()});
        this.collectAndSendItems(suite, squashAutomConfigurations, itpiSorter, suiteId, automatedSuite);
        LOGGER.debug("- END COLLECTING AND SENDING ALL ITPIS {}", new Object[]{new Date()});
    }

    private static Iteration getIteration(AutomatedSuite automatedSuite, List<AutomatedExecutionExtender> extenders) {
        if (automatedSuite.getIteration() != null) {
            return automatedSuite.getIteration();
        }
        if (automatedSuite.getTestSuite() != null) {
            return automatedSuite.getTestSuite().getIteration();
        }
        return extenders.get(0).getExecution().getTestPlanItem().getParentIteration();
    }

    private void collectAndSendItems(AutomatedSuiteWithSquashAutomAutomatedITPIs suite, Collection<SquashAutomExecutionConfiguration> squashAutomConfigurations, ITPISorter itpiSorter, Long suiteId, AutomatedSuite automatedSuite) {
        while (itpiSorter.hasNext()) {
            Map.Entry<TestAutomationServerKind, Collection<TestPlanItem>> itemsByKind = itpiSorter.getNextEntry();
            try {
                TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(itemsByKind.getKey());
                LOGGER.debug(START_COLLECTING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(itemsByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
                Collection<IterationTestPlanItemWithCustomFields> tests = this.collectItpis(itemsByKind.getValue(), suite.getItemExecutionMap());
                LOGGER.debug(END_COLLECTING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(itemsByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
                LOGGER.debug(START_SENDING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(itemsByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
                AutomatedSuiteStartService.sendAutomatedExecutions(suite, squashAutomConfigurations, suiteId, automatedSuite, connector, tests);
                LOGGER.debug(END_SENDING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(itemsByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
            }
            catch (InvalidSquashOrchestratorConfigurationException | ServerConnectionFailed ex) {
                String errorMessage = ex.getMessage();
                LOGGER.error(errorMessage, (Throwable)ex);
                suite.setErrorMessage(errorMessage);
                this.updateAutomSuiteStatusToBlockedAndExecutionsStatusToError(suite.getSuite());
            }
            catch (UnknownConnectorKind ex) {
                LOGGER.error(TEST_AUTOMATION_UNKNOWN_CONNECTOR, (Throwable)((Object)ex));
                this.updateAutomSuiteStatusToBlockedAndExecutionsStatusToError(suite.getSuite());
            }
            catch (TestAutomationException ex) {
                LOGGER.error(TEST_AUTOMATION_ERROR_OCCURRED, (Throwable)((Object)ex));
                this.updateAutomSuiteStatusToBlockedAndExecutionsStatusToError(suite.getSuite());
            }
            catch (UnsupportedOperationException ex) {
                LOGGER.debug("Catch Unsupported Operation Exception", (Throwable)ex);
            }
        }
    }

    private static void sendAutomatedExecutions(AutomatedSuiteWithSquashAutomAutomatedITPIs suite, Collection<SquashAutomExecutionConfiguration> squashAutomConfigurations, Long suiteId, AutomatedSuite automatedSuite, TestAutomationConnector connector, Collection<IterationTestPlanItemWithCustomFields> tests) {
        List<AutomatedSuiteWorkflow> workflows = connector.executeParameterizedTestsBasedOnITPICollection(tests, suiteId, squashAutomConfigurations);
        if (workflows != null) {
            suite.setWorkflowsUUIDs(workflows.stream().map(AutomatedSuiteWorkflow::getWorkflowId).toList());
            automatedSuite.setWorkflows(workflows);
        }
    }

    private List<AutomatedExecutionExtender> getOptimizedExecutionsExtenders(AutomatedSuite suite) {
        LOGGER.debug("- START FETCHING OPTIMIZED EXECUTIONS {}", new Object[]{new Date()});
        List<AutomatedExecutionExtender> executionExtenders = this.automatedSuiteDao.findAndFetchForAutomatedExecutionCreation(suite.getId());
        LOGGER.debug("- FETCHED " + executionExtenders.size(), new Object[0]);
        LOGGER.debug("- END FETCHING OPTIMIZED EXECUTIONS {}", new Object[]{new Date()});
        return executionExtenders;
    }

    private Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> collectAutomatedExecs(Collection<AutomatedExecutionExtender> extenders, Iteration iteration) {
        ArrayList<Couple<AutomatedExecutionExtender, Map<String, Object>>> tests = new ArrayList<Couple<AutomatedExecutionExtender, Map<String, Object>>>(extenders.size());
        CustomFieldValuesForExec customFieldValuesForExec = this.fetchCustomFieldValues(extenders);
        for (AutomatedExecutionExtender extender : extenders) {
            tests.add(this.createAutomatedExecAndParams(extender, customFieldValuesForExec, iteration));
        }
        return tests;
    }

    private CustomFieldValuesForExec fetchCustomFieldValues(Collection<AutomatedExecutionExtender> extenders) {
        Map<Long, List<CustomFieldValue>> testCaseCfv = this.fetchTestCaseCfv(extenders);
        Map<Long, List<CustomFieldValue>> iterationCfv = this.fetchIterationCfv(extenders);
        Map<Long, List<CustomFieldValue>> campaignCfv = this.fetchCampaignCfv(extenders);
        Map<Long, List<CustomFieldValue>> testSuiteCfv = this.fetchTestSuiteCfv(extenders);
        return new CustomFieldValuesForExec(testCaseCfv, iterationCfv, campaignCfv, testSuiteCfv);
    }

    private Map<Long, List<CustomFieldValue>> fetchTestCaseCfv(Collection<AutomatedExecutionExtender> extenders) {
        Set testCases = extenders.stream().map(extender -> extender.getExecution().getReferencedTestCase()).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(testCases).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchIterationCfv(Collection<AutomatedExecutionExtender> extenders) {
        Set iterations = extenders.stream().map(extender -> extender.getTestPlanItem().getParentIteration()).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(iterations).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchCampaignCfv(Collection<AutomatedExecutionExtender> extenders) {
        Set campaigns = extenders.stream().map(extender -> extender.getTestPlanItem().getParentIteration().getCampaign()).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(campaigns).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchTestSuiteCfv(Collection<AutomatedExecutionExtender> extenders) {
        Set testSuites = extenders.stream().map(extender -> extender.getTestPlanItem().getTestSuites()).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(testSuites).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private void collectAndSendExecutions(ExtenderSorter sorter, String uuid, Iteration iteration) {
        Map.Entry<TestAutomationServerKind, Collection<AutomatedExecutionExtender>> extendersByKind = sorter.getNextEntry();
        try {
            TestAutomationConnector connector = this.connectorRegistry.getConnectorForKind(extendersByKind.getKey());
            this.doCollectAndSendExecutions(extendersByKind, connector, uuid, iteration);
        }
        catch (UnknownConnectorKind ex) {
            LOGGER.error(TEST_AUTOMATION_UNKNOWN_CONNECTOR, (Throwable)((Object)ex));
            this.notifyExecutionError(extendersByKind.getValue(), ex.getMessage());
        }
        catch (TestAutomationException ex) {
            LOGGER.error(TEST_AUTOMATION_ERROR_OCCURRED, (Throwable)((Object)ex));
            this.notifyExecutionError(extendersByKind.getValue(), ex.getMessage());
        }
    }

    private void doCollectAndSendExecutions(Map.Entry<TestAutomationServerKind, Collection<AutomatedExecutionExtender>> extendersByKind, TestAutomationConnector connector, String uuid, Iteration iteration) {
        LOGGER.debug(START_COLLECTING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(extendersByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
        Collection<Couple<AutomatedExecutionExtender, Map<String, Object>>> tests = this.collectAutomatedExecs(extendersByKind.getValue(), iteration);
        LOGGER.debug(END_COLLECTING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(extendersByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
        LOGGER.debug(START_SENDING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(extendersByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
        connector.executeParameterizedTests(tests, uuid);
        LOGGER.debug(END_SENDING_AUTOMATED_EXECUTIONS_FOR + String.valueOf(extendersByKind.getKey()) + " " + String.valueOf(new Date()), new Object[0]);
    }

    private Collection<IterationTestPlanItemWithCustomFields> collectItpis(Collection<TestPlanItem> itpis, Map<Long, Long> itemExecutionMap) {
        ArrayList<IterationTestPlanItemWithCustomFields> tests = new ArrayList<IterationTestPlanItemWithCustomFields>(itpis.size());
        CustomFieldValuesForExec customFieldValuesForItpi = this.fetchCustomFieldValuesForITPIs(itpis);
        Map<Long, Credentials> scmServerCredentialsMap = this.getScmServerCredentialsMap(itpis);
        for (TestPlanItem item : itpis) {
            tests.add(this.createItemAndParams(item, customFieldValuesForItpi, itemExecutionMap.get(item.getId()), scmServerCredentialsMap));
        }
        return tests;
    }

    private Map<Long, Credentials> getScmServerCredentialsMap(Collection<TestPlanItem> itpis) {
        Map scmServerMap = itpis.stream().filter(item -> item.getReferencedTestCase().getScmRepository() != null).map(item -> item.getReferencedTestCase().getScmRepository().getScmServer()).collect(Collectors.toMap(ThirdPartyServer::getId, server -> server, (existing, replacement) -> existing, LinkedHashMap::new));
        HashMap<Long, Credentials> scmServerCredentialsMap = new HashMap<Long, Credentials>();
        scmServerMap.values().forEach(server -> {
            Optional<Credentials> maybeCredentials = this.credentialsProvider.getAppLevelCredentials((ThirdPartyServer)server);
            scmServerCredentialsMap.put(server.getId(), maybeCredentials.orElse(null));
        });
        return scmServerCredentialsMap;
    }

    private CustomFieldValuesForExec fetchCustomFieldValuesForITPIs(Collection<TestPlanItem> items) {
        Map<Long, List<CustomFieldValue>> testCaseCfv = this.fetchTestCaseCfvForITPIs(items);
        Map<Long, List<CustomFieldValue>> iterationCfv = this.fetchIterationCfvForITPIs(items);
        Map<Long, List<CustomFieldValue>> campaignCfv = this.fetchCampaignCfvForITPIs(items);
        Map<Long, List<CustomFieldValue>> testSuiteCfv = this.fetchTestSuiteCfvForITPIs(items);
        return new CustomFieldValuesForExec(testCaseCfv, iterationCfv, campaignCfv, testSuiteCfv);
    }

    private Map<Long, List<CustomFieldValue>> fetchTestCaseCfvForITPIs(Collection<TestPlanItem> items) {
        Set testCases = items.stream().map(TestPlanItem::getReferencedTestCase).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(testCases).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchIterationCfvForITPIs(Collection<TestPlanItem> items) {
        Set iterations = items.stream().map(TestPlanItem::getParentIteration).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(iterations).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchCampaignCfvForITPIs(Collection<TestPlanItem> items) {
        Set campaigns = items.stream().map(item -> item.getParentIteration().getCampaign()).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(campaigns).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private Map<Long, List<CustomFieldValue>> fetchTestSuiteCfvForITPIs(Collection<TestPlanItem> extenders) {
        Set testSuites = extenders.stream().map(TestPlanItem::getTestSuites).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.customFieldValueFinder.findAllCustomFieldValues(testSuites).stream().collect(Collectors.groupingBy(CustomFieldValue::getBoundEntityId));
    }

    private IterationTestPlanItemWithCustomFields createItemAndParams(TestPlanItem item, CustomFieldValuesForExec customFieldValuesForExec, Long itemExecutionId, Map<Long, Credentials> scmServerCredentialsMap) {
        List<CustomFieldValue> tcFields = customFieldValuesForExec.getValueForTestcase(item.getReferencedTestCase().getId());
        List<CustomFieldValue> iterFields = customFieldValuesForExec.getValueForIteration(item.getParentIteration().getId());
        List<CustomFieldValue> campFields = customFieldValuesForExec.getValueForCampaign(item.getParentIteration().getCampaign().getId());
        List<CustomFieldValue> testSuiteFields = item.getTestSuites().stream().map(TestSuite::getId).map(customFieldValuesForExec::getValueForTestSuite).flatMap(Collection::stream).toList();
        Credentials credentials = null;
        ScmRepository repository = item.getReferencedTestCase().getScmRepository();
        if (repository != null) {
            if (repository.getScmServer().isCredentialsNotShared()) {
                LOGGER.info("Do not share Git credentials with the execution environment for the SCM server : {}. Please make sure you have correctly configured Git credentials in the execution environment.", new Object[]{repository.getScmServer().getFriendlyName()});
            } else {
                credentials = scmServerCredentialsMap.get(repository.getScmServer().getId());
            }
        }
        Map<String, Object> params = ((TaParametersBuilder)this.parametersBuilderProvider.get()).testCase().addEntity(item.getReferencedTestCase()).addCustomFields(tcFields).iteration().addCustomFields(iterFields).campaign().addCustomFields(campFields).testSuite().addCustomFields(testSuiteFields).dataset().addEntity(item.getReferencedDataset()).scmRepository().addEntity(repository).scmRepositoryCredentials().addEntity(credentials).build();
        params.put("TC_EXECUTION_ID", itemExecutionId);
        return new IterationTestPlanItemWithCustomFields(item, params);
    }

    private void updateAutomSuiteStatusToBlockedAndExecutionsStatusToError(AutomatedSuite suite) {
        suite.setExecutionStatus(ExecutionStatus.BLOCKED);
        suite.getExecutionExtenders().forEach(extender -> extender.getExecution().setExecutionStatus(ExecutionStatus.ERROR));
    }

    private Couple<AutomatedExecutionExtender, Map<String, Object>> createAutomatedExecAndParams(AutomatedExecutionExtender extender, CustomFieldValuesForExec customFieldValuesForExec, Iteration iteration) {
        Execution execution = extender.getExecution();
        List<CustomFieldValue> tcFields = customFieldValuesForExec.getValueForTestcase(execution.getReferencedTestCase().getId());
        List<CustomFieldValue> iterFields = customFieldValuesForExec.getValueForIteration(iteration.getId());
        List<CustomFieldValue> campFields = customFieldValuesForExec.getValueForCampaign(iteration.getCampaign().getId());
        List<CustomFieldValue> testSuiteFields = execution.getTestPlanItem().getTestSuites().stream().map(TestSuite::getId).map(customFieldValuesForExec::getValueForTestSuite).flatMap(Collection::stream).toList();
        Map<String, Object> params = ((TaParametersBuilder)this.parametersBuilderProvider.get()).testCase().addEntity(execution.getReferencedTestCase()).addCustomFields(tcFields).iteration().addCustomFields(iterFields).campaign().addCustomFields(campFields).testSuite().addCustomFields(testSuiteFields).dataset().addEntity(execution.getTestPlanItem().getReferencedDataset()).build();
        return new Couple((Object)extender, params);
    }

    private void notifyExecutionError(Collection<AutomatedExecutionExtender> failedExecExtenders, String message) {
        for (AutomatedExecutionExtender extender : failedExecExtenders) {
            extender.setExecutionStatus(ExecutionStatus.ERROR);
            extender.setResultSummary(HtmlUtils.htmlEscape((String)message));
        }
    }

    private record CustomFieldValuesForExec(Map<Long, List<CustomFieldValue>> testCaseCfv, Map<Long, List<CustomFieldValue>> iterationCfv, Map<Long, List<CustomFieldValue>> campaignCfv, Map<Long, List<CustomFieldValue>> suiteCfv) {
        public List<CustomFieldValue> getValueForTestcase(Long testCaseId) {
            return this.testCaseCfv.getOrDefault(testCaseId, Collections.emptyList());
        }

        public List<CustomFieldValue> getValueForIteration(Long iterationId) {
            return this.iterationCfv.getOrDefault(iterationId, Collections.emptyList());
        }

        public List<CustomFieldValue> getValueForCampaign(Long campaignId) {
            return this.campaignCfv.getOrDefault(campaignId, Collections.emptyList());
        }

        public List<CustomFieldValue> getValueForTestSuite(Long suiteId) {
            return this.suiteCfv.getOrDefault(suiteId, Collections.emptyList());
        }
    }

    private static class ExtenderSorter {
        private final Map<Long, SuiteExecutionConfiguration> configurationByProject;
        private final Map<TestAutomationServerKind, Collection<AutomatedExecutionExtender>> extendersByKind;
        private Iterator<Map.Entry<TestAutomationServerKind, Collection<AutomatedExecutionExtender>>> iterator = null;

        public ExtenderSorter(AutomatedSuite suite, Collection<SuiteExecutionConfiguration> configuration) {
            this.configurationByProject = new HashMap<Long, SuiteExecutionConfiguration>(configuration.size());
            for (SuiteExecutionConfiguration conf : configuration) {
                this.configurationByProject.put(conf.getProjectId(), conf);
            }
            this.extendersByKind = new TreeMap<TestAutomationServerKind, Collection<AutomatedExecutionExtender>>();
            for (AutomatedExecutionExtender extender : suite.getExecutionExtenders()) {
                if (extender.getAutomatedTest() == null) continue;
                TestAutomationServerKind serverKind = extender.getAutomatedTest().getProject().getServer().getKind();
                this.register(extender, serverKind);
            }
            this.iterator = this.extendersByKind.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Map.Entry<TestAutomationServerKind, Collection<AutomatedExecutionExtender>> getNextEntry() {
            return this.iterator.next();
        }

        private void register(AutomatedExecutionExtender extender, TestAutomationServerKind serverKind) {
            SuiteExecutionConfiguration conf = this.configurationByProject.get(extender.getAutomatedProject().getId());
            if (conf != null) {
                extender.setNodeName(conf.getNode());
            }
            this.extendersByKind.computeIfAbsent(serverKind, k -> new LinkedList()).add(extender);
        }
    }

    private static class ITPISorter {
        private final Map<TestAutomationServerKind, Collection<TestPlanItem>> itemsByKind = new TreeMap<TestAutomationServerKind, Collection<TestPlanItem>>();
        private Iterator<Map.Entry<TestAutomationServerKind, Collection<TestPlanItem>>> iterator = null;

        public ITPISorter(List<TestPlanItem> items) {
            for (TestPlanItem item : items) {
                TestAutomationServerKind serverKind = item.getReferencedTestCase().getProject().getTestAutomationServer().getKind();
                this.register(item, serverKind);
            }
            this.iterator = this.itemsByKind.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Map.Entry<TestAutomationServerKind, Collection<TestPlanItem>> getNextEntry() {
            return this.iterator.next();
        }

        private void register(TestPlanItem extender, TestAutomationServerKind serverKind) {
            this.itemsByKind.computeIfAbsent(serverKind, k -> new LinkedList()).add(extender);
        }
    }
}

