/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.annotation.ClassType;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.TransientlyRestore;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.copier.TestCaseWorkspaceStrategyCopierService;
import org.squashtest.tm.service.internal.copier.NodeCopierDto;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingBasicEntities;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingRequirementToTestCase;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.testcase.fromreq.ReqToTestCaseConfiguration;

@Service
@Transactional
public class TestCaseWorkspaceStrategyCopierServiceImpl
implements TestCaseWorkspaceStrategyCopierService {
    private final StrategyCopierService strategyCopierService;
    private final Map<EntityType, EntityDao<?>> daoProviderMap;
    private final RequirementDao requirementDao;
    private final RequirementFolderDao requirementFolderDao;
    private final CustomTestCaseDao testCaseDao;
    private final TestCaseLibraryDao testCaseLibraryDao;
    private final TestCaseFolderDao testCaseFolderDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;

    public TestCaseWorkspaceStrategyCopierServiceImpl(StrategyCopierService strategyCopierService, RequirementDao requirementDao, RequirementFolderDao requirementFolderDao, CustomTestCaseDao testCaseDao, TestCaseLibraryDao testCaseLibraryDao, TestCaseFolderDao testCaseFolderDao, ActiveMilestoneHolder activeMilestoneHolder) {
        this.strategyCopierService = strategyCopierService;
        this.requirementDao = requirementDao;
        this.requirementFolderDao = requirementFolderDao;
        this.testCaseDao = testCaseDao;
        this.testCaseLibraryDao = testCaseLibraryDao;
        this.testCaseFolderDao = testCaseFolderDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.daoProviderMap = this.getDaoProviderMap();
    }

    private Map<EntityType, EntityDao<?>> getDaoProviderMap() {
        return Map.of(EntityType.REQUIREMENT, this.requirementDao, EntityType.REQUIREMENT_FOLDER, this.requirementFolderDao, EntityType.TEST_CASE_LIBRARY, this.testCaseLibraryDao, EntityType.TEST_CASE_FOLDER, this.testCaseFolderDao, EntityType.TEST_CASE, this.testCaseDao);
    }

    @Override
    public Map<NodeType, List<Long>> verifyPermission(ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.strategyCopierService.getNodeIdsByNodeTypeToPaste(clipboardPayload);
        this.strategyCopierService.verifyPermission(nodePastes);
        return nodePastes;
    }

    @Override
    @TransientlyRestore
    public <C extends NodeContainer<TestCaseLibraryNode>> void copyRequirementNodesToTestCaseContainer(@Id Long destinationId, @ClassType Class<C> destinationClazz, ClipboardPayload clipboardPayload, Map<NodeType, List<Long>> nodePastes, ReqToTestCaseConfiguration configuration) {
        if (nodePastes.containsKey(NodeType.HIGH_LEVEL_REQUIREMENT)) {
            List<Long> highLevelRequirementIds = nodePastes.remove(NodeType.HIGH_LEVEL_REQUIREMENT);
            nodePastes.computeIfAbsent(NodeType.REQUIREMENT, k -> new ArrayList()).addAll(highLevelRequirementIds);
        }
        NodeCopierDto nodeCopierDto = this.getNodeCopierDto(configuration);
        CopyLoadingRequirementToTestCase copyLoadingEntities = new CopyLoadingRequirementToTestCase(destinationClazz, this.daoProviderMap, clipboardPayload, this.activeMilestoneHolder, nodeCopierDto);
        this.strategyCopierService.copyNodeToContainer(destinationId, nodePastes, copyLoadingEntities, nodeCopierDto);
    }

    @Override
    @TransientlyRestore
    public <C extends NodeContainer<TestCaseLibraryNode>> void copyNode(@Id Long destinationId, @ClassType Class<C> destinationClazz, ClipboardPayload clipboardPayload, Map<NodeType, List<Long>> nodePastes) {
        this.strategyCopierService.copyNodeToContainer(destinationId, nodePastes, new CopyLoadingBasicEntities(destinationClazz, this.daoProviderMap, clipboardPayload));
    }

    private NodeCopierDto getNodeCopierDto(ReqToTestCaseConfiguration configuration) {
        NodeCopierDto nodeCopierDto = new NodeCopierDto();
        nodeCopierDto.setTestCaseKind(configuration.getTestCaseKindAsString());
        return nodeCopierDto;
    }
}

