/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Result;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.SprintReqVersionValidationStatus;
import org.squashtest.tm.domain.campaign.SprintRequirementCriticality;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.campaign.SprintStatisticsService;
import org.squashtest.tm.service.internal.repository.SprintStatisticsDao;
import org.squashtest.tm.service.statistics.campaign.CampaignTestCaseSuccessRateStatistics;
import org.squashtest.tm.service.statistics.campaign.TestInventoryStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementBoundTestCasesStatistics;
import org.squashtest.tm.service.statistics.sprint.SprintStatisticsBundle;

@Transactional(readOnly=true)
@Service
public class SprintStatisticsServiceImpl
implements SprintStatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SprintStatisticsServiceImpl.class);
    private static final String UNLINKED_NAME_PLACEHOLDER = "--";
    private final SprintStatisticsDao sprintStatisticsDao;

    public SprintStatisticsServiceImpl(SprintStatisticsDao sprintStatisticsDao) {
        this.sprintStatisticsDao = sprintStatisticsDao;
    }

    @Override
    public SprintStatisticsBundle gatherSprintStatisticsBundle(Long sprintId, String syncPluginId, boolean lastExecutionScope) {
        SprintStatisticsBundle statBundle = new SprintStatisticsBundle();
        boolean hasSyncSprintInPerimeter = Objects.nonNull(syncPluginId);
        List<Long> sprintIds = Collections.singletonList(sprintId);
        this.gatherSprintStatisticsForCharts(sprintIds, statBundle, hasSyncSprintInPerimeter, lastExecutionScope);
        List<TestInventoryStatistics> testInventoryStatistics = this.gatherTestInventoryStatisticsForSprints(sprintIds);
        statBundle.setTestInventoryStatistics(testInventoryStatistics);
        return statBundle;
    }

    @Override
    public SprintStatisticsBundle gatherMultiStatisticsBundle(Map<Long, String> sprintSyncKindBySprintIdMap, boolean lastExecutionScope) {
        SprintStatisticsBundle statBundle = new SprintStatisticsBundle();
        ArrayList<Long> sprintIds = new ArrayList<Long>(sprintSyncKindBySprintIdMap.keySet());
        boolean hasSyncSprintInPerimeter = sprintSyncKindBySprintIdMap.values().stream().anyMatch(Objects::nonNull);
        this.gatherSprintStatisticsForCharts(sprintIds, statBundle, hasSyncSprintInPerimeter, lastExecutionScope);
        List<TestInventoryStatistics> testInventoryStatistics = this.gatherTestInventoryStatisticsForSprintGroups(sprintIds);
        statBundle.setTestInventoryStatistics(testInventoryStatistics);
        return statBundle;
    }

    private void gatherSprintStatisticsForCharts(List<Long> sprintIds, SprintStatisticsBundle statBundle, boolean hasSyncSprintInPerimeter, boolean lastExecutionScope) {
        this.gatherSprintRequirementStatistics(sprintIds, statBundle, hasSyncSprintInPerimeter);
        List<Long> stpiIdsInScope = lastExecutionScope ? this.sprintStatisticsDao.gatherLatestStpiIdsForTCInScopeForSprints(sprintIds) : this.sprintStatisticsDao.gatherStpiIdsForTCInScopeForSprints(sprintIds);
        this.gatherSprintTPIStatistics(stpiIdsInScope, statBundle);
    }

    private void gatherSprintRequirementStatistics(List<Long> sprintIds, SprintStatisticsBundle statBundle, boolean hasSyncSprintInPermiter) {
        EnumMap<SprintReqVersionValidationStatus, Integer> sprintReqVersionValidationStatuses = this.gatherSprintReqVersionValidationStatusStatistics(sprintIds);
        statBundle.setSprintReqVersionValidationStatusStatistics(sprintReqVersionValidationStatuses);
        EnumMap<SprintRequirementCriticality, Integer> unvalidatedRequirementCriticalityStatistics = hasSyncSprintInPermiter ? new EnumMap<SprintRequirementCriticality, Integer>(SprintRequirementCriticality.class) : this.gatherUnvalidatedRequirementCriticalityStatistics(sprintIds);
        statBundle.setUnvalidatedRequirementCriticalityStatistics(unvalidatedRequirementCriticalityStatistics);
        RequirementBoundTestCasesStatistics requirementCoverageStats = this.sprintStatisticsDao.computeRequirementCoverageStatistics(sprintIds);
        statBundle.setRequirementCoverageStatistics(requirementCoverageStats);
    }

    private void gatherSprintTPIStatistics(List<Long> stpiIdsInScope, SprintStatisticsBundle statBundle) {
        Map<ExecutionStatus, Integer> testCaseStatusStatistics = this.gatherTestCaseStatusStatistics(stpiIdsInScope);
        statBundle.setTestCaseStatusStatistics(testCaseStatusStatistics);
        CampaignTestCaseSuccessRateStatistics sprintTCSuccessRateStatistics = this.sprintStatisticsDao.countSprintTestCaseSuccessRate(stpiIdsInScope);
        statBundle.setTestCaseSuccessRateStatistics(sprintTCSuccessRateStatistics);
        Map<TestCaseImportance, Integer> nonExecutedTestCaseImportanceStatistics = this.gatherNonExecutedTestCaseImportanceStatistics(stpiIdsInScope);
        statBundle.setNonExecutedTestCaseImportanceStatistics(nonExecutedTestCaseImportanceStatistics);
    }

    private Map<ExecutionStatus, Integer> gatherTestCaseStatusStatistics(List<Long> stpiIds) {
        Map<ExecutionStatus, Integer> testCaseStatusStatistics = this.sprintStatisticsDao.countExecutionStatuses(stpiIds);
        return ExecutionStatus.getCanonicalStatusSet().stream().sorted(Comparator.comparing(ExecutionStatus::getLevel)).collect(Collectors.toMap(Function.identity(), status -> testCaseStatusStatistics.getOrDefault(status, 0), (value1, value2) -> value2, LinkedHashMap::new));
    }

    private Map<TestCaseImportance, Integer> gatherNonExecutedTestCaseImportanceStatistics(List<Long> stpiIds) {
        Map<TestCaseImportance, Integer> nonExecutedTestCaseImportanceStatistics = this.sprintStatisticsDao.countNonExecutedTestCasesByImportance(stpiIds);
        return Arrays.stream(TestCaseImportance.values()).sorted(Comparator.comparing(TestCaseImportance::getLevel)).collect(Collectors.toMap(Function.identity(), importance -> nonExecutedTestCaseImportanceStatistics.getOrDefault(importance, 0), (value1, value2) -> value2, LinkedHashMap::new));
    }

    private List<TestInventoryStatistics> gatherTestInventoryStatisticsForSprints(List<Long> sprintIds) {
        Result<Record4<Long, String, String, Integer>> resultList = this.sprintStatisticsDao.fetchTestInventoryStatisticsForSprints(sprintIds);
        return this.postProcessTestInventoryStatisticsIntoMap(resultList);
    }

    private List<TestInventoryStatistics> gatherTestInventoryStatisticsForSprintGroups(List<Long> sprintIds) {
        Result<Record4<Long, String, String, Integer>> resultList = this.sprintStatisticsDao.fetchTestInventoryStatisticsForSprintGroups(sprintIds);
        return this.postProcessTestInventoryStatisticsIntoMap(resultList);
    }

    private List<TestInventoryStatistics> postProcessTestInventoryStatisticsIntoMap(Result<Record4<Long, String, String, Integer>> resultList) {
        HashMap<Long, TestInventoryStatistics> statsMap = new HashMap<Long, TestInventoryStatistics>();
        for (Record4 record : resultList) {
            Long id = (Long)record.value1();
            String name = (String)record.value2();
            String executionStatus = (String)record.value3();
            Integer count = (Integer)record.value4();
            statsMap.computeIfAbsent(id, key -> {
                TestInventoryStatistics stats = new TestInventoryStatistics();
                stats.setName(name != null ? name : UNLINKED_NAME_PLACEHOLDER);
                return stats;
            });
            if (executionStatus == null || count == null) continue;
            ((TestInventoryStatistics)statsMap.get(id)).setNumber(count, ExecutionStatus.valueOf((String)executionStatus));
        }
        return statsMap.values().stream().sorted(Comparator.comparing(TestInventoryStatistics::getName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER))).toList();
    }

    private EnumMap<SprintReqVersionValidationStatus, Integer> gatherSprintReqVersionValidationStatusStatistics(List<Long> sprintIds) {
        EnumMap<SprintReqVersionValidationStatus, Integer> validationStatusCountEnumMap = new EnumMap<SprintReqVersionValidationStatus, Integer>(SprintReqVersionValidationStatus.class);
        Map<SprintReqVersionValidationStatus, Integer> rawValidationStatusCountMap = this.sprintStatisticsDao.countSprintRequirementsByValidationStatuses(sprintIds);
        SprintReqVersionValidationStatus[] sprintReqVersionValidationStatusArray = SprintReqVersionValidationStatus.values();
        int n = sprintReqVersionValidationStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            SprintReqVersionValidationStatus status = sprintReqVersionValidationStatusArray[n2];
            validationStatusCountEnumMap.put(status, rawValidationStatusCountMap.getOrDefault(status, 0));
            ++n2;
        }
        return validationStatusCountEnumMap;
    }

    protected EnumMap<SprintRequirementCriticality, Integer> gatherUnvalidatedRequirementCriticalityStatistics(List<Long> sprintIds) {
        Result<Record2<String, Integer>> rawCriticalityCountResult = this.sprintStatisticsDao.countUnvalidatedSprintRequirementsByCriticality(sprintIds);
        return this.processCriticalityCountsIntoMap(rawCriticalityCountResult);
    }

    private EnumMap<SprintRequirementCriticality, Integer> processCriticalityCountsIntoMap(Result<Record2<String, Integer>> rawCriticalityCountResult) {
        EnumMap<SprintRequirementCriticality, Integer> requirementCriticalityCountMap = new EnumMap<SprintRequirementCriticality, Integer>(SprintRequirementCriticality.class);
        SprintRequirementCriticality[] sprintRequirementCriticalityArray = SprintRequirementCriticality.values();
        int n = sprintRequirementCriticalityArray.length;
        int n2 = 0;
        while (n2 < n) {
            SprintRequirementCriticality value = sprintRequirementCriticalityArray[n2];
            requirementCriticalityCountMap.put(value, 0);
            ++n2;
        }
        HashMap<String, SprintRequirementCriticality> enumCache = new HashMap<String, SprintRequirementCriticality>();
        for (Record2 record : rawCriticalityCountResult) {
            String rawValue = (String)record.value1();
            int count = record.value2() != null ? (Integer)record.value2() : 0;
            SprintRequirementCriticality criticality = enumCache.computeIfAbsent(rawValue, val -> {
                try {
                    return SprintRequirementCriticality.valueOf((String)val.toUpperCase());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    LOGGER.warn("Unknown requirement criticality: {}", new Object[]{val});
                    return SprintRequirementCriticality.UNKNOWN;
                }
            });
            requirementCriticalityCountMap.merge(criticality, count, Integer::sum);
        }
        return requirementCriticalityCountMap;
    }
}

