/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.persistence.EntityManager;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CreateExecutionFromTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.execution.TestPlanItemNotExecutableException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;

public abstract class AbstractExecutionCreation {
    protected final EntityManager entityManager;
    protected final AttachmentManagerService attachmentManagerService;

    protected AbstractExecutionCreation(EntityManager entityManager, AttachmentManagerService attachmentManagerService) {
        this.entityManager = entityManager;
        this.attachmentManagerService = attachmentManagerService;
    }

    protected Execution createExecution(TestPlanItem item, MessageSource messageSource, Locale locale) {
        CreateExecutionFromTestCaseVisitor createExecutionVisitor = new CreateExecutionFromTestCaseVisitor(item.getReferencedDataset(), messageSource, locale);
        return this.createExecution(createExecutionVisitor, item);
    }

    protected Execution createExecution(TestPlanItem item) {
        CreateExecutionFromTestCaseVisitor createExecutionVisitor = new CreateExecutionFromTestCaseVisitor(item.getReferencedDataset());
        return this.createExecution(createExecutionVisitor, item);
    }

    private Execution createExecution(CreateExecutionFromTestCaseVisitor createExecutionVisitor, TestPlanItem item) {
        if (item.isTestCaseDeleted()) {
            throw new TestPlanItemNotExecutableException("Cannot create the execution: the referenced test case has been deleted.");
        }
        item.getReferencedTestCase().accept((TestCaseVisitor)createExecutionVisitor);
        Execution execution = createExecutionVisitor.getCreatedExecution();
        this.handleAttachment(execution);
        return execution;
    }

    private void handleAttachment(Execution execution) {
        this.entityManager.persist((Object)execution.getAttachmentList());
        this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)execution);
        this.updateExecutionRichTextFromTestCase(execution);
        for (ExecutionStep executionStep : execution.getSteps()) {
            this.entityManager.persist((Object)executionStep.getAttachmentList());
            this.attachmentManagerService.copyContentsOnExternalRepository((AttachmentHolder)executionStep);
            this.updateExecutionStepRichTextFromTestCase(executionStep);
        }
    }

    private void updateExecutionRichTextFromTestCase(Execution execution) {
        if (execution.getReferencedTestCase() == null) {
            return;
        }
        String tcDescription = execution.getTcdescription();
        execution.setTcdescription(this.attachmentManagerService.handleRichTextAttachments(execution.getReferencedTestCase().getAttachmentList(), execution.getAttachmentList(), tcDescription));
        String prerequisite = execution.getPrerequisite();
        execution.setPrerequisite(this.attachmentManagerService.handleRichTextAttachments(execution.getReferencedTestCase().getAttachmentList(), execution.getAttachmentList(), prerequisite));
    }

    private void updateExecutionStepRichTextFromTestCase(ExecutionStep executionStep) {
        TestStep testStep;
        if (executionStep.getReferencedTestStep() != null && (testStep = executionStep.getReferencedTestStep()) instanceof ActionTestStep) {
            ActionTestStep actionTestStep = (ActionTestStep)testStep;
            String action = executionStep.getAction();
            executionStep.setAction(this.attachmentManagerService.handleRichTextAttachments(actionTestStep.getAttachmentList(), executionStep.getAttachmentList(), action));
            String expectedResult = executionStep.getExpectedResult();
            executionStep.setExpectedResult(this.attachmentManagerService.handleRichTextAttachments(actionTestStep.getAttachmentList(), executionStep.getAttachmentList(), expectedResult));
        }
    }
}

