/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.UnknownConnectorKindException;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.bugtracker.CustomBugTrackerModificationService;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.internal.bugtracker.adapter.InternalBugtrackerConnector;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service(value="CustomBugTrackerModificationService")
@Transactional
public class CustomBugTrackerModificationServiceImpl
implements CustomBugTrackerModificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomBugTrackerModificationServiceImpl.class);
    @Inject
    private BugTrackerDao bugTrackerDao;
    @Inject
    private StoredCredentialsManager credentialsManager;
    @Inject
    private BugTrackerConnectorFactory connectorFactory;
    @Inject
    private BugTrackersService btService;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeUrl(long bugtrackerId, String url) {
        BugTracker bugTracker = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        bugTracker.setUrl(url);
        this.refreshCacheForBugTracker(bugTracker);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeName(long bugtrackerId, String newName) {
        String trimedNewName = newName.trim();
        BugTracker bugTracker = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        if (!bugTracker.getName().equals(trimedNewName)) {
            BugTracker existing = this.bugTrackerDao.findByName(trimedNewName);
            if (existing == null) {
                bugTracker.setName(trimedNewName);
            } else {
                throw new NameAlreadyInUseException(NameAlreadyInUseException.EntityType.BUG_TRACKER, trimedNewName);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void storeCredentials(long serverId, ManageableCredentials credentials) {
        this.credentialsManager.storeAppLevelCredentials(serverId, credentials);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ManageableCredentials findCredentials(long serverId) {
        return this.credentialsManager.findAppLevelCredentials(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteCredentials(long serverId) {
        this.credentialsManager.deleteAppLevelCredentials(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AuthenticationProtocol[] getSupportedProtocols(BugTracker bugtracker) {
        InternalBugtrackerConnector connector = this.connectorFactory.createConnector(bugtracker);
        return connector.getSupportedAuthProtocols();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeAuthenticationPolicy(long bugtrackerId, AuthenticationPolicy policy) {
        BugTracker tracker = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        tracker.setAuthenticationPolicy(policy);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeAuthenticationProtocol(long bugtrackerId, AuthenticationProtocol protocol) {
        BugTracker tracker = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        this.changeAuthenticationProtocol(tracker, protocol);
    }

    private void changeAuthenticationProtocol(BugTracker tracker, AuthenticationProtocol protocol) {
        tracker.setAuthenticationProtocol(protocol);
        this.credentialsManager.deleteAppLevelCredentials(tracker.getId());
        this.credentialsManager.deleteAllServerCredentials(Collections.singletonList(tracker.getId()));
        this.credentialsManager.deleteServerAuthConfiguration(tracker.getId());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void testCredentials(long bugtrackerId, ManageableCredentials credentials) {
        BugTracker bt = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        Credentials usableCredentials = credentials.build(this.credentialsManager, (ThirdPartyServer)bt, null);
        if (usableCredentials == null) {
            throw new BugTrackerNoCredentialsException("credentials could not be built, either because the credentials themselves are not suitable, or because the protocol configuration is incomplete/invalid", null);
        }
        this.btService.testCredentials(bt, usableCredentials);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @UsedInPlugin(names={PluginName.API_REST_ADMIN})
    public void storeAuthConfiguration(long serverId, ServerAuthConfiguration conf) {
        this.credentialsManager.storeServerAuthConfiguration(serverId, conf);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ServerAuthConfiguration findAuthConfiguration(long serverId) {
        return this.credentialsManager.findServerAuthConfiguration(serverId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeKind(long bugtrackerId, String kind) {
        BugTracker tracker = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        tracker.setKind(kind);
        AuthenticationProtocol[] supportedProtocols = this.getSupportedProtocols(tracker);
        if (supportedProtocols.length != 0 && !this.isTrackerProtocolSupported(tracker, supportedProtocols)) {
            this.changeAuthenticationProtocol(tracker, supportedProtocols[0]);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void updateDescription(long bugtrackerId, String description) {
        BugTracker bugTracker = (BugTracker)this.bugTrackerDao.getReferenceById(bugtrackerId);
        bugTracker.setDescription(description);
    }

    private boolean isTrackerProtocolSupported(BugTracker tracker, AuthenticationProtocol[] supportedProtocols) {
        return Arrays.asList(supportedProtocols).contains(tracker.getAuthenticationProtocol());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void storeCacheCredentials(long serverId, ManageableCredentials credentials) {
        Optional bugTracker = this.bugTrackerDao.findById(serverId);
        if (!bugTracker.isPresent()) {
            throw new BugTrackerLocalException("No bug tracker found with id " + serverId, null);
        }
        this.credentialsManager.storeReportingCacheCredentials(serverId, credentials);
        this.refreshCacheForBugTracker((BugTracker)bugTracker.get());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteCacheCredentials(long bugTrackerId) {
        this.credentialsManager.deleteReportingCacheCredentials(bugTrackerId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void refreshCacheForProject(long projectId) {
        BugTracker bugTracker = this.bugTrackerDao.findByProjectId(projectId);
        if (bugTracker == null) {
            return;
        }
        this.performWithConnector(bugTracker, connector -> connector.refreshCacheForProject(bugTracker, projectId));
    }

    private void refreshCacheForBugTracker(@NotNull BugTracker bugTracker) {
        BugTracker bugTracker2 = bugTracker;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)bugTracker2);
        this.performWithConnector(bugTracker, connector -> connector.refreshCacheForBugTracker(bugTracker));
    }

    private void performWithConnector(@NotNull BugTracker bugTracker, @NotNull Consumer<InternalBugtrackerConnector> consumer) {
        Consumer<InternalBugtrackerConnector> consumer2 = consumer;
        BugTracker bugTracker2 = bugTracker;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)bugTracker2);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5(consumer2);
        try {
            InternalBugtrackerConnector connector = this.connectorFactory.createConnector(bugTracker);
            consumer.accept(connector);
        }
        catch (UnknownConnectorKindException e) {
            LOGGER.warn("Could not refresh cache for bug tracker with id {}", new Object[]{bugTracker.getId(), e});
        }
    }
}

