/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.internal.repository.TestCaseStatisticsDao;
import org.squashtest.tm.service.statistics.testcase.TestCaseBoundRequirementsStatistics;
import org.squashtest.tm.service.statistics.testcase.TestCaseImportanceStatistics;
import org.squashtest.tm.service.statistics.testcase.TestCaseSizeStatistics;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatisticsBundle;
import org.squashtest.tm.service.statistics.testcase.TestCaseStatusesStatistics;
import org.squashtest.tm.service.testcase.TestCaseStatisticsService;

@Service(value="TestCaseStatisticsService")
@Transactional(readOnly=true)
public class TestCaseStatisticsServiceImpl
implements TestCaseStatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseStatisticsServiceImpl.class);
    private final TestCaseStatisticsDao testCaseStatisticsDao;

    public TestCaseStatisticsServiceImpl(TestCaseStatisticsDao testCaseStatisticsDao) {
        this.testCaseStatisticsDao = testCaseStatisticsDao;
    }

    @Override
    public TestCaseStatisticsBundle gatherTestCaseStatisticsBundle(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        List<Long> testCaseIds = this.testCaseStatisticsDao.countTestCaseInScope(testCaseLibraryIds, testCaseNodeIds);
        TestCaseBoundRequirementsStatistics reqs = this.gatherBoundRequirementStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseImportanceStatistics imp = this.gatherTestCaseImportanceStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseStatusesStatistics status = this.gatherTestCaseStatusesStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseSizeStatistics size = this.gatherTestCaseSizeStatistics(testCaseLibraryIds, testCaseNodeIds);
        return new TestCaseStatisticsBundle(reqs, imp, status, size, testCaseIds);
    }

    private TestCaseBoundRequirementsStatistics gatherBoundRequirementStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        if (this.isScopeEmpty(testCaseLibraryIds, testCaseNodeIds)) {
            return new TestCaseBoundRequirementsStatistics();
        }
        Map<Integer, Integer> countBySizeClass = this.testCaseStatisticsDao.gatherBoundRequirementStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseBoundRequirementsStatistics stats = new TestCaseBoundRequirementsStatistics();
        for (Map.Entry<Integer, Integer> sizeClassCount : countBySizeClass.entrySet()) {
            Integer sizeClass = sizeClassCount.getKey();
            Integer count = sizeClassCount.getValue();
            switch (sizeClass) {
                case 0: {
                    stats.setZeroRequirements(count);
                    break;
                }
                case 1: {
                    stats.setOneRequirement(count);
                    break;
                }
                case 2: {
                    stats.setManyRequirements(count);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TestCaseStatisticsServiceImpl#gatherBoundRequirementStatistics : there should not be a sizeclass <0 or >2. It's a bug.");
                }
            }
        }
        return stats;
    }

    private TestCaseImportanceStatistics gatherTestCaseImportanceStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        if (this.isScopeEmpty(testCaseLibraryIds, testCaseNodeIds)) {
            return new TestCaseImportanceStatistics();
        }
        Map<String, Integer> cardinalityByImportance = this.testCaseStatisticsDao.gatherTestCaseImportanceStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseImportanceStatistics stats = new TestCaseImportanceStatistics();
        for (Map.Entry<String, Integer> importanceCardinality : cardinalityByImportance.entrySet()) {
            TestCaseImportance importance = TestCaseImportance.valueOf((String)importanceCardinality.getKey());
            Integer cardinality = importanceCardinality.getValue();
            switch (importance) {
                case VERY_HIGH: {
                    stats.setVeryHigh(cardinality);
                    break;
                }
                case HIGH: {
                    stats.setHigh(cardinality);
                    break;
                }
                case MEDIUM: {
                    stats.setMedium(cardinality);
                    break;
                }
                case LOW: {
                    stats.setLow(cardinality);
                    break;
                }
                default: {
                    LOGGER.warn("TestCaseStatisticsService cannot handle the following TestCaseImportance value: '{}'", new Object[]{importanceCardinality.getKey()});
                }
            }
        }
        return stats;
    }

    private TestCaseStatusesStatistics gatherTestCaseStatusesStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        if (this.isScopeEmpty(testCaseLibraryIds, testCaseNodeIds)) {
            return new TestCaseStatusesStatistics();
        }
        Map<String, Integer> statusByCardinality = this.testCaseStatisticsDao.gatherTestCaseStatusesStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseStatusesStatistics stats = new TestCaseStatusesStatistics();
        for (Map.Entry<String, Integer> statusCardinality : statusByCardinality.entrySet()) {
            TestCaseStatus status = TestCaseStatus.valueOf((String)statusCardinality.getKey());
            Integer cardinality = statusCardinality.getValue();
            switch (status) {
                case WORK_IN_PROGRESS: {
                    stats.setWorkInProgress(cardinality);
                    break;
                }
                case APPROVED: {
                    stats.setApproved(cardinality);
                    break;
                }
                case OBSOLETE: {
                    stats.setObsolete(cardinality);
                    break;
                }
                case TO_BE_UPDATED: {
                    stats.setToBeUpdated(cardinality);
                    break;
                }
                case UNDER_REVIEW: {
                    stats.setUnderReview(cardinality);
                    break;
                }
            }
        }
        return stats;
    }

    private TestCaseSizeStatistics gatherTestCaseSizeStatistics(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        if (this.isScopeEmpty(testCaseLibraryIds, testCaseNodeIds)) {
            return new TestCaseSizeStatistics();
        }
        Map<Integer, Integer> countBySizeClass = this.testCaseStatisticsDao.gatherTestCaseSizeStatistics(testCaseLibraryIds, testCaseNodeIds);
        TestCaseSizeStatistics stats = new TestCaseSizeStatistics();
        for (Map.Entry<Integer, Integer> sizeClassCount : countBySizeClass.entrySet()) {
            Integer sizeClass = sizeClassCount.getKey();
            Integer count = sizeClassCount.getValue();
            switch (sizeClass) {
                case 0: {
                    stats.setZeroSteps(count);
                    break;
                }
                case 1: {
                    stats.setBetween0And10Steps(count);
                    break;
                }
                case 2: {
                    stats.setBetween11And20Steps(count);
                    break;
                }
                case 3: {
                    stats.setAbove20Steps(count);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("TestCaseStatisticsServiceImpl#gatherTestCaseSizeStatistics : there should not be a sizeclass <0 or >3. It's a bug.");
                }
            }
        }
        return stats;
    }

    private boolean isScopeEmpty(Collection<Long> testCaseLibraryIds, Collection<Long> testCaseNodeIds) {
        return testCaseLibraryIds.isEmpty() && testCaseNodeIds.isEmpty();
    }
}

