/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.system;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.annotation.CleanHtml;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.AdministrationStatistics;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.WrongUrlException;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.repository.AdministrationDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl$AjcClosure11;
import org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl$AjcClosure9;
import org.squashtest.tm.service.license.LicenseInfoExtender;
import org.squashtest.tm.service.system.BasicLicenseInfo;
import org.squashtest.tm.service.system.SystemAdministrationService;

@Service(value="squashtest.tm.service.SystemAdministrationService")
@Transactional
public class SystemAdministrationServiceImpl
implements SystemAdministrationService {
    private static final Logger LOGGER;
    private final AdministrationDao adminDao;
    private final ConfigurationService configurationService;
    private final ApplicationContext appContext;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private List<String> allPluginsAtStart;
    @Autowired(required=false)
    private List<LicenseInfoExtender> licenseInfoExtenders = Collections.emptyList();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        SystemAdministrationServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SystemAdministrationServiceImpl.class);
    }

    public SystemAdministrationServiceImpl(AdministrationDao adminDao, ConfigurationService configurationService, ApplicationContext appContext, RemoteSynchronisationDao remoteSynchronisationDao, List<LicenseInfoExtender> licenseInfoExtenders) {
        this.adminDao = adminDao;
        this.configurationService = configurationService;
        this.appContext = appContext;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.licenseInfoExtenders = licenseInfoExtenders;
    }

    @PostConstruct
    public void init() {
        this.allPluginsAtStart = this.findAllPluginsFilesOnInstance();
    }

    @Override
    public AdministrationStatistics findAdministrationStatistics() {
        return this.adminDao.findAdministrationStatistics();
    }

    @Override
    @CleanHtml
    public String findLoginMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SystemAdministrationServiceImpl$AjcClosure1 systemAdministrationServiceImpl$AjcClosure1 = new SystemAdministrationServiceImpl$AjcClosure1(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(systemAdministrationServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_INFRASTRUCTURE_ADMIN')")
    public String changeLoginMessage(@CleanHtml String loginMessage) {
        String string = loginMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        SystemAdministrationServiceImpl$AjcClosure3 systemAdministrationServiceImpl$AjcClosure3 = new SystemAdministrationServiceImpl$AjcClosure3(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(systemAdministrationServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @CleanHtml
    public String findWelcomeMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SystemAdministrationServiceImpl$AjcClosure5 systemAdministrationServiceImpl$AjcClosure5 = new SystemAdministrationServiceImpl$AjcClosure5(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(systemAdministrationServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_INFRASTRUCTURE_ADMIN')")
    public String changeWelcomeMessage(@CleanHtml String welcomeMessage) {
        String string = welcomeMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        SystemAdministrationServiceImpl$AjcClosure7 systemAdministrationServiceImpl$AjcClosure7 = new SystemAdministrationServiceImpl$AjcClosure7(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(systemAdministrationServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @CleanHtml
    public String findBannerMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SystemAdministrationServiceImpl$AjcClosure9 systemAdministrationServiceImpl$AjcClosure9 = new SystemAdministrationServiceImpl$AjcClosure9(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(systemAdministrationServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String changeBannerMessage(@CleanHtml String bannerMessage) {
        String string = bannerMessage;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        SystemAdministrationServiceImpl$AjcClosure11 systemAdministrationServiceImpl$AjcClosure11 = new SystemAdministrationServiceImpl$AjcClosure11(objectArray);
        return (String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(systemAdministrationServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_INFRASTRUCTURE_ADMIN')")
    public String findCallbackUrl() {
        return this.configurationService.findConfiguration("squashtest.tm.callbackurl");
    }

    @Override
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void changeCallbackUrl(String callbackUrl) {
        if (!StringUtils.hasText((String)callbackUrl)) {
            throw new WrongUrlException("callbackUrl", (Throwable)new IllegalArgumentException("callbackUrl is empty or null"));
        }
        try {
            new URI(callbackUrl);
        }
        catch (URISyntaxException ex) {
            throw new WrongUrlException("callbackUrl", (Throwable)ex);
        }
        this.configurationService.set("squashtest.tm.callbackurl", callbackUrl);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String findWhiteList() {
        return this.configurationService.findConfiguration("uploadfilter.fileExtensions.whitelist");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeWhiteList(String whiteList) {
        this.configurationService.set("uploadfilter.fileExtensions.whitelist", whiteList);
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_INFRASTRUCTURE_ADMIN')")
    public String findImportSizeLimit() {
        return this.configurationService.findConfiguration("uploadfilter.upload.import.sizeLimitInBytes");
    }

    @Override
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void changeImportSizeLimit(String sizeLimit) {
        this.configurationService.set("uploadfilter.upload.import.sizeLimitInBytes", sizeLimit);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String findDeletionThreshold() {
        return this.configurationService.findConfiguration("squash.control.deletion.threshold");
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void changeDeletionThreshold(String deletionThreshold) {
        this.configurationService.set("squash.control.deletion.threshold", deletionThreshold);
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_ADMIN', 'ROLE_INFRASTRUCTURE_ADMIN')")
    public String findUploadSizeLimit() {
        return this.configurationService.findConfiguration("uploadfilter.upload.sizeLimitInBytes");
    }

    @Override
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void changeUploadSizeLimit(String sizeLimit) {
        this.configurationService.set("uploadfilter.upload.sizeLimitInBytes", sizeLimit);
    }

    @Override
    public List<String> findAllPluginsFilesOnInstance() {
        String pluginPathProperty = "squash.path.plugins-path";
        String pluginsPath = this.appContext.getEnvironment().getProperty(pluginPathProperty);
        if (pluginsPath == null) {
            LOGGER.warn("Plugin path was not defined, I don't know where to look for plugins", new Object[0]);
            return null;
        }
        File pluginsFolder = new File(pluginsPath);
        if (!pluginsFolder.exists() || !pluginsFolder.isDirectory()) {
            LOGGER.warn("Plugin path '{}' is not a readable folder. There will be no plugins", new Object[]{pluginsFolder.getAbsolutePath()});
            return null;
        }
        LOGGER.info("Enumerating plugins / jars in folder '{}'", new Object[]{pluginsFolder.getAbsolutePath()});
        File[] jarFiles = FileUtils.listFiles((File)pluginsFolder, (String[])new String[]{"jar"}, (boolean)true).toArray(new File[0]);
        if (jarFiles != null) {
            return Arrays.stream(jarFiles).map(File::getName).toList();
        }
        return new ArrayList<String>();
    }

    @Override
    public BasicLicenseInfo getBasicLicenseInfo() {
        LicenseInfoExtender firstLicenseInfoExtender = this.licenseInfoExtenders.stream().findFirst().orElse(null);
        if (firstLicenseInfoExtender != null) {
            return firstLicenseInfoExtender.getBasicLicenseInfo();
        }
        return null;
    }

    @Override
    public List<String> findAllPluginsAtStart() {
        return this.allPluginsAtStart;
    }

    @Override
    public List<RemoteSynchronisation> findRemoteSynchronisationForPlugin(List<Long> manageableProjectIds, String pluginId) {
        return this.remoteSynchronisationDao.findByProjectIdInAndKind(manageableProjectIds, pluginId);
    }

    static final /* synthetic */ String findLoginMessage_aroundBody0(SystemAdministrationServiceImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.configurationService.findConfiguration("LOGIN_MESSAGE");
    }

    static final /* synthetic */ String changeLoginMessage_aroundBody2(SystemAdministrationServiceImpl ajc$this, String loginMessage, JoinPoint joinPoint) {
        ajc$this.configurationService.checkSizeValidity("LOGIN_MESSAGE", loginMessage);
        ajc$this.configurationService.set("LOGIN_MESSAGE", loginMessage);
        return loginMessage;
    }

    static final /* synthetic */ String findWelcomeMessage_aroundBody4(SystemAdministrationServiceImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.configurationService.findConfiguration("WELCOME_MESSAGE");
    }

    static final /* synthetic */ String changeWelcomeMessage_aroundBody6(SystemAdministrationServiceImpl ajc$this, String welcomeMessage, JoinPoint joinPoint) {
        ajc$this.configurationService.checkSizeValidity("WELCOME_MESSAGE", welcomeMessage);
        ajc$this.configurationService.set("WELCOME_MESSAGE", welcomeMessage);
        return welcomeMessage;
    }

    static final /* synthetic */ String findBannerMessage_aroundBody8(SystemAdministrationServiceImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.configurationService.findConfiguration("BANNER_MESSAGE");
    }

    static final /* synthetic */ String changeBannerMessage_aroundBody10(SystemAdministrationServiceImpl ajc$this, String bannerMessage, JoinPoint joinPoint) {
        ajc$this.configurationService.checkSizeValidity("BANNER_MESSAGE", bannerMessage);
        ajc$this.configurationService.set("BANNER_MESSAGE", bannerMessage);
        return bannerMessage;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SystemAdministrationServiceImpl.java", SystemAdministrationServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findLoginMessage", "org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl", "", "", "", "java.lang.String"), 97);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "changeLoginMessage", "org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl", "java.lang.String", "loginMessage", "", "java.lang.String"), 103);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findWelcomeMessage", "org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl", "", "", "", "java.lang.String"), 112);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "changeWelcomeMessage", "org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl", "java.lang.String", "welcomeMessage", "", "java.lang.String"), 118);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findBannerMessage", "org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl", "", "", "", "java.lang.String"), 127);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "changeBannerMessage", "org.squashtest.tm.service.internal.system.SystemAdministrationServiceImpl", "java.lang.String", "bannerMessage", "", "java.lang.String"), 133);
    }
}

