/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Row2;
import org.jooq.Row3;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.ActivePermissionRecord;
import org.squashtest.tm.service.internal.display.dto.ProfileActivePermissionsRecord;
import org.squashtest.tm.service.internal.repository.CustomProfileDao;

public class ProfileDaoImpl
implements CustomProfileDao {
    private final DSLContext dslContext;

    public ProfileDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public Long findByQualifiedName(String qualifiedName) {
        return (Long)this.dslContext.select((SelectField)Tables.ACL_GROUP.ID).from((TableLike)Tables.ACL_GROUP).where(Tables.ACL_GROUP.QUALIFIED_NAME.eq((Object)qualifiedName)).fetchOneInto(Long.class);
    }

    @Override
    public boolean isProfileUsed(long profileId) {
        return this.dslContext.fetchExists((Select)this.dslContext.selectDistinct((SelectField)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Object)profileId)));
    }

    @Override
    public Set<String> findProfileNamesByPartyId(long teamId) {
        return this.dslContext.select((SelectField)Tables.ACL_GROUP.QUALIFIED_NAME).from((TableLike)Tables.ACL_GROUP).join((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_GROUP.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Object)teamId)).fetchSet((Field)Tables.ACL_GROUP.QUALIFIED_NAME);
    }

    @Override
    public Map<Long, List<String>> findProfileNamesByPartyIds(List<Long> teamIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID, (SelectField)Tables.ACL_GROUP.QUALIFIED_NAME).from((TableLike)Tables.ACL_GROUP).join((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_GROUP.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(teamIds)).fetchGroups((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID, (Field)Tables.ACL_GROUP.QUALIFIED_NAME);
    }

    @Override
    public void updatePermissions(long profileId, List<ProfileActivePermissionsRecord> records) {
        Map aclClassByNames = this.dslContext.selectFrom((TableLike)Tables.ACL_CLASS).fetchMap((Field)Tables.ACL_CLASS.CLASSNAME, (Field)Tables.ACL_CLASS.ID);
        List<Pair<String, Integer>> toDelete = this.getPermissionsToDelete(records);
        List<Triple<Long, String, Integer>> toInsert = this.getPermissionsToInsert(profileId, records);
        if (!toInsert.isEmpty()) {
            this.insertPermissions(toInsert, aclClassByNames);
        }
        if (!toDelete.isEmpty()) {
            this.deletePermissions(profileId, toDelete, aclClassByNames);
        }
    }

    private List<Pair<String, Integer>> getPermissionsToDelete(List<ProfileActivePermissionsRecord> records) {
        return records.stream().flatMap(record -> record.permissions().stream().filter(permissionRecord -> !permissionRecord.active()).map(permissionRecord -> Pair.of((Object)record.className(), (Object)permissionRecord.permission().getMask()))).toList();
    }

    private List<Triple<Long, String, Integer>> getPermissionsToInsert(long profileId, List<ProfileActivePermissionsRecord> records) {
        return records.stream().flatMap(record -> record.permissions().stream().filter(ActivePermissionRecord::active).map(permissionRecord -> Triple.of((Object)profileId, (Object)record.className(), (Object)permissionRecord.permission().getMask()))).toList();
    }

    private void insertPermissions(List<Triple<Long, String, Integer>> toInsert, Map<String, Long> aclClassByNames) {
        List<Row3> valuesToInsert = toInsert.stream().map(triple -> DSL.row((Object)((Long)triple.getLeft()), (Object)((Long)aclClassByNames.get(triple.getMiddle())), (Object)((Integer)triple.getRight()))).toList();
        this.dslContext.insertInto((Table)Tables.ACL_GROUP_PERMISSION, (Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID, (Field)Tables.ACL_GROUP_PERMISSION.CLASS_ID, (Field)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK).valuesOfRows(valuesToInsert).onDuplicateKeyIgnore().execute();
    }

    private void deletePermissions(long profileId, List<Pair<String, Integer>> toDelete, Map<String, Long> aclClassByNames) {
        List<Row2> valuesToDelete = toDelete.stream().map(pair -> DSL.row((Object)((Long)aclClassByNames.get(pair.getLeft())), (Object)((Integer)pair.getRight()))).toList();
        this.dslContext.deleteFrom((Table)Tables.ACL_GROUP_PERMISSION).where(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Object)profileId).and(DSL.row((SelectField)Tables.ACL_GROUP_PERMISSION.CLASS_ID, (SelectField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK).in(valuesToDelete))).execute();
    }
}

