/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.copier.RequirementWorkspaceStrategyCopierService;
import org.squashtest.tm.service.copier.StrategyCopierService;
import org.squashtest.tm.service.internal.copier.copyloading.CopyLoadingBasicEntities;
import org.squashtest.tm.service.internal.repository.EntityDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;

@Service
@Transactional
public class RequirementWorkspaceStrategyCopierServiceImpl
implements RequirementWorkspaceStrategyCopierService {
    private final StrategyCopierService strategyCopierService;
    private final Map<EntityType, EntityDao<?>> daoProviderMap;
    private final RequirementDao requirementDao;
    private final RequirementFolderDao requirementFolderDao;
    private final RequirementLibraryDao requirementLibraryDao;

    public RequirementWorkspaceStrategyCopierServiceImpl(StrategyCopierService strategyCopierService, RequirementDao requirementDao, RequirementFolderDao requirementFolderDao, RequirementLibraryDao requirementLibraryDao) {
        this.strategyCopierService = strategyCopierService;
        this.requirementDao = requirementDao;
        this.requirementFolderDao = requirementFolderDao;
        this.requirementLibraryDao = requirementLibraryDao;
        this.daoProviderMap = this.getDaoProviderMap();
    }

    private Map<EntityType, EntityDao<?>> getDaoProviderMap() {
        return Map.of(EntityType.HIGH_LEVEL_REQUIREMENT, this.requirementDao, EntityType.REQUIREMENT, this.requirementDao, EntityType.REQUIREMENT_FOLDER, this.requirementFolderDao, EntityType.REQUIREMENT_LIBRARY, this.requirementLibraryDao);
    }

    @Override
    public Map<NodeType, List<Long>> verifyPermission(ClipboardPayload clipboardPayload) {
        Map<NodeType, List<Long>> nodePastes = this.strategyCopierService.getNodeIdsByNodeTypeToPaste(clipboardPayload);
        if (nodePastes.containsKey(NodeType.HIGH_LEVEL_REQUIREMENT)) {
            List<Long> highLevelRequirementIds = nodePastes.remove(NodeType.HIGH_LEVEL_REQUIREMENT);
            nodePastes.computeIfAbsent(NodeType.REQUIREMENT, k -> new ArrayList()).addAll(highLevelRequirementIds);
        }
        this.strategyCopierService.verifyPermission(nodePastes);
        return nodePastes;
    }

    @Override
    public <N extends RequirementLibraryNode<?>, C extends NodeContainer<N>> void copyNode(Long destinationId, Class<C> destinationClazz, ClipboardPayload clipboardPayload, Map<NodeType, List<Long>> nodePastes) {
        this.copyNodeToContainer(destinationId, clipboardPayload, nodePastes, destinationClazz);
    }

    private <N extends RequirementLibraryNode<?>, C extends NodeContainer<N>> void copyNodeToContainer(Long destinationId, ClipboardPayload clipboardPayload, Map<NodeType, List<Long>> nodePastes, Class<C> containerClass) {
        this.strategyCopierService.copyNodeToContainer(destinationId, nodePastes, new CopyLoadingBasicEntities(containerClass, this.daoProviderMap, clipboardPayload));
    }
}

