/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation;

import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.testautomation.model.IterationTestPlanItemWithCustomFields;

public class BuildDef {
    private final TestAutomationServer server;
    private final TokenAuthCredentials credentials;
    private final String namespace;
    private final Collection<IterationTestPlanItemWithCustomFields> parameterizedItems;

    public BuildDef(@NotNull TestAutomationServer server, TokenAuthCredentials credentials, String namespace, @NotNull List<IterationTestPlanItemWithCustomFields> parameterizedItems) {
        this.server = server;
        this.namespace = namespace;
        this.parameterizedItems = Collections.unmodifiableList(parameterizedItems);
        this.credentials = credentials;
    }

    public TestAutomationServer getServer() {
        return this.server;
    }

    public TokenAuthCredentials getCredentials() {
        return this.credentials;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Collection<IterationTestPlanItemWithCustomFields> getParameterizedItems() {
        return this.parameterizedItems;
    }

    public Long getProjectId() {
        return this.parameterizedItems.stream().findFirst().map(item -> item.getIterationTestPlanItem().getReferencedTestCase().getProject().getId()).orElse(null);
    }
}

