/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.service.internal.repository.CustomTestSuiteDao;
import org.squashtest.tm.service.statistics.CountOnEnum;

@Repository
public class TestSuiteDaoImpl
implements CustomTestSuiteDao {
    private static final String TEST_SUITE_COUNT_STATUS_BY_TPI_IDS = "TestSuite.countStatusesByTpiIds";
    private static final String TEST_SUITE_IDS = "testSuiteIds";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public TestPlanStatistics getTestSuiteStatistics(List<Long> tpiIds) {
        List result = this.entityManager.createNamedQuery(TEST_SUITE_COUNT_STATUS_BY_TPI_IDS, Object[].class).setParameter("tpiIds", tpiIds).getResultList();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public Map<Long, ExecutionStatusReport> getStatusReport(List<Long> ids) {
        HashMap<Long, ExecutionStatusReport> reportsMap = new HashMap<Long, ExecutionStatusReport>();
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.getReportsByIds", Object[].class);
        query.setParameter("ids", ids);
        List tuples = query.getResultList();
        if (tuples.isEmpty()) {
            ids.stream().forEach(id -> {
                ExecutionStatusReport executionStatusReport = reportsMap.put((Long)id, new ExecutionStatusReport());
            });
        } else {
            for (Object[] tuple : tuples) {
                Long testId = (Long)tuple[0];
                ExecutionStatus execution = (ExecutionStatus)tuple[1];
                Long count = (Long)tuple[2];
                ExecutionStatusReport report = reportsMap.computeIfAbsent(testId, k -> new ExecutionStatusReport());
                report.set(execution.getCanonicalStatus(), count.intValue());
            }
        }
        return reportsMap;
    }

    @Override
    public List<Long> findAllIdsByExecutionIds(List<Long> executionIds) {
        if (executionIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findAllIdsByExecutionIds", Long.class);
        query.setParameter("executionIds", executionIds);
        return query.getResultList();
    }

    @Override
    public List<TestSuite> findAllByIds(Collection<Long> suiteIds) {
        if (suiteIds.isEmpty()) {
            return new ArrayList<TestSuite>();
        }
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findAllByIds", TestSuite.class);
        query.setParameter("suiteIds", suiteIds);
        return query.getResultList();
    }

    @Override
    public List<TestSuite> findTestSuitesWhereMilestoneIsNotLocked(Collection<Long> suiteIds) {
        if (suiteIds.isEmpty()) {
            return new ArrayList<TestSuite>();
        }
        TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findTestSuitesWhereMilestoneIsNoteLocked", TestSuite.class);
        query.setParameter("suiteIds", suiteIds);
        return query.getResultList();
    }

    @Override
    public List<Long> findTestSuiteAttachmentListIds(Collection<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findAllAttachmentLists", Long.class);
            query.setParameter(TEST_SUITE_IDS, testSuiteIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> findTestSuitesAutomatedSuiteIds(Collection<Long> testSuiteIds) {
        if (!testSuiteIds.isEmpty()) {
            TypedQuery query = this.entityManager.createNamedQuery("TestSuite.findTestSuitesAutomatedSuiteIds", Long.class);
            query.setParameter(TEST_SUITE_IDS, testSuiteIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public void removeTestSuites(Collection<Long> testSuiteIds) {
        Query query = this.entityManager.createNamedQuery("TestSuite.removeAll");
        query.setParameter(TEST_SUITE_IDS, testSuiteIds);
        query.executeUpdate();
    }

    @Override
    public TestSuite findByUUID(String targetUUID) {
        return (TestSuite)this.entityManager.createQuery("SELECT ts FROM TestSuite ts WHERE ts.uuid = :uuid", TestSuite.class).setParameter("uuid", (Object)targetUUID).getSingleResult();
    }

    @Override
    public List<TestSuite> loadNodeForPaste(Collection<Long> testSuiteIds) {
        List testSuites = this.entityManager.createQuery("select ts\nfrom TestSuite ts\njoin fetch ts.iteration i\njoin fetch i.campaign\nleft join fetch ts.attachmentList al\nleft join fetch al.attachments\nwhere ts.id in :ids", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
        this.entityManager.createQuery("select ts\nfrom TestSuite ts\nleft join fetch ts.testPlanItems tpi\nleft join fetch tpi.referencedTestCase\nleft join fetch tpi.exploratorySessionOverview o\nleft join fetch o.attachmentList al\nleft join fetch al.attachments\nwhere ts.id in :ids", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
        return testSuites;
    }

    @Override
    public boolean hasDeletedTestCaseInTestPlan(long testSuiteId) {
        return (Boolean)this.entityManager.createQuery("select count(t) > 0\nfrom TestSuite t\njoin t.testPlanItems tp\nwhere t.id = :testSuiteId and tp.referencedTestCase is null", Boolean.class).setParameter("testSuiteId", (Object)testSuiteId).getSingleResult();
    }

    @Override
    public TestSuite loadForExecutionResume(long testSuiteId) {
        TestSuite testSuite = (TestSuite)this.entityManager.createQuery("select ts\nfrom TestSuite ts\nleft join fetch ts.testPlanItems tp\nleft join fetch tp.referencedTestCase tc\nwhere ts.id = :id", TestSuite.class).setParameter("id", (Object)testSuiteId).getSingleResult();
        this.entityManager.createQuery("select distinct tpi\nfrom TestPlanItem tpi\nleft join fetch tpi.executions exec\nleft join fetch exec.automatedExecutionExtender\nleft join fetch exec.attachmentList\nwhere tpi in :itemIds", TestPlanItem.class).setParameter("itemIds", (Object)testSuite.getTestPlanItems()).getResultList();
        this.entityManager.createQuery("select distinct exec\nfrom Execution exec\nleft join fetch exec.steps step\nleft join fetch exec.automatedExecutionExtender\nleft join fetch step.attachmentList\nwhere exec.testPlanItem in :itemIds", Execution.class).setParameter("itemIds", (Object)testSuite.getTestPlanItems()).getResultList();
        return testSuite;
    }

    @Override
    public List<TestSuite> loadForItemAddition(List<Long> testSuiteIds) {
        this.entityManager.createQuery("    select suite from TestSuite suite\n    left join fetch suite.testPlanItems tpi\n    left join fetch tpi.referencedTestCase\n    where suite.id in :ids\n", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
        return this.entityManager.createQuery("    select suite from TestSuite suite\n    join fetch suite.iteration it\n    join fetch it.testPlan tp\n    left join fetch tp.testPlanItems tpi\n    left join fetch tpi.referencedTestCase\n    where suite.id in :ids\n", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
    }

    @Override
    public TestSuite loadForItemAddition(@Param(value="id") Long testSuiteId) {
        return this.loadForItemAddition(List.of(testSuiteId)).get(0);
    }
}

