/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.scm.QScmRepository;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.testcase.QKeywordTestCase;
import org.squashtest.tm.domain.testcase.QScriptedTestCase;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.ScmRepositoryDto;
import org.squashtest.tm.service.internal.repository.CustomScmRepositoryDao;

public class ScmRepositoryDaoImpl
implements CustomScmRepositoryDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScmRepositoryDaoImpl.class);
    private static final String URL_SEPARATOR = "/";
    private static final String SCM_REPOSITORY_LABEL_FORMAT = "%s (%s)";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dsl;

    @Override
    public Map<ScmRepository, Set<TestCase>> findScriptedAndKeywordTestCasesGroupedByRepoById(Collection<Long> testCaseIds) {
        LOGGER.debug("looking for test cases and repositories which are corresponding to these test cases' projects to commit into", new Object[0]);
        if (testCaseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QTestCase testCase = QTestCase.testCase;
        QScriptedTestCase scriptedTestCase = QScriptedTestCase.scriptedTestCase;
        QKeywordTestCase keywordTestCase = QKeywordTestCase.keywordTestCase;
        QProject project = QProject.project1;
        QScmRepository scm = QScmRepository.scmRepository;
        return (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select(new Expression[]{scm, testCase}).from((EntityPath)testCase)).join((EntityPath)testCase.project, (Path)project)).join((EntityPath)project.scmRepository, (Path)scm)).where((Predicate)testCase.id.in(this.createQueryForValueFiltering(keywordTestCase, (NumberPath<Long>)keywordTestCase.id, testCaseIds)).or((Predicate)testCase.id.in(this.createQueryForValueFiltering(scriptedTestCase, (NumberPath<Long>)scriptedTestCase.id, testCaseIds))))).transform(GroupBy.groupBy((Expression)scm).as((Expression)GroupBy.set((Expression)testCase)));
    }

    @Override
    public List<ScmRepositoryDto> getAllDeclaredScmRepositories() {
        return this.dsl.select((SelectField)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID, (SelectField)Tables.SCM_REPOSITORY.NAME, (SelectField)Tables.SCM_REPOSITORY.WORKING_BRANCH, (SelectField)Tables.THIRD_PARTY_SERVER.URL).from((TableLike)Tables.SCM_REPOSITORY).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.SCM_REPOSITORY.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).fetch().stream().map(record -> new ScmRepositoryDto((Long)record.get((Field)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID), this.formatScmRepositoryFriendlyUrl((String)record.get((Field)Tables.THIRD_PARTY_SERVER.URL), (String)record.get((Field)Tables.SCM_REPOSITORY.NAME), (String)record.get((Field)Tables.SCM_REPOSITORY.WORKING_BRANCH)))).toList();
    }

    @Override
    public boolean isRepositoryNameAndBranchAlreadyInUse(Long scmServerId, String scmRepositoryName, String scmRepositoryBranch) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.SCM_REPOSITORY).where(new Condition[]{Tables.SCM_REPOSITORY.SERVER_ID.eq((Object)scmServerId), Tables.SCM_REPOSITORY.NAME.eq((Object)scmRepositoryName), Tables.SCM_REPOSITORY.WORKING_BRANCH.eq((Object)scmRepositoryBranch)}));
    }

    @Override
    public boolean isOneRepositoryBoundToProjectOrTestCase(Collection<Long> scmRepositoryIds) {
        return this.dsl.fetchExists((Select)this.dsl.select((SelectField)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID).from((TableLike)Tables.PROJECT).join((TableLike)Tables.SCM_REPOSITORY).on(Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID.eq((Field)Tables.PROJECT.SCM_REPOSITORY_ID)).where(Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID.in(scmRepositoryIds)).union((Select)DSL.select((SelectField)Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.SCM_REPOSITORY).on(Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID.eq((Field)Tables.TEST_CASE.SCM_REPOSITORY_ID)).where(Tables.SCM_REPOSITORY.SCM_REPOSITORY_ID.in(scmRepositoryIds))));
    }

    private String formatScmRepositoryFriendlyUrl(String serverUrl, String repositoryName, String workingBranch) {
        String fullRepositoryUrl = this.buildFullRepositoryUrl(serverUrl, repositoryName);
        return String.format(SCM_REPOSITORY_LABEL_FORMAT, fullRepositoryUrl, workingBranch);
    }

    private String buildFullRepositoryUrl(String serverUrl, String repositoryName) {
        StringBuilder builder = new StringBuilder();
        builder.append(serverUrl);
        if (!serverUrl.endsWith(URL_SEPARATOR)) {
            builder.append(URL_SEPARATOR);
        }
        builder.append(repositoryName);
        return builder.toString();
    }

    private <Y extends TestCase, T extends EntityPathBase<Y>> JPAQuery<Long> createQueryForValueFiltering(T entityPathBase, NumberPath<Long> entityPathBaseId, Collection<Long> testCaseIds) {
        return (JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select(entityPathBaseId).from(entityPathBase)).where((Predicate)entityPathBaseId.in(testCaseIds));
    }
}

