/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record5;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.acl.AclClass;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.PartyProfileAuthorizationsDto;
import org.squashtest.tm.service.internal.display.dto.PermissionsDto;
import org.squashtest.tm.service.internal.display.dto.ProfileAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.ProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProfilePermissionsDto;
import org.squashtest.tm.service.internal.repository.display.ProfileDisplayDao;

@Repository
public class ProfileDisplayDaoImpl
implements ProfileDisplayDao {
    private static final String SPACE_CHAR = " ";
    private static final String PARTY_NAME_LOGIN_START = " (";
    private static final String PARTY_NAME_LOGIN_END = ")";
    private final DSLContext dslContext;

    public ProfileDisplayDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public List<ProfileDto> findAll() {
        return this.dslContext.select((SelectField)Tables.ACL_GROUP.ID.as("ID"), (SelectField)Tables.ACL_GROUP.QUALIFIED_NAME.as("QUALIFIED_NAME"), (SelectField)DSL.countDistinct((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID).as("PARTY_COUNT"), (SelectField)Tables.ACL_GROUP.ACTIVE.as("ACTIVE")).from((TableLike)Tables.ACL_GROUP).leftJoin((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_GROUP.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).groupBy(new GroupField[]{Tables.ACL_GROUP.ID}).fetchInto(ProfileDto.class);
    }

    @Override
    public ProfileAdminViewDto findProfileAdminViewDto(long profileId) {
        return (ProfileAdminViewDto)this.dslContext.select((SelectField)Tables.ACL_GROUP.ID.as("ID"), (SelectField)Tables.ACL_GROUP.QUALIFIED_NAME.as("QUALIFIED_NAME"), (SelectField)DSL.countDistinct((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID).as("PARTY_COUNT"), (SelectField)Tables.ACL_GROUP.DESCRIPTION.as("DESCRIPTION"), (SelectField)Tables.ACL_GROUP.ACTIVE.as("ACTIVE"), (SelectField)Tables.ACL_GROUP.CREATED_BY.as("CREATED_BY"), (SelectField)Tables.ACL_GROUP.CREATED_ON.as("CREATED_ON"), (SelectField)Tables.ACL_GROUP.LAST_MODIFIED_BY.as("LAST_MODIFIED_BY"), (SelectField)Tables.ACL_GROUP.LAST_MODIFIED_ON.as("LAST_MODIFIED_ON")).from((TableLike)Tables.ACL_GROUP).leftJoin((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_GROUP.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).where(Tables.ACL_GROUP.ID.eq((Object)profileId)).groupBy(new GroupField[]{Tables.ACL_GROUP.ID}).fetchOneInto(ProfileAdminViewDto.class);
    }

    @Override
    public List<PermissionsDto> fetchProfilePermissions(long profileId) {
        ArrayList<PermissionsDto> profilePermissionsDtos = new ArrayList<PermissionsDto>();
        List<AclClass> aclClasses = this.getFilteredAclClasses();
        Map<String, List<Integer>> permissions = this.fetchAclGroupPermissions(profileId);
        for (AclClass aclClass : aclClasses) {
            List<String> perms = this.retrievePermissionsForAclClass(aclClass, permissions);
            profilePermissionsDtos.add(new PermissionsDto(aclClass.getClassName(), aclClass.getSimpleClassName(), perms));
        }
        return profilePermissionsDtos;
    }

    private List<AclClass> getFilteredAclClasses() {
        return Arrays.stream(AclClass.values()).filter(aclClass -> aclClass != AclClass.PROJECT_TEMPLATE).toList();
    }

    private Map<String, List<Integer>> fetchAclGroupPermissions(long profileId) {
        return this.dslContext.select((SelectField)Tables.ACL_CLASS.CLASSNAME, (SelectField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK).from((TableLike)Tables.ACL_GROUP_PERMISSION).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID)).where(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Object)profileId)).fetchGroups((Field)Tables.ACL_CLASS.CLASSNAME, (Field)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK);
    }

    private List<String> retrievePermissionsForAclClass(AclClass aclClass, Map<String, List<Integer>> permissions) {
        return Permissions.findByMasks(permissions.getOrDefault(aclClass.getClassName(), List.of())).stream().map(Enum::name).toList();
    }

    @Override
    public List<ProfilePermissionsDto> fetchProfilesAndPermissions() {
        ArrayList<ProfilePermissionsDto> profilePermissionsDtos = new ArrayList<ProfilePermissionsDto>();
        Map aclClasses = Arrays.stream(AclClass.values()).collect(Collectors.toMap(AclClass::getClassName, Function.identity()));
        this.dslContext.select((SelectField)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID, (SelectField)Tables.ACL_GROUP.QUALIFIED_NAME, (SelectField)Tables.ACL_GROUP.ACTIVE, (SelectField)Tables.ACL_CLASS.CLASSNAME, (SelectField)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK).from((TableLike)Tables.ACL_GROUP_PERMISSION).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID)).join((TableLike)Tables.ACL_GROUP).on(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP.ID)).forEach(profilePermission -> this.processProfilePermission((Record5<Long, String, Boolean, String, Integer>)profilePermission, profilePermissionsDtos, aclClasses));
        return profilePermissionsDtos;
    }

    @Override
    public List<PartyProfileAuthorizationsDto> fetchPartyProfileAuthorizations(long profileId) {
        Field<String> partyName = this.getPartyNameField();
        Field isPartyActive = DSL.when((Condition)Tables.CORE_USER.LOGIN.isNull(), (Object)true).otherwise((Field)Tables.CORE_USER.ACTIVE);
        Field isPartyTeam = DSL.when((Condition)Tables.CORE_USER.LOGIN.isNull(), (Object)true).otherwise((Object)false);
        return this.dslContext.selectDistinct((SelectField)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.as("PARTY_ID"), (SelectField)partyName.as("PARTY_NAME"), (SelectField)isPartyActive.as("ACTIVE"), (SelectField)isPartyTeam.as("TEAM")).from((TableLike)Tables.ACL_GROUP).join((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_GROUP.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).join((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).leftJoin((TableLike)Tables.CORE_TEAM).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_TEAM.PARTY_ID)).where(Tables.ACL_GROUP.ID.eq((Object)profileId)).and(Tables.ACL_CLASS.CLASSNAME.in((Object[])new String[]{Project.class.getName(), ProjectTemplate.class.getName()})).fetchInto(PartyProfileAuthorizationsDto.class);
    }

    private Field<String> getPartyNameField() {
        return DSL.when((Condition)Tables.CORE_USER.LOGIN.isNull(), (Field)Tables.CORE_TEAM.NAME).otherwise(DSL.when((Condition)Tables.CORE_USER.FIRST_NAME.isNull().or(Tables.CORE_USER.FIRST_NAME.eq((Object)"")), (Field)DSL.concat((Field[])new Field[]{Tables.CORE_USER.LAST_NAME, DSL.val((String)PARTY_NAME_LOGIN_START), Tables.CORE_USER.LOGIN, DSL.val((String)PARTY_NAME_LOGIN_END)})).otherwise(DSL.concat((Field[])new Field[]{Tables.CORE_USER.FIRST_NAME, DSL.val((String)SPACE_CHAR), Tables.CORE_USER.LAST_NAME, DSL.val((String)PARTY_NAME_LOGIN_START), Tables.CORE_USER.LOGIN, DSL.val((String)PARTY_NAME_LOGIN_END)})));
    }

    private void processProfilePermission(Record5<Long, String, Boolean, String, Integer> profilePermission, List<ProfilePermissionsDto> profilePermissionsDtos, Map<String, AclClass> aclClasses) {
        ProfilePermissionsDto profilePermissionsDto = this.findOrCreateProfilePermissionsDto(profilePermission, profilePermissionsDtos);
        PermissionsDto permissionsDto = this.findOrCreatePermissionsDto(profilePermissionsDto, profilePermission, aclClasses);
        Permissions permissionMask = Permissions.findByMask((int)((Integer)profilePermission.get((Field)Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK)));
        if (Objects.nonNull(permissionMask)) {
            permissionsDto.permissions().add(permissionMask.name());
        }
    }

    private ProfilePermissionsDto findOrCreateProfilePermissionsDto(Record5<Long, String, Boolean, String, Integer> profilePermission, List<ProfilePermissionsDto> profilePermissionsDtos) {
        return profilePermissionsDtos.stream().filter(it -> it.profileId() == ((Long)profilePermission.get((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).longValue()).findFirst().orElseGet(() -> {
            ProfilePermissionsDto newDto = new ProfilePermissionsDto((Long)profilePermission.get((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID), (String)profilePermission.get((Field)Tables.ACL_GROUP.QUALIFIED_NAME), (Boolean)profilePermission.get((Field)Tables.ACL_GROUP.ACTIVE), AclGroup.isSystem((String)((String)profilePermission.get((Field)Tables.ACL_GROUP.QUALIFIED_NAME))), new ArrayList<PermissionsDto>());
            profilePermissionsDtos.add(newDto);
            return newDto;
        });
    }

    private PermissionsDto findOrCreatePermissionsDto(ProfilePermissionsDto profilePermissionsDto, Record5<Long, String, Boolean, String, Integer> profilePermission, Map<String, AclClass> aclClasses) {
        return profilePermissionsDto.permissions().stream().filter(it -> it.className().equals(profilePermission.get((Field)Tables.ACL_CLASS.CLASSNAME))).findFirst().orElseGet(() -> {
            PermissionsDto newPermissionsDto = new PermissionsDto((String)profilePermission.get((Field)Tables.ACL_CLASS.CLASSNAME), ((AclClass)aclClasses.get(profilePermission.get((Field)Tables.ACL_CLASS.CLASSNAME))).getSimpleClassName(), new ArrayList<String>());
            profilePermissionsDto.permissions().add(newPermissionsDto);
            return newPermissionsDto;
        });
    }
}

