/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.home;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.users.PartyPreference;
import org.squashtest.tm.domain.users.preferences.CorePartyPreference;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.internal.display.home.HomeWorkspaceData;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.system.SystemAdministrationService;
import org.squashtest.tm.service.user.PartyPreferenceService;

@Service
@Transactional(readOnly=true)
public class HomeWorkspaceDisplayService {
    private final SystemAdministrationService systemAdministrationService;
    private final PartyPreferenceService partyPreferenceService;
    private final CustomReportDashboardService customReportDashboardService;

    public HomeWorkspaceDisplayService(SystemAdministrationService systemAdministrationService, PartyPreferenceService partyPreferenceService, CustomReportDashboardService customReportDashboardService) {
        this.systemAdministrationService = systemAdministrationService;
        this.partyPreferenceService = partyPreferenceService;
        this.customReportDashboardService = customReportDashboardService;
    }

    public HomeWorkspaceData getWorkspacePayload() {
        PartyPreference preference;
        HomeWorkspaceData homeWorkspaceData = new HomeWorkspaceData();
        String welcomeMessage = this.systemAdministrationService.findWelcomeMessage();
        homeWorkspaceData.setWelcomeMessage(HTMLCleanupUtils.cleanHtml(welcomeMessage));
        if (this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.HOME)) {
            homeWorkspaceData.setShowDashboard(true);
        }
        if (this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.HOME) && (preference = this.partyPreferenceService.findPreferenceForCurrentUser(CorePartyPreference.FAVORITE_DASHBOARD_HOME.getPreferenceKey())) != null) {
            Long dashboardId = Long.valueOf(preference.getPreferenceValue());
            homeWorkspaceData.setFavoriteDashboardId(dashboardId);
        }
        return homeWorkspaceData;
    }
}

