/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.columns;

import java.util.HashMap;
import java.util.Map;
import org.jooq.Field;
import org.jooq.SortField;
import org.squashtest.tm.service.internal.display.grid.GridSort;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public abstract class AbstractEnumDrivenColumn
extends GridColumn {
    private Class<? extends Enum<?>> sourceEnum;

    protected AbstractEnumDrivenColumn(Class<? extends Enum<?>> sourceEnum, Field<String> field) {
        super(field);
        this.sourceEnum = sourceEnum;
    }

    @Override
    public SortField<?> generateOrderClause(GridSort.SortDirection direction) {
        Map<String, Integer> sortMap = this.getAscSortMap();
        if (direction.equals((Object)GridSort.SortDirection.DESC)) {
            sortMap.keySet().forEach(key -> {
                Integer n = sortMap.put((String)key, (Integer)sortMap.get(key) * -1);
            });
        }
        return this.aliasedField.sort(sortMap);
    }

    protected Map<String, Integer> getAscSortMap() {
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>();
        Enum<?>[] enumArray = this.sourceEnum.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> e = enumArray[n2];
            sortMap.put(e.toString(), e.ordinal());
            ++n2;
        }
        return sortMap;
    }
}

