/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;

public record NodeScope(Map<NodeScopeType, Set<Long>> scopes) {
    public static NodeScope of(Set<NodeReference> references) {
        Objects.requireNonNull(references, "references cannot be null");
        HashMap<NodeScopeType, Set<Long>> nodes = new HashMap<NodeScopeType, Set<Long>>(references.size());
        for (NodeReference reference : references) {
            NodeScopeType type = NodeScopeType.fromNodeType(reference.getNodeType());
            nodes.computeIfAbsent(type, k -> new HashSet()).add(reference.getId());
        }
        return new NodeScope(nodes);
    }

    public static NodeScope forNodes(Collection<Long> nodeIds) {
        Objects.requireNonNull(nodeIds, "nodeIds cannot be null");
        return new NodeScope(Map.of(NodeScopeType.NODE, Set.copyOf(nodeIds)));
    }

    public static NodeScope forLibraries(Collection<Long> libraryIds) {
        Objects.requireNonNull(libraryIds, "libraryIds cannot be null");
        return new NodeScope(Map.of(NodeScopeType.LIBRARY, Set.copyOf(libraryIds)));
    }

    public Set<Long> getNodeIds() {
        return this.scopes.getOrDefault((Object)NodeScopeType.NODE, Set.of());
    }

    public Set<Long> getLibraryIds() {
        return this.scopes.getOrDefault((Object)NodeScopeType.LIBRARY, Set.of());
    }

    public boolean hasLibraries() {
        return this.scopes.containsKey((Object)NodeScopeType.LIBRARY);
    }

    public boolean hasNodes() {
        return this.scopes.containsKey((Object)NodeScopeType.NODE);
    }

    public boolean isEmpty() {
        return this.scopes.isEmpty();
    }

    public String summary() {
        if (this.scopes == null || this.scopes.isEmpty()) {
            return "";
        }
        return this.scopes.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
    }
}

