/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NewFolderDto;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.campaign.IllegalSprintGroupHierarchyException;
import org.squashtest.tm.exception.filemanagement.WriterException;
import org.squashtest.tm.exception.library.NameAlreadyExistsAtDestinationException;
import org.squashtest.tm.service.annotation.BatchPreventConcurrent;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.CheckBlockingMilestones;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.Ids;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.PreventConcurrents;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CampaignStatisticsService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationStatisticsService;
import org.squashtest.tm.service.campaign.export.CampaignExport;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.copier.CampaignWorkspaceStrategyCopierService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.deletion.CampaignLibraryNodesToDelete;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.coercers.CLNAndParentIdsCoercerForArray;
import org.squashtest.tm.service.internal.campaign.coercers.CLNAndParentIdsCoercerForList;
import org.squashtest.tm.service.internal.campaign.coercers.CampaignLibraryIdsCoercerForArray;
import org.squashtest.tm.service.internal.campaign.coercers.CampaignLibraryIdsCoercerForList;
import org.squashtest.tm.service.internal.campaign.coercers.IterationToCampaignIdsCoercer;
import org.squashtest.tm.service.internal.campaign.coercers.TestSuiteToIterationCoercerForList;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.DeletionPreview;
import org.squashtest.tm.service.internal.dto.FileDto;
import org.squashtest.tm.service.internal.filemanagement.writer.WriterFactory;
import org.squashtest.tm.service.internal.library.AbstractLibraryNavigationService;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.display.CampaignDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintGroupDisplayDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneMembershipManager;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;

@Service(value="squashtest.tm.service.CampaignLibraryNavigationService")
@Transactional
public class CampaignLibraryNavigationServiceImpl
extends AbstractLibraryNavigationService<CampaignLibrary, CampaignFolder, CampaignLibraryNode>
implements CampaignLibraryNavigationService {
    private static final String DESTINATION_ID = "destinationId";
    private static final String TARGET_ID = "targetId";
    private static final String DELETION_THRESHOLD_KEY = "squash.control.deletion.threshold";
    @Inject
    private CampaignLibraryDao campaignLibraryDao;
    @Inject
    private CampaignFolderDao campaignFolderDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.CampaignLibraryNodeDao")
    private LibraryNodeDao<CampaignLibraryNode> campaignLibraryNodeDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private CampaignDao campaignDao;
    @Inject
    private CampaignDisplayDao campaignDisplayDao;
    @Inject
    private SprintDao sprintDao;
    @Inject
    private HibernateSprintGroupDao sprintGroupDao;
    @Inject
    private SprintGroupDisplayDao sprintGroupDisplayDao;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private IterationModificationService iterationModificationService;
    @Inject
    private CampaignNodeDeletionHandler deletionHandler;
    @Inject
    @Qualifier(value="squashtest.tm.service.CampaignExportFull")
    private CampaignExport campaignFullExport;
    @Inject
    @Qualifier(value="squashtest.tm.service.CampaignExportSimple")
    private CampaignExport campaignSimpleExport;
    @Inject
    @Qualifier(value="squashtest.tm.service.CampaignExportStandard")
    private CampaignExport campaignStandardExport;
    @Inject
    private CampaignStatisticsService campaignStatisticsService;
    @Inject
    private IterationStatisticsService iterationStatisticsService;
    @Inject
    private CampaignWorkspaceStrategyCopierService campaignWorkspaceStrategyCopierService;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToCampaignFolderStrategy")
    private Provider<PasteStrategy<CampaignFolder, CampaignLibraryNode>> pasteToCampaignFolderStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToSprintGroupStrategy")
    private Provider<PasteStrategy<SprintGroup, CampaignLibraryNode>> pasteToSprintGroupStrategyProvider;
    @Inject
    @Qualifier(value="squashtest.tm.service.internal.PasteToCampaignLibraryStrategy")
    private Provider<PasteStrategy<CampaignLibrary, CampaignLibraryNode>> pasteToCampaignLibraryStrategyProvider;
    @Inject
    private MilestoneMembershipManager milestoneManager;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CustomFieldBindingFinderService customFieldBindingFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;
    @Inject
    private CustomCampaignModificationService customCampaignModificationService;
    @Inject
    private WriterFactory writerFactory;
    @Inject
    private ConfigurationService configurationService;

    @Override
    protected NodeDeletionHandler getDeletionHandler() {
        return this.deletionHandler;
    }

    @Override
    protected PasteStrategy<CampaignFolder, CampaignLibraryNode> getPasteToFolderStrategy() {
        return (PasteStrategy)this.pasteToCampaignFolderStrategyProvider.get();
    }

    @Override
    protected PasteStrategy<CampaignLibrary, CampaignLibraryNode> getPasteToLibraryStrategy() {
        return (PasteStrategy)this.pasteToCampaignLibraryStrategyProvider.get();
    }

    @Override
    @PreAuthorize(value="(hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign', 'CREATE'))  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void copyIterationsToCampaign(@Id long campaignId, Long[] iterationsIds, ClipboardPayload clipboardPayload) {
        NodeType nodePaste = this.campaignWorkspaceStrategyCopierService.verifyPermissionAndGetNodePaste(clipboardPayload);
        this.campaignWorkspaceStrategyCopierService.copyNodeToCampaign(campaignId, clipboardPayload, nodePaste);
    }

    @Override
    @PreAuthorize(value="hasPermission(#destinationId, 'org.squashtest.tm.domain.campaign.Campaign', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class, paramName="destinationId")
    public void moveIterationsWithinCampaign(@Id(value="destinationId") long destinationId, Long[] nodeIds, int position) {
        List<Long> iterationIds = Arrays.asList(nodeIds);
        Campaign c = (Campaign)this.campaignDao.findById(destinationId);
        List iterations = this.iterationDao.findAllByIds(iterationIds);
        c.moveIterations(position, iterations);
    }

    protected CampaignLibraryDao getLibraryDao() {
        return this.campaignLibraryDao;
    }

    protected CampaignFolderDao getFolderDao() {
        return this.campaignFolderDao;
    }

    @Override
    protected LibraryNodeDao<CampaignLibraryNode> getLibraryNodeDao() {
        return this.campaignLibraryNodeDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public Campaign addCampaignToCampaignLibrary(@Id long libraryId, Campaign campaign, Map<Long, RawValue> customFieldValues) {
        return this.addCampaignToCampaignLibraryUnsecured(libraryId, campaign, customFieldValues);
    }

    @Override
    public Campaign addCampaignToCampaignLibraryUnsecured(long libraryId, Campaign campaign, Map<Long, RawValue> customFieldValues) {
        this.addCampaignToCampaignLibraryUnsecuredWithoutMilestone(libraryId, campaign);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)campaign, customFieldValues);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> this.milestoneManager.bindCampaignToMilestone(campaign.getId(), milestone.getId()));
        return campaign;
    }

    @Override
    public void addCampaignToCampaignLibraryUnsecuredWithoutMilestone(long libraryId, Campaign campaign) {
        this.doAddCampaignToCampaignLibrary(libraryId, campaign);
        this.createCustomFieldValues((BoundEntity)campaign);
        this.createAttachmentsFromLibraryNode((LibraryNode)campaign, (BoundEntity)campaign);
    }

    private void doAddCampaignToCampaignLibrary(long libraryId, Campaign newCampaign) {
        CampaignLibrary library = (CampaignLibrary)this.campaignLibraryDao.findById(libraryId);
        if (!library.isContentNameAvailable(newCampaign.getName())) {
            throw new DuplicateNameException(newCampaign.getName(), newCampaign.getName());
        }
        library.addContent((LibraryNode)newCampaign);
        this.campaignDao.persist(newCampaign);
        this.createCustomFieldValues((BoundEntity)newCampaign);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintToCampaignLibraryUnsecured(@Id long libraryId, Sprint newSprint) {
        CampaignLibrary library = (CampaignLibrary)this.campaignLibraryDao.findById(libraryId);
        library.addContent((LibraryNode)newSprint);
        this.sprintDao.persist(newSprint);
        this.createCustomFieldValues((BoundEntity)newSprint);
        this.createAttachmentsFromLibraryNode((LibraryNode)newSprint, (BoundEntity)newSprint);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintToCampaignLibrary(@Id long libraryId, Sprint newSprint) {
        this.addSprintToCampaignLibraryUnsecured(libraryId, newSprint);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintToCampaignLibraryUnsecured(@Id long libraryId, Sprint sprint, Map<Long, RawValue> customFieldValues) {
        this.addSprintToCampaignLibraryUnsecured(libraryId, sprint);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)sprint, customFieldValues);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintToCampaignLibrary(@Id long libraryId, Sprint sprint, Map<Long, RawValue> customFieldValues) {
        this.addSprintToCampaignLibraryUnsecured(libraryId, sprint, customFieldValues);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public SprintGroup addSprintGroupToCampaignLibrary(@Id long libraryId, SprintGroup newSprintGroup) {
        CampaignLibrary library = (CampaignLibrary)this.campaignLibraryDao.findById(libraryId);
        if (!library.isContentNameAvailable(newSprintGroup.getName())) {
            throw new DuplicateNameException(newSprintGroup.getName(), newSprintGroup.getName());
        }
        library.addContent((LibraryNode)newSprintGroup);
        this.sprintGroupDao.persist(newSprintGroup);
        this.createCustomFieldValues((BoundEntity)newSprintGroup);
        return newSprintGroup;
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintGroupToCampaignLibraryUnsecured(@Id long libraryId, SprintGroup sprintGroup) {
        this.addSprintGroupToCampaignLibrary(libraryId, sprintGroup);
        this.createAttachmentsFromLibraryNode((LibraryNode)sprintGroup, (BoundEntity)sprintGroup);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintGroupToCampaignLibrary(@Id long libraryId, SprintGroup sprintGroup, Map<Long, RawValue> customFieldValues) {
        this.addSprintGroupToCampaignLibraryUnsecured(libraryId, sprintGroup, customFieldValues);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public void addSprintGroupToCampaignLibraryUnsecured(@Id long libraryId, SprintGroup sprintGroup, Map<Long, RawValue> customFieldValues) {
        this.addSprintGroupToCampaignLibraryUnsecured(libraryId, sprintGroup);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)sprintGroup, customFieldValues);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.campaign.CampaignFolder', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public Campaign addCampaignToCampaignFolder(@Id long folderId, Campaign campaign, Map<Long, RawValue> customFieldValues) {
        return this.addCampaignToCampaignFolderUnsecured(folderId, campaign, customFieldValues);
    }

    @Override
    public Campaign addCampaignToCampaignFolderUnsecured(long folderId, Campaign campaign, Map<Long, RawValue> customFieldValues) {
        this.addCampaignToCampaignFolderUnsecuredWithoutMilestone(folderId, campaign);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)campaign, customFieldValues);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> this.milestoneManager.bindCampaignToMilestone(campaign.getId(), milestone.getId()));
        return campaign;
    }

    @Override
    public Campaign addCampaignToCampaignFolderUnsecuredWithoutMilestone(long folderId, Campaign campaign) {
        this.doAddCampaignToCampaignFolder(folderId, campaign);
        this.createCustomFieldValues((BoundEntity)campaign);
        this.createAttachmentsFromLibraryNode((LibraryNode)campaign, (BoundEntity)campaign);
        return campaign;
    }

    private void doAddCampaignToCampaignFolder(long folderId, Campaign newCampaign) {
        CampaignFolder folder = (CampaignFolder)this.campaignFolderDao.findById(folderId);
        if (!folder.isContentNameAvailable(newCampaign.getName())) {
            throw new DuplicateNameException(newCampaign.getName(), newCampaign.getName());
        }
        folder.addContent((CampaignLibraryNode)newCampaign);
        this.campaignDao.persist(newCampaign);
        this.createCustomFieldValues((BoundEntity)newCampaign);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToCampaignFolderUnsecured(@Id long folderId, Sprint newSprint) {
        CampaignFolder folder = (CampaignFolder)this.campaignFolderDao.findById(folderId);
        folder.addContent((CampaignLibraryNode)newSprint);
        this.sprintDao.persist(newSprint);
        this.createCustomFieldValues((BoundEntity)newSprint);
        this.createAttachmentsFromLibraryNode((LibraryNode)newSprint, (BoundEntity)newSprint);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.campaign.CampaignFolder', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToCampaignFolder(@Id long folderId, Sprint newSprint) {
        this.addSprintToCampaignFolderUnsecured(folderId, newSprint);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToCampaignFolderUnsecured(@Id long folderId, Sprint sprint, Map<Long, RawValue> customFieldValues) {
        this.addSprintToCampaignFolderUnsecured(folderId, sprint);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)sprint, customFieldValues);
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.campaign.CampaignFolder', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToCampaignFolder(@Id long folderId, Sprint sprint, Map<Long, RawValue> customFieldValues) {
        this.addSprintToCampaignFolderUnsecured(folderId, sprint, customFieldValues);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public SprintGroup addSprintGroupToCampaignFolder(@Id long folderId, SprintGroup newSprintGroup) {
        CampaignFolder folder = (CampaignFolder)this.campaignFolderDao.findById(folderId);
        if (!folder.isContentNameAvailable(newSprintGroup.getName())) {
            throw new DuplicateNameException(newSprintGroup.getName(), newSprintGroup.getName());
        }
        folder.addContent((CampaignLibraryNode)newSprintGroup);
        this.sprintGroupDao.persist(newSprintGroup);
        this.createCustomFieldValues((BoundEntity)newSprintGroup);
        return newSprintGroup;
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public SprintGroup addSprintGroupToCampaignFolderUnsecured(@Id long folderId, SprintGroup sprintGroup) {
        this.addSprintGroupToCampaignFolder(folderId, sprintGroup);
        this.createAttachmentsFromLibraryNode((LibraryNode)sprintGroup, (BoundEntity)sprintGroup);
        return sprintGroup;
    }

    @Override
    @PreAuthorize(value="hasPermission(#folderId, 'org.squashtest.tm.domain.campaign.CampaignFolder', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public SprintGroup addSprintGroupToCampaignFolder(@Id long folderId, SprintGroup sprintGroup, Map<Long, RawValue> customFieldValues) {
        return this.addSprintGroupToCampaignFolderUnsecured(folderId, sprintGroup, customFieldValues);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public SprintGroup addSprintGroupToCampaignFolderUnsecured(@Id long folderId, SprintGroup sprintGroup, Map<Long, RawValue> customFieldValues) {
        this.addSprintGroupToCampaignFolderUnsecured(folderId, sprintGroup);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)sprintGroup, customFieldValues);
        return sprintGroup;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToSprintGroup(@Id long sprintGroupId, Sprint newSprint) {
        SprintGroup sprintGroup = (SprintGroup)this.sprintGroupDao.findById(sprintGroupId);
        sprintGroup.addContent((CampaignLibraryNode)newSprint);
        this.sprintDao.persist(newSprint);
        this.createCustomFieldValues((BoundEntity)newSprint);
        this.createAttachmentsFromLibraryNode((LibraryNode)newSprint, (BoundEntity)newSprint);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToSprintGroupUnsecured(@Id long sprintGroupId, Sprint sprint, Map<Long, RawValue> customFieldValues) {
        this.addSprintToSprintGroupUnsecured(sprintGroupId, sprint);
        this.customFieldValueService.initCustomFieldValues((BoundEntity)sprint, customFieldValues);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToSprintGroupUnsecured(@Id long sprintGroupId, Sprint sprint) {
        SprintGroup sprintGroup = (SprintGroup)this.sprintGroupDao.findById(sprintGroupId);
        sprintGroup.addContent((CampaignLibraryNode)sprint);
        this.sprintDao.persist(sprint);
        this.createCustomFieldValues((BoundEntity)sprint);
        this.createAttachmentsFromLibraryNode((LibraryNode)sprint, (BoundEntity)sprint);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup', 'CREATE') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addSprintToSprintGroup(@Id long sprintGroupId, Sprint sprint, Map<Long, RawValue> customFieldValues) {
        this.addSprintToSprintGroupUnsecured(sprintGroupId, sprint, customFieldValues);
    }

    @Override
    @UsedInPlugin(names={PluginName.XSQUASH4JIRA})
    public Long createSprintGroupAndFoldersHierarchy(String folderPath) {
        List paths = PathUtils.scanPath((String)folderPath);
        String[] splits = PathUtils.splitPath((String)folderPath);
        Project project = this.projectDao.findByName(PathUtils.unescapePathPartSlashes((String)splits[0]));
        if (splits.length < 2) {
            throw new IllegalArgumentException("Folder path must contain at least a valid /projectName/folder. This is incorrect: " + folderPath);
        }
        if (project == null) {
            throw new IllegalArgumentException("Folder path must concern an existing project");
        }
        Long campaignLibraryId = project.getCampaignLibrary().getId();
        this.permissionService.checkPermission(Collections.singletonList(campaignLibraryId), Permissions.CREATE.name(), CampaignLibrary.class.getName());
        if (splits.length == 2) {
            return this.createOnlyASprintGroup(project.getId(), splits[1], campaignLibraryId);
        }
        return this.createFoldersAndASprintGroup(paths, campaignLibraryId);
    }

    private Long createOnlyASprintGroup(Long projectId, String sprintGroupName, Long libraryId) {
        Long existingSprintGroupId = this.sprintGroupDao.findRootNodeIdByProjectIdAndName(projectId, sprintGroupName);
        if (existingSprintGroupId != null) {
            return existingSprintGroupId;
        }
        SprintGroup sprintGroup = new SprintGroup();
        sprintGroup.setName(sprintGroupName);
        this.addSprintGroupToCampaignLibrary(libraryId, sprintGroup);
        return sprintGroup.getId();
    }

    private Long createFoldersAndASprintGroup(List<String> paths, Long libraryId) {
        List<Long> existingNodeIds = this.campaignLibraryNodeDao.findNodeIdsByPath(paths);
        List pathSplitsWithoutProjectName = PathUtils.getSplitPathWithoutProjectNameFromAPath((String)paths.get(paths.size() - 1));
        if (existingNodeIds.size() == pathSplitsWithoutProjectName.size()) {
            return existingNodeIds.get(existingNodeIds.size() - 1);
        }
        int startIndex = existingNodeIds.isEmpty() ? 0 : existingNodeIds.size();
        int endIndex = pathSplitsWithoutProjectName.size() - 1;
        List foldersToCreate = pathSplitsWithoutProjectName.subList(startIndex, endIndex);
        CampaignFolder startingCampaignFolder = null;
        if (!existingNodeIds.isEmpty()) {
            startingCampaignFolder = (CampaignFolder)this.campaignFolderDao.findById(existingNodeIds.get(startIndex - 1));
        }
        CampaignFolder currentTreeFolder = startingCampaignFolder;
        for (String folder : foldersToCreate) {
            CampaignFolder campaignFolder = new CampaignFolder();
            campaignFolder.setName(folder);
            currentTreeFolder = Objects.isNull(currentTreeFolder) ? this.addFolderToLibrary((long)libraryId, campaignFolder) : this.addFolderToFolder((long)currentTreeFolder.getId(), campaignFolder);
        }
        SprintGroup sprintGroup = new SprintGroup();
        sprintGroup.setName((String)pathSplitsWithoutProjectName.get(pathSplitsWithoutProjectName.size() - 1));
        Long sprintGroupId = null;
        if (Objects.nonNull(currentTreeFolder)) {
            SprintGroup createdSprintGroup = this.addSprintGroupToCampaignFolder(currentTreeFolder.getId(), sprintGroup);
            sprintGroupId = createdSprintGroup.getId();
        }
        return sprintGroupId;
    }

    @Override
    @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, coercer=IterationToCampaignIdsCoercer.class)
    public OperationReport deleteIterations(@Ids List<Long> targetIds) {
        return this.deletionHandler.deleteIterations(targetIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' ,'EXPORT') or hasRole('ROLE_ADMIN')")
    public FileDto exportCampaignToCSV(Long campaignId, CampaignExportMode exportMode) {
        Campaign campaign = (Campaign)this.campaignDao.findById(campaignId);
        CampaignExport campaignExport = switch (exportMode) {
            case CampaignExportMode.FULL -> this.campaignFullExport;
            case CampaignExportMode.SIMPLE -> this.campaignSimpleExport;
            case CampaignExportMode.STANDARD -> this.campaignStandardExport;
            default -> throw new MatchException(null, null);
        };
        FileDto fileDto = campaignExport.getExportFile(campaign.getName());
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileWriter writer = this.writerFactory.createFileWriter(fileDto.file());){
                campaignExport.doExport(writer, campaignId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WriterException((Throwable)e);
        }
        return fileDto;
    }

    private Map<Long, String> findCampaignIdsAndComputePathAsNameFromMultiSelection(Set<Long> libraryIds, Set<Long> nodeIds, Set<Long> campaignIds) {
        Set<Long> readLibIds = this.securityFilterIds(libraryIds, CampaignLibrary.class.getName(), "READ");
        Set<Long> readNodeIds = this.securityFilterIds(nodeIds, CampaignLibraryNode.class.getName(), "READ");
        Set<Long> readCampIds = this.securityFilterIds(campaignIds, CampaignLibraryNode.class.getName(), "READ");
        HashMap<Long, String> campaignNameMap = new HashMap<Long, String>();
        if (!readLibIds.isEmpty()) {
            campaignNameMap.putAll(this.campaignDao.findAllCampaignIdsAndComputePathAsNameByLibraries(readLibIds));
        }
        if (!readNodeIds.isEmpty()) {
            campaignNameMap.putAll(this.campaignDao.findAllCampaignIdsAndComputePathAsNameByNodeIds(readNodeIds));
        }
        if (!readCampIds.isEmpty()) {
            campaignNameMap.putAll(this.campaignDao.findAllCampaignIdsAndNameByNodeIds(new ArrayList<Long>(readCampIds)));
        }
        this.appendMissingCampaignReferencesToCampaignNameMap(campaignNameMap);
        return campaignNameMap;
    }

    private void appendMissingCampaignReferencesToCampaignNameMap(Map<Long, String> campaignNameMap) {
        campaignNameMap.keySet().forEach(campaignIdKey -> {
            Campaign campaign;
            String campaignPath = (String)campaignNameMap.get(campaignIdKey);
            if (!campaignPath.contains((campaign = (Campaign)this.campaignDao.findById((long)campaignIdKey)).getFullName())) {
                campaignPath = campaignPath.replace(campaign.getName(), campaign.getFullName());
                campaignNameMap.replace((Long)campaignIdKey, campaignPath);
            }
        });
    }

    @Override
    public StatisticsBundle compileStatisticsFromSelection(NodeReferences nodeReferences, List<EntityReference> entityReferences, boolean lastExecutionScope) {
        boolean selectionHasDifferentNodeTypes = this.doesSelectionContainDifferentNodeTypes(entityReferences);
        boolean hasOnlyLibraryOrFolderNodeTypes = this.doesSelectionContainOnlyLibraryOrFolderNodeTypes(entityReferences);
        boolean hasIterationNodes = entityReferences.stream().anyMatch(entityReference -> entityReference.getType().equals((Object)EntityType.ITERATION));
        return this.getStatisticsForSelectionNodeTypes(nodeReferences, selectionHasDifferentNodeTypes, hasIterationNodes, hasOnlyLibraryOrFolderNodeTypes, lastExecutionScope);
    }

    private Boolean doesSelectionContainDifferentNodeTypes(List<EntityReference> entityReferences) {
        EntityReference firstNode = entityReferences.get(0);
        List<EntityReference> sameTypeNodes = entityReferences.stream().filter(node -> node.getType().equals((Object)firstNode.getType())).toList();
        if (sameTypeNodes.size() != entityReferences.size()) {
            return true;
        }
        return false;
    }

    private Boolean doesSelectionContainOnlyLibraryOrFolderNodeTypes(List<EntityReference> entityReferences) {
        List<EntityReference> libraryFolderTypeNodes = entityReferences.stream().filter(node -> EntityType.CAMPAIGN_LIBRARY.equals((Object)node.getType()) || EntityType.CAMPAIGN_FOLDER.equals((Object)node.getType())).toList();
        if (libraryFolderTypeNodes.size() == entityReferences.size()) {
            return true;
        }
        return false;
    }

    private StatisticsBundle getStatisticsForSelectionNodeTypes(NodeReferences nodeReferences, boolean selectionHasDifferentNodeTypes, boolean hasIterationNodes, boolean hasOnlyLibraryOrFolderNodeTypes, boolean lastExecutionScope) {
        StatisticsBundle statisticsBundle = new StatisticsBundle();
        if (selectionHasDifferentNodeTypes && !hasIterationNodes || Boolean.TRUE.equals(hasOnlyLibraryOrFolderNodeTypes)) {
            statisticsBundle = this.getCampaignMultiSelectionStatisticsBundle(nodeReferences, lastExecutionScope);
        } else if (!selectionHasDifferentNodeTypes && Boolean.TRUE.equals(hasIterationNodes)) {
            statisticsBundle = this.getIterationSelectionStatisticsBundle(nodeReferences, lastExecutionScope);
        } else if (Boolean.FALSE.equals(selectionHasDifferentNodeTypes)) {
            statisticsBundle = this.getCampaignSelectionStatisticsBundle(nodeReferences, lastExecutionScope);
        }
        return statisticsBundle;
    }

    private StatisticsBundle getCampaignMultiSelectionStatisticsBundle(NodeReferences nodeReferences, boolean lastExecutionScope) {
        StatisticsBundle statisticsBundle = new StatisticsBundle();
        Set<Long> selectedCampaignIds = this.extractCampaignIdsFromNodeReferences(nodeReferences);
        Map<Long, String> multiCampaignNameMap = this.findCampaignIdsAndComputePathAsNameFromMultiSelection(nodeReferences.extractLibraryIds(), nodeReferences.extractNonLibraryIds(), selectedCampaignIds);
        if (!multiCampaignNameMap.isEmpty()) {
            return this.campaignStatisticsService.gatherMultiStatisticsBundle(multiCampaignNameMap, lastExecutionScope);
        }
        return statisticsBundle;
    }

    private StatisticsBundle getIterationSelectionStatisticsBundle(NodeReferences nodeReferences, Boolean lastExecutionScope) {
        StatisticsBundle statisticsBundle = new StatisticsBundle();
        ArrayList<Long> iterationIds = new ArrayList<Long>(nodeReferences.extractNonLibraryIds());
        if (!iterationIds.isEmpty()) {
            this.permissionService.checkPermission(iterationIds, Permissions.READ.name(), Iteration.class.getName());
            return this.iterationStatisticsService.gatherIterationStatisticsBundle(iterationIds, lastExecutionScope);
        }
        return statisticsBundle;
    }

    private StatisticsBundle getCampaignSelectionStatisticsBundle(NodeReferences nodeReferences, Boolean lastExecutionScope) {
        StatisticsBundle statisticsBundle = new StatisticsBundle();
        ArrayList<Long> campaignIds = new ArrayList<Long>(nodeReferences.extractNonLibraryIds());
        if (!campaignIds.isEmpty()) {
            this.permissionService.checkPermission(campaignIds, Permissions.READ.name(), Campaign.class.getName());
            return this.campaignStatisticsService.gatherCampaignStatisticsBundle(campaignIds, lastExecutionScope);
        }
        return statisticsBundle;
    }

    private Set<Long> extractCampaignIdsFromNodeReferences(NodeReferences nodeReferences) {
        return nodeReferences.extractNonLibraries().stream().filter(nodeReference -> nodeReference.getNodeType().equals((Object)NodeType.CAMPAIGN)).map(NodeReference::getId).collect(Collectors.toSet());
    }

    @Override
    @BatchPreventConcurrent(entityType=Iteration.class, coercer=TestSuiteToIterationCoercerForList.class)
    @CheckBlockingMilestones(entityType=TestSuite.class)
    public OperationReport deleteSuites(@Ids List<Long> suiteIds, boolean removeFromIter) {
        return this.deletionHandler.deleteSuites(suiteIds, removeFromIter);
    }

    @Override
    public StatisticsBundle gatherCampaignStatisticsBundleByMilestone(boolean lastExecutionScope) {
        return this.campaignStatisticsService.gatherMilestoneStatisticsBundle(lastExecutionScope);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary' ,'READ')  or hasRole('ROLE_ADMIN')")
    public StatisticsBundle gatherLibraryStatisticsBundle(long libraryId, boolean lastExecutionScope) {
        Map<Long, String> campaignNameMap = this.campaignDao.findAllCampaignIdsAndNameByLibraryIds(Arrays.asList(libraryId));
        return this.campaignStatisticsService.gatherMultiStatisticsBundle(campaignNameMap, lastExecutionScope);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campaignId, 'org.squashtest.tm.domain.campaign.Campaign' , 'READ') or hasRole('ROLE_ADMIN')")
    public StatisticsBundle gatherCampaignStatisticsBundle(long campaignId, boolean lastExecutionScope) {
        return this.campaignStatisticsService.gatherCampaignStatisticsBundle(Arrays.asList(campaignId), lastExecutionScope);
    }

    @Override
    @PreAuthorize(value="hasPermission(#campFolderId, 'org.squashtest.tm.domain.campaign.CampaignFolder', 'READ') or hasRole('ROLE_ADMIN')")
    public StatisticsBundle gatherFolderStatisticsBundle(Long campFolderId, boolean lastExecutionScope) {
        Map<Long, String> campaignNameMap = this.campaignDao.findAllCampaignIdsAndNameByNodeIds(Arrays.asList(campFolderId));
        return this.campaignStatisticsService.gatherMultiStatisticsBundle(campaignNameMap, lastExecutionScope);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public CampaignFolder addFolderToFolder(@Id long destinationId, CampaignFolder newFolder) {
        super.addFolderToFolder(destinationId, newFolder);
        this.generateCUF(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public CampaignFolder addFolderToFolder(@Id long destinationId, CampaignFolder newFolder, Map<Long, RawValue> customFields) {
        return super.addFolderToFolder(destinationId, newFolder, customFields);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public CampaignFolder addFolderToFolder(@Id long destinationId, NewFolderDto folderDto) {
        CampaignFolder newFolder = (CampaignFolder)folderDto.toFolder(EntityType.CAMPAIGN_FOLDER);
        return this.addFolderToFolder(destinationId, newFolder, (Map<Long, RawValue>)folderDto.getCustomFields());
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public CampaignFolder addFolderToLibrary(@Id long destinationId, CampaignFolder newFolder) {
        super.addFolderToLibrary(destinationId, newFolder);
        this.generateCUF(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public CampaignFolder addFolderToLibrary(@Id long destinationId, CampaignFolder newFolder, Map<Long, RawValue> customFields) {
        return super.addFolderToLibrary(destinationId, newFolder, customFields);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    public CampaignFolder addFolderToLibrary(@Id long destinationId, NewFolderDto folderDto) {
        CampaignFolder newFolder = (CampaignFolder)folderDto.toFolder(EntityType.CAMPAIGN_FOLDER);
        return this.addFolderToLibrary(destinationId, newFolder, (Map<Long, RawValue>)folderDto.getCustomFields());
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public void addFolderToSprintGroup(@Id long destinationId, CampaignFolder newFolder) {
        SprintGroup sprintGroup = (SprintGroup)this.sprintGroupDao.findById(destinationId);
        sprintGroup.addContent((CampaignLibraryNode)newFolder);
        this.getFolderDao().persist(newFolder);
        this.generateCUF(newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public CampaignFolder addFolderToSprintGroup(@Id long destinationId, CampaignFolder newFolder, Map<Long, RawValue> customFields) {
        SprintGroup sprintGroup = (SprintGroup)this.sprintGroupDao.findById(destinationId);
        sprintGroup.addContent((CampaignLibraryNode)newFolder);
        this.getFolderDao().persist(newFolder);
        this.createCustomFieldValues((BoundEntity)newFolder);
        if (customFields != null && !customFields.isEmpty()) {
            this.customFieldValueService.initCustomFieldValues((BoundEntity)newFolder, customFields);
        }
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibraryNode.class)
    public CampaignFolder addFolderToSprintGroup(@Id long destinationId, NewFolderDto folderDto) {
        CampaignFolder newFolder = (CampaignFolder)folderDto.toFolder(EntityType.CAMPAIGN_FOLDER);
        return this.addFolderToSprintGroup(destinationId, newFolder, folderDto.getCustomFields());
    }

    @Override
    @PreventConcurrent(entityType=CampaignLibrary.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public TestSuite addTestSuiteToIteration(@Id Long iterationId, TestSuite suite, Map<Long, RawValue> customFieldValues) {
        return this.addTestSuiteToIterationUnsecured(iterationId, suite, customFieldValues);
    }

    @Override
    public TestSuite addTestSuiteToIterationUnsecured(@Id Long iterationId, TestSuite suite, Map<Long, RawValue> customFieldValues) {
        this.iterationModificationService.addTestSuiteUnsecured(iterationId, suite, customFieldValues);
        this.createAttachmentForTestSuite(suite);
        return suite;
    }

    private void createAttachmentForTestSuite(TestSuite suite) {
        String description = suite.getDescription();
        if (description == null || description.isEmpty()) {
            return;
        }
        String html = this.attachmentManagerService.handleRichTextAttachments(description, suite.getAttachmentList());
        if (!description.equals(html)) {
            suite.setDescription(html);
        }
    }

    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.campaignLibraryDao.findContentNamesByLibraryId(libraryId);
    }

    @Override
    public Map<Long, List<String>> findContentNamesByNodeIds(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.campaignLibraryDao.findContentNamesByNodeIds(nodeIds);
    }

    @Override
    public OperationReport deleteNodes(CampaignLibraryNodesToDelete deletionNodes, boolean iter) {
        this.unbindMilestonesFromNodes(deletionNodes.getCampaignIds());
        OperationReport nodesReport = this.deleteNodes(deletionNodes.getCampaignLibraryNodeIds());
        OperationReport suiteReport = this.deleteSuites(deletionNodes.getSuiteIds(), iter);
        OperationReport iterationReport = this.deleteIterations(deletionNodes.getIterationIds());
        OperationReport totalReport = new OperationReport();
        totalReport.addRemoved(nodesReport.getRemoved());
        totalReport.addRemoved(suiteReport.getRemoved());
        totalReport.addRemoved(iterationReport.getRemoved());
        return totalReport;
    }

    private void unbindMilestonesFromNodes(List<Long> nodesIds) {
        nodesIds.forEach(campaignId -> {
            Collection<Milestone> milestones = this.customCampaignModificationService.findAllMilestones((long)campaignId);
            List<Long> milestonesIds = milestones.stream().map(Milestone::getId).toList();
            this.milestoneManager.unbindCampaignFromMilestonesUnsecured((long)campaignId, (Collection<Long>)milestonesIds);
        });
    }

    private void generateCUF(CampaignFolder newFolder) {
        List<CustomFieldBinding> projectsBindings = this.customFieldBindingFinderService.findCustomFieldsForProjectAndEntity(newFolder.getProject().getId(), BindableEntity.CAMPAIGN_FOLDER);
        for (CustomFieldBinding binding : projectsBindings) {
            this.customFieldValueService.cascadeCustomFieldValuesCreationNotCreatedFolderYet(binding, (BoundEntity)newFolder);
        }
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="sourceNodesIds", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="sourceNodesIds", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void copyNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="sourceNodesIds") Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        this.checkIllegalSprintGroupHierarchy(destinationId, sourceNodesIds);
        NodeType nodePaste = this.campaignWorkspaceStrategyCopierService.verifyPermissionAndGetNodePaste(clipboardPayload);
        this.campaignWorkspaceStrategyCopierService.copyNodeToCampaignFolder(destinationId, clipboardPayload, nodePaste);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void copyNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetIds, ClipboardPayload clipboardPayload) {
        NodeType nodePaste = this.campaignWorkspaceStrategyCopierService.verifyPermissionAndGetNodePaste(clipboardPayload);
        this.campaignWorkspaceStrategyCopierService.copyNodeToCampaignLibrary(destinationId, clipboardPayload, nodePaste);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void copyNodesToSprintGroup(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetIds, ClipboardPayload clipboardPayload) {
        if (targetIds.length == 0) {
            return;
        }
        this.checkCanAddSelectionToSprintGroup(targetIds);
        NodeType nodePaste = this.campaignWorkspaceStrategyCopierService.verifyPermissionAndGetNodePaste(clipboardPayload);
        this.campaignWorkspaceStrategyCopierService.copyNodeToSpringGroup(destinationId, clipboardPayload, nodePaste);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetIds, ClipboardPayload clipboardPayload) {
        this.checkIllegalSprintGroupHierarchy(destinationId, targetIds);
        super.moveNodesToFolder(destinationId, targetIds, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibraryNode.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void moveNodesToFolder(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetIds, int position, ClipboardPayload clipboardPayload) {
        this.checkIllegalSprintGroupHierarchy(destinationId, targetIds);
        super.moveNodesToFolder(destinationId, targetIds, position, clipboardPayload);
    }

    private void checkIllegalSprintGroupHierarchy(long destinationId, Long[] targetIds) {
        if (!this.isInSprintGroup(destinationId)) {
            return;
        }
        List<Long> targetIdsList = Arrays.asList(targetIds);
        if (this.doesSelectionContainSprintGroup(targetIdsList) || this.doesSelectionContainCampaign(targetIdsList)) {
            throw new IllegalSprintGroupHierarchyException();
        }
    }

    private boolean isInSprintGroup(long folderId) {
        return this.sprintGroupDisplayDao.findParentSprintGroupId(folderId) != null;
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetIds, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetIds, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void moveNodesToLibrary(@Id(value="destinationId") long destinationId, @Ids(value="targetId") Long[] targetIds, int position, ClipboardPayload clipboardPayload) {
        super.moveNodesToLibrary(destinationId, targetIds, position, clipboardPayload);
    }

    @Override
    @PreventConcurrents(simplesLocks={@PreventConcurrent(entityType=CampaignLibrary.class, paramName="destinationId")}, batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetId", coercer=CampaignLibraryIdsCoercerForArray.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetId", coercer=CLNAndParentIdsCoercerForArray.class)})
    public void moveNodesToSprintGroup(@Id(value="destinationId") Long destinationId, @Ids(value="targetId") Long[] movedNodeIds, ClipboardPayload clipboardPayload) {
        if (movedNodeIds.length == 0) {
            return;
        }
        this.checkCanAddSelectionToSprintGroup(movedNodeIds);
        try {
            PasteStrategy pasteStrategy = (PasteStrategy)this.pasteToSprintGroupStrategyProvider.get();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(destinationId, clipboardPayload);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    private void checkCanAddSelectionToSprintGroup(Long[] movedNodeIds) {
        if (this.doesSelectionContainSprintGroup(List.of(movedNodeIds))) {
            throw new IllegalSprintGroupHierarchyException();
        }
        if (this.doesSelectionContainCampaign(List.of(movedNodeIds))) {
            throw new IllegalSprintGroupHierarchyException();
        }
    }

    private boolean doesSelectionContainSprintGroup(List<Long> movedNodeIds) {
        return !this.sprintGroupDisplayDao.findContainedSprintGroupIds(movedNodeIds).isEmpty();
    }

    private boolean doesSelectionContainCampaign(List<Long> movedNodeIds) {
        return !this.campaignDisplayDao.findContainedCampaignIds(movedNodeIds).isEmpty();
    }

    @Override
    @PreventConcurrents(batchsLocks={@BatchPreventConcurrent(entityType=CampaignLibrary.class, paramName="targetIds", coercer=CampaignLibraryIdsCoercerForList.class), @BatchPreventConcurrent(entityType=CampaignLibraryNode.class, paramName="targetIds", coercer=CLNAndParentIdsCoercerForList.class)})
    @CheckBlockingMilestones(entityType=Campaign.class)
    public OperationReport deleteNodes(@Ids(value="targetIds") List<Long> targetIds) {
        return super.deleteNodes(targetIds);
    }

    @Override
    public DeletionPreview simulateNodesDeletion(CampaignLibraryNodesToDelete nodes) {
        return this.deletionHandler.simulateDeletion(nodes.getCampaignLibraryNodeIds()).merge(this.deletionHandler.simulateIterationDeletion(nodes.getIterationIds()), this.getDeletionThreshold()).merge(this.deletionHandler.simulateSuiteDeletion(nodes.getSuiteIds()), this.getDeletionThreshold());
    }

    private long getDeletionThreshold() {
        String strThreshold = this.configurationService.findConfiguration(DELETION_THRESHOLD_KEY);
        if ("".equals(strThreshold)) {
            return 0L;
        }
        return Long.parseLong(strThreshold);
    }
}

