/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction.container;

import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.service.importer.ImportLog;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ProjectImport;
import org.squashtest.tm.service.internal.batchimport.instruction.Instruction;
import org.squashtest.tm.service.internal.batchimport.instruction.container.InstructionContainer;
import org.squashtest.tm.service.internal.repository.ProjectDao;

public class Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Importer.class);
    private final Map<String, ProjectImport> projectImports = new HashMap<String, ProjectImport>();
    private final List<Instruction<?>> invalidInstructions = new ArrayList();

    public void addErrorInstruction(Instruction<?> instruction) {
        this.invalidInstructions.add(instruction);
    }

    public void addInstructionContainer(String project, InstructionContainer<?> instructionContainer) {
        this.projectImports.computeIfAbsent(project, ProjectImport::new).addInstructionContainer(instructionContainer);
    }

    public <T extends Facility> ImportLog performImport(Provider<T> facilityProvider, ProjectDao projectDao) {
        ImportLog importLog = new ImportLog();
        this.projectImports.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).forEach(projectImport -> {
            LOGGER.info("Data import for the project '{}'", new Object[]{projectImport.getProject()});
            Project project = projectDao.findByName(projectImport.getProject());
            if (project == null) {
                this.handleMissingProject((ProjectImport)projectImport, importLog);
            } else {
                Facility facility = (Facility)facilityProvider.get();
                for (InstructionContainer<?> container : projectImport.getContainers()) {
                    container.executeInstructions(facility, project).forEach(instruction -> this.processLog((Instruction<?>)instruction, importLog));
                }
            }
        });
        this.invalidInstructions.forEach(instruction -> this.processLog((Instruction<?>)instruction, importLog));
        importLog.packLogs();
        return importLog;
    }

    private void handleMissingProject(ProjectImport projectImport, ImportLog importLog) {
        LOGGER.error("Project '{}' does not exist, instructions will not be executed", new Object[]{projectImport.getProject()});
        for (InstructionContainer<?> containers : projectImport.getContainers()) {
            containers.getAllInstructions().forEach(instruction -> {
                this.createLogForMissingProject((Instruction<?>)instruction);
                this.processLog((Instruction<?>)instruction, importLog);
            });
        }
    }

    private void processLog(Instruction<?> instruction, ImportLog importLog) {
        LogTrain logs = instruction.getLogTrain();
        this.handleLogs(instruction, logs);
        logs.setForAll(instruction.getMode());
        logs.setForAll(instruction.getLine());
        importLog.appendLogTrain(logs);
    }

    private void createLogForMissingProject(Instruction<?> instruction) {
        instruction.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.tc.tcPath.projectNotFound", null, new Object[0]);
    }

    private void handleLogs(Instruction<?> instruction, LogTrain logs) {
        if (logs.hasNoErrorWhatsoever()) {
            LOGGER.debug("No errors when executing instruction : (line {}) {} '{}'", new Object[]{instruction.getLine(), instruction.getMode(), instruction.getTarget()});
            logs.addEntry(LogEntry.ok().forTarget((Target)instruction.getTarget()).build());
        } else {
            LOGGER.warn("Errors were encountered for instruction : (line {}) {} '{}', they will be reported to the user.", new Object[]{instruction.getLine(), instruction.getMode(), instruction.getTarget()});
        }
    }
}

