/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.scripted.gherkin;

import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.ScriptedExecution;

public class GherkinStepGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GherkinStepGenerator.class);
    private static final String STEP_KEYWORD_CLASS_NAME = "step-keyword";
    private static final String GIVEN_KEYWORD_CLASS_NAME = "step-keyword-given";
    private static final String WHEN_KEYWORD_CLASS_NAME = "step-keyword-when";
    private static final String THEN_KEYWORD_CLASS_NAME = "step-keyword-then";
    private static final String STEP_DOC_STRING_CLASS_NAME = "step-doc-string";
    private static final String ARGUMENT_TABLE_CLASS_NAME = "step-table";
    private static final String ARGUMENT_TABLE_TR_CLASS_NAME = "step-table-tr";
    private static final String ARGUMENT_TABLE_TD_CLASS_NAME = "step-table-td";
    private static final String SCENARIO_KEYWORD_CLASS_NAME = "scenario-keyword";
    private static final String SCENARIO_DESCRIPTION_CLASS_NAME = "scenario-description";
    private static final String TABLE_TAG = "table";
    private static final String ROW_TAG = "tr";
    private static final String CELL_TAG = "td";
    private static final String SPAN_TAG = "span";
    private GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
    private GherkinDialect dialect;
    private String currentStepClass = "";

    public void populateExecution(ScriptedExecution scriptedExecution, GherkinDocument gherkinDocument) {
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return;
        }
        scriptedExecution.setScriptName(feature.getName());
        this.initDialect(feature);
        List scenarioDefinitions = feature.getChildren();
        if (scenarioDefinitions.isEmpty()) {
            return;
        }
        ScenarioDefinition potentialBackground = (ScenarioDefinition)scenarioDefinitions.get(0);
        Background background = null;
        if (potentialBackground instanceof Background) {
            background = (Background)potentialBackground;
            StringBuilder preRequisiteBuilder = new StringBuilder();
            this.appendBackground(background, preRequisiteBuilder);
            scriptedExecution.setPrerequisite(preRequisiteBuilder.toString());
        }
        for (ScenarioDefinition scenarioDefinition : scenarioDefinitions) {
            if (scenarioDefinition instanceof Scenario) {
                this.appendScenarioStep(scriptedExecution, background, scenarioDefinition);
                continue;
            }
            if (!(scenarioDefinition instanceof ScenarioOutline)) continue;
            this.appendScenarioOutlineStep(scriptedExecution, background, scenarioDefinition);
        }
    }

    private void initDialect(Feature feature) {
        String language = feature.getLanguage();
        this.dialect = StringUtils.isNotBlank((CharSequence)language) ? this.dialectProvider.getDialect(language, null) : this.dialectProvider.getDefaultDialect();
    }

    private void appendScenarioStep(ScriptedExecution scriptedExecution, Background background, ScenarioDefinition scenarioDefinition) {
        StringBuilder sb = new StringBuilder();
        Scenario scenario = (Scenario)scenarioDefinition;
        this.appendScenarioLine(scenarioDefinition, sb);
        if (background != null) {
            this.appendBackground(background, sb);
        }
        List steps = scenario.getSteps();
        for (Step step : steps) {
            this.appendStepLine(step, sb);
        }
        this.appendExecutionStep(scriptedExecution, sb);
    }

    private void appendScenarioOutlineStep(ScriptedExecution scriptedExecution, Background background, ScenarioDefinition scenarioDefinition) {
        ScenarioOutline scenario = (ScenarioOutline)scenarioDefinition;
        List examples = scenario.getExamples();
        for (Examples example : examples) {
            this.appendExample(scriptedExecution, background, scenario, example);
        }
    }

    private void appendExample(ScriptedExecution scriptedExecution, Background background, ScenarioOutline scenario, Examples example) {
        int count = example.getTableBody().size();
        List<String> headers = this.getExampleHeaders(example);
        int nbColumn = headers.size();
        List steps = scenario.getSteps();
        int i = 0;
        while (i < count) {
            StringBuilder sb = new StringBuilder();
            this.appendScenarioLine((ScenarioDefinition)scenario, sb);
            if (background != null) {
                this.appendBackground(background, sb);
            }
            List<String> valuesForThisLine = this.getExampleLineValue(example, i);
            HashMap<String, String> valueByHeader = new HashMap<String, String>();
            IntStream.range(0, nbColumn).forEach(j -> {
                String string = valueByHeader.put((String)headers.get(j), (String)valuesForThisLine.get(j));
            });
            for (Step step : steps) {
                this.appendStepLine(step, valueByHeader, sb);
            }
            this.appendExecutionStep(scriptedExecution, sb);
            ++i;
        }
    }

    private void appendExecutionStep(ScriptedExecution scriptedExecution, StringBuilder sb) {
        ExecutionStep executionStep = new ExecutionStep();
        executionStep.setAction(sb.toString());
        scriptedExecution.getSteps().add(executionStep);
    }

    private List<String> getExampleLineValue(Examples example, int i) {
        return ((TableRow)example.getTableBody().get(i)).getCells().stream().map(TableCell::getValue).toList();
    }

    private List<String> getExampleHeaders(Examples example) {
        return example.getTableHeader().getCells().stream().map(TableCell::getValue).toList();
    }

    private void appendBackground(Background background, StringBuilder sb) {
        List steps = background.getSteps();
        for (Step step : steps) {
            this.appendStepLine(step, sb);
        }
    }

    private void appendStepLine(Step step, StringBuilder sb) {
        this.appendStepKeyword(step, sb);
        sb.append(step.getText());
        this.appendLineBreak(sb);
        this.appendArgument(step, sb);
    }

    private void appendArgument(Step step, StringBuilder sb) {
        Node argument = step.getArgument();
        if (argument == null) {
            return;
        }
        this.appendLineBreak(sb);
        if (argument instanceof DocString) {
            DocString docString = (DocString)argument;
            this.appendClassSpan(sb, docString.getContent(), STEP_DOC_STRING_CLASS_NAME);
        } else if (argument instanceof DataTable) {
            DataTable dataTable = (DataTable)argument;
            this.appendOpeningClassTab(sb, TABLE_TAG, ARGUMENT_TABLE_CLASS_NAME);
            for (TableRow tableRow : dataTable.getRows()) {
                this.appendOpeningClassTab(sb, ROW_TAG, ARGUMENT_TABLE_TR_CLASS_NAME);
                for (TableCell tableCell : tableRow.getCells()) {
                    this.appendOpeningClassTab(sb, CELL_TAG, ARGUMENT_TABLE_TD_CLASS_NAME);
                    sb.append(tableCell.getValue());
                    this.appendClosingTab(sb, CELL_TAG);
                }
                this.appendClosingTab(sb, ROW_TAG);
            }
            this.appendClosingTab(sb, TABLE_TAG);
            this.appendLineBreak(sb);
        }
    }

    private void appendClassSpan(StringBuilder sb, String text, String ... cssClass) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.appendOpeningClassTab(sb, SPAN_TAG, cssClass);
            sb.append(StringUtils.appendIfMissing((String)text, (CharSequence)" ", (CharSequence[])new CharSequence[0]));
            this.appendClosingTab(sb, SPAN_TAG);
        }
    }

    private void appendClosingTab(StringBuilder sb, String tag) {
        sb.append("</").append(tag).append(">");
    }

    private void appendOpeningClassTab(StringBuilder sb, String tag, String ... cssClass) {
        sb.append("<").append(tag);
        if (cssClass.length > 0) {
            sb.append(" class='");
            sb.append(StringUtils.join((Object[])cssClass, (String)" "));
            sb.append("'");
        }
        sb.append(">");
    }

    private void appendScenarioLine(ScenarioDefinition scenarioDefinition, StringBuilder sb) {
        String keyword = scenarioDefinition.getKeyword();
        this.appendClassSpan(sb, keyword, SCENARIO_KEYWORD_CLASS_NAME);
        sb.append(scenarioDefinition.getName());
        this.appendClassSpan(sb, scenarioDefinition.getDescription(), SCENARIO_DESCRIPTION_CLASS_NAME);
    }

    private void appendLineBreak(StringBuilder sb) {
        sb.append("<br>");
    }

    private void appendStepLine(Step step, Map<String, String> valueByHeader, StringBuilder sb) {
        this.appendStepKeyword(step, sb);
        String text = step.getText();
        text = this.performParamSubstitution(valueByHeader, text);
        sb.append(text);
        this.appendLineBreak(sb);
    }

    private String performParamSubstitution(Map<String, String> valueByHeader, String text) {
        Pattern p = Pattern.compile("<[.*?[^>]]*>");
        Matcher m = p.matcher(text);
        while (m.find()) {
            String token = m.group();
            String header = token.substring(1, token.length() - 1);
            String value = valueByHeader.get(header);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = "<NO_DATA>";
            }
            text = text.replace(token, value);
        }
        return text;
    }

    private void appendStepKeyword(Step step, StringBuilder sb) {
        String keyword = step.getKeyword();
        if (!this.isContinuousKeyword(keyword)) {
            this.appendLineBreak(sb);
            this.changeCurrentStepClass(keyword);
        }
        this.appendClassSpan(sb, keyword, STEP_KEYWORD_CLASS_NAME, this.currentStepClass);
    }

    private void changeCurrentStepClass(String keyword) {
        if (this.dialect.getGivenKeywords().contains(keyword)) {
            this.currentStepClass = GIVEN_KEYWORD_CLASS_NAME;
        } else if (this.dialect.getWhenKeywords().contains(keyword)) {
            this.currentStepClass = WHEN_KEYWORD_CLASS_NAME;
        } else if (this.dialect.getThenKeywords().contains(keyword)) {
            this.currentStepClass = THEN_KEYWORD_CLASS_NAME;
        } else {
            LOGGER.warn("No css class defined for Gherkin step keyword {} ", new Object[]{keyword});
            this.currentStepClass = "";
        }
    }

    private boolean isContinuousKeyword(String keyword) {
        return this.dialect.getAndKeywords().contains(keyword) || this.dialect.getButKeywords().contains(keyword);
    }
}

