/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.HashMap;
import java.util.Map;
import org.jooq.Field;
import org.jooq.Record4;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public enum RelationshipDefinition {
    TEST_CASE_LIBRARY_RELATION(NodeType.TEST_CASE_LIBRARY, Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID, Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.TEST_CASE, Tables.TEST_CASE.TCLN_ID);
            relations.put(NodeType.TEST_CASE_FOLDER, Tables.TEST_CASE_FOLDER.TCLN_ID);
            return relations;
        }

        @Override
        public void addAdditionalJoins(SelectOnConditionStep<Record4<String, Long, Long, Integer>> joinQuery, NodeType key) {
            joinQuery.innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN));
        }
    }
    ,
    TEST_CASE_FOLDER_RELATION(NodeType.TEST_CASE_FOLDER, Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, Tables.TCLN_RELATIONSHIP.DESCENDANT_ID, Tables.TCLN_RELATIONSHIP.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.TEST_CASE, Tables.TEST_CASE.TCLN_ID);
            relations.put(NodeType.TEST_CASE_FOLDER, Tables.TEST_CASE_FOLDER.TCLN_ID);
            return relations;
        }

        @Override
        public void addAdditionalJoins(SelectOnConditionStep<Record4<String, Long, Long, Integer>> joinQuery, NodeType key) {
            joinQuery.innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN));
        }
    }
    ,
    REQUIREMENT_LIBRARY_RELATION(NodeType.REQUIREMENT_LIBRARY, Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT, Tables.REQUIREMENT.RLN_ID);
            relations.put(NodeType.HIGH_LEVEL_REQUIREMENT, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID);
            relations.put(NodeType.REQUIREMENT_FOLDER, Tables.REQUIREMENT_FOLDER.RLN_ID);
            return relations;
        }

        @Override
        public void addAdditionalJoins(SelectOnConditionStep<Record4<String, Long, Long, Integer>> joinQuery, NodeType lookedNodeType) {
            if (NodeType.REQUIREMENT == lookedNodeType) {
                joinQuery.leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID));
            }
        }

        @Override
        public void addAdditionalCriteria(SelectConditionStep<Record4<String, Long, Long, Integer>> query, NodeType lookedNodeType) {
            if (NodeType.REQUIREMENT == lookedNodeType) {
                query.and(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNull());
            }
        }
    }
    ,
    REQUIREMENT_FOLDER_RELATION(NodeType.REQUIREMENT_FOLDER, Tables.RLN_RELATIONSHIP.ANCESTOR_ID, Tables.RLN_RELATIONSHIP.DESCENDANT_ID, Tables.RLN_RELATIONSHIP.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT, Tables.REQUIREMENT.RLN_ID);
            relations.put(NodeType.HIGH_LEVEL_REQUIREMENT, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID);
            relations.put(NodeType.REQUIREMENT_FOLDER, Tables.REQUIREMENT_FOLDER.RLN_ID);
            return relations;
        }

        @Override
        public void addAdditionalJoins(SelectOnConditionStep<Record4<String, Long, Long, Integer>> joinQuery, NodeType lookedNodeType) {
            if (NodeType.REQUIREMENT == lookedNodeType) {
                joinQuery.leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID));
            }
        }

        @Override
        public void addAdditionalCriteria(SelectConditionStep<Record4<String, Long, Long, Integer>> query, NodeType lookedNodeType) {
            if (NodeType.REQUIREMENT == lookedNodeType) {
                query.and(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNull());
            }
        }
    }
    ,
    REQUIREMENT_RELATION(NodeType.REQUIREMENT, Tables.RLN_RELATIONSHIP.ANCESTOR_ID, Tables.RLN_RELATIONSHIP.DESCENDANT_ID, Tables.RLN_RELATIONSHIP.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT, Tables.REQUIREMENT.RLN_ID);
            return relations;
        }
    }
    ,
    HIGH_LEVEL_REQUIREMENT_RELATION(NodeType.HIGH_LEVEL_REQUIREMENT, Tables.RLN_RELATIONSHIP.ANCESTOR_ID, Tables.RLN_RELATIONSHIP.DESCENDANT_ID, Tables.RLN_RELATIONSHIP.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT, Tables.REQUIREMENT.RLN_ID);
            return relations;
        }
    }
    ,
    CAMPAIGN_LIBRARY_RELATION(NodeType.CAMPAIGN_LIBRARY, Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            relations.put(NodeType.CAMPAIGN, Tables.CAMPAIGN.CLN_ID);
            relations.put(NodeType.SPRINT, Tables.SPRINT.CLN_ID);
            relations.put(NodeType.SPRINT_GROUP, Tables.SPRINT_GROUP.CLN_ID);
            return relations;
        }
    }
    ,
    CAMPAIGN_FOLDER_RELATION(NodeType.CAMPAIGN_FOLDER, Tables.CLN_RELATIONSHIP.ANCESTOR_ID, Tables.CLN_RELATIONSHIP.DESCENDANT_ID, Tables.CLN_RELATIONSHIP.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            relations.put(NodeType.CAMPAIGN, Tables.CAMPAIGN.CLN_ID);
            relations.put(NodeType.SPRINT, Tables.SPRINT.CLN_ID);
            relations.put(NodeType.SPRINT_GROUP, Tables.SPRINT_GROUP.CLN_ID);
            return relations;
        }
    }
    ,
    CAMPAIGN_RELATION(NodeType.CAMPAIGN, Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, Tables.CAMPAIGN_ITERATION.ITERATION_ID, Tables.CAMPAIGN_ITERATION.ITERATION_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.ITERATION, Tables.ITERATION.ITERATION_ID);
            return relations;
        }
    }
    ,
    ITERATION_RELATION(NodeType.ITERATION, Tables.ITERATION_TEST_SUITE.ITERATION_ID, Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, Tables.ITERATION_TEST_SUITE.ITERATION_TEST_SUITE_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.TEST_SUITE, Tables.TEST_SUITE.ID);
            return relations;
        }
    }
    ,
    SPRINT_GROUP_RELATION(NodeType.SPRINT_GROUP, Tables.CLN_RELATIONSHIP.ANCESTOR_ID, Tables.CLN_RELATIONSHIP.DESCENDANT_ID, Tables.CLN_RELATIONSHIP.CONTENT_ORDER){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            relations.put(NodeType.SPRINT, Tables.SPRINT.CLN_ID);
            return relations;
        }
    };

    private final NodeType nodeType;
    private final TableField<?, Long> ancestorField;
    private final TableField<?, Long> descendantField;
    private final TableField<?, Integer> orderField;

    private RelationshipDefinition(NodeType nodeType, TableField<?, Long> ancestorField, TableField<?, Long> descendantField, TableField<?, Integer> orderField) {
        this.nodeType = nodeType;
        this.ancestorField = ancestorField;
        this.descendantField = descendantField;
        this.orderField = orderField;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public TableField<?, Long> getAncestorField() {
        return this.ancestorField;
    }

    public TableField<?, Long> getDescendantField() {
        return this.descendantField;
    }

    public TableField<?, Integer> getOrderField() {
        return this.orderField;
    }

    public void addAdditionalCriteria(SelectConditionStep<Record4<String, Long, Long, Integer>> query, NodeType lookedNodeType) {
    }

    public abstract Map<NodeType, TableField<?, Long>> getRelationshipIds();

    public void addAdditionalJoins(SelectOnConditionStep<Record4<String, Long, Long, Integer>> joinQuery, NodeType key) {
    }
}

