/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.service.campaign.CampaignStatisticsService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignStatisticsDao;
import org.squashtest.tm.service.internal.repository.CustomItpiLastExecutionFilterDao;
import org.squashtest.tm.service.internal.repository.IterationStatisticsDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.statistics.CountOnEnum;
import org.squashtest.tm.service.statistics.campaign.CampaignTestCaseSuccessRateStatistics;
import org.squashtest.tm.service.statistics.campaign.ProgressionStatistics;
import org.squashtest.tm.service.statistics.campaign.ScheduledIteration;
import org.squashtest.tm.service.statistics.campaign.StatisticsBundle;
import org.squashtest.tm.service.statistics.campaign.TestInventoryStatistics;

@Transactional(readOnly=true)
@Service
public class CampaignStatisticsServiceImpl
implements CampaignStatisticsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignStatisticsServiceImpl.class);
    private final CampaignDao campaignDao;
    private final ActiveMilestoneHolder activeMilestoneHolder;
    private final CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao;
    private final PermissionEvaluationService permissionService;
    private final CampaignStatisticsDao campaignStatisticsDao;
    private final IterationStatisticsDao iterationStatisticsDao;

    public CampaignStatisticsServiceImpl(CampaignDao campaignDao, ActiveMilestoneHolder activeMilestoneHolder, CustomItpiLastExecutionFilterDao itpiLastExecutionFilterDao, PermissionEvaluationService permissionService, CampaignStatisticsDao campaignStatisticsDao, IterationStatisticsDao iterationStatisticsDao) {
        this.campaignDao = campaignDao;
        this.activeMilestoneHolder = activeMilestoneHolder;
        this.itpiLastExecutionFilterDao = itpiLastExecutionFilterDao;
        this.permissionService = permissionService;
        this.campaignStatisticsDao = campaignStatisticsDao;
        this.iterationStatisticsDao = iterationStatisticsDao;
    }

    @Override
    public StatisticsBundle gatherCampaignStatisticsBundle(List<Long> campaignIds, boolean lastExecutionScope) {
        boolean isSolitaryCampaign = campaignIds.size() == 1;
        StatisticsBundle bundle = lastExecutionScope ? this.initializeStatisticsBundleForLastExecutionScope(campaignIds) : this.initializeStatisticsBundle(campaignIds);
        List<TestInventoryStatistics> inventory = isSolitaryCampaign ? this.gatherSingleCampaignTestInventoryStatistics(campaignIds.get(0)) : this.gatherManyCampaignTestInventoryStatistics(campaignIds);
        ProgressionStatistics progression = isSolitaryCampaign ? this.gatherSingleCampaignProgressionStatistics(campaignIds.get(0)) : new ProgressionStatistics();
        bundle.setTestInventoryStatistics(inventory);
        bundle.setProgressionStatistics(progression);
        bundle.setSelectedIds(campaignIds);
        return bundle;
    }

    @Override
    public StatisticsBundle gatherMilestoneStatisticsBundle(boolean lastExecutionScope) {
        List<Long> campaignIds = this.filterCampaignIdsByActiveMilestone(new ArrayList<Long>());
        this.permissionService.checkPermission(campaignIds, Permissions.READ.name(), Campaign.class.getName());
        StatisticsBundle bundle = lastExecutionScope ? this.initializeStatisticsBundleForLastExecutionScope(campaignIds) : this.initializeStatisticsBundle(campaignIds);
        List<TestInventoryStatistics> inventory = this.gatherMilestoneTestInventoryStatistics();
        ProgressionStatistics progression = new ProgressionStatistics();
        bundle.setTestInventoryStatistics(inventory);
        bundle.setProgressionStatistics(progression);
        return bundle;
    }

    @Override
    public StatisticsBundle gatherMultiStatisticsBundle(Map<Long, String> campaignNameMap, boolean lastExecutionScope) {
        List<Long> campaignIds = new ArrayList<Long>(campaignNameMap.keySet());
        campaignIds = this.filterCampaignIdsByActiveMilestone(campaignIds);
        StatisticsBundle bundle = lastExecutionScope ? this.initializeStatisticsBundleForLastExecutionScope(campaignIds) : this.initializeStatisticsBundle(campaignIds);
        List<TestInventoryStatistics> inventory = this.gatherMultiCampaignTestInventoryStatistics(campaignNameMap, campaignIds);
        ProgressionStatistics progression = new ProgressionStatistics();
        bundle.setTestInventoryStatistics(inventory);
        bundle.setProgressionStatistics(progression);
        bundle.setSelectedIds(campaignIds);
        return bundle;
    }

    private StatisticsBundle initializeStatisticsBundle(List<Long> campaignIds) {
        StatisticsBundle bundle = new StatisticsBundle();
        Map<ExecutionStatus, Integer> testcaseStatuses = this.gatherTestCaseStatusStatistics(campaignIds);
        Map<TestCaseImportance, Integer> testcaseImportance = this.gatherNonExecutedTestCaseImportanceStatistics(campaignIds);
        CampaignTestCaseSuccessRateStatistics testcaseSuccessRate = this.gatherTestCaseSuccessRateStatistics(campaignIds);
        bundle.setTestCaseStatusStatistics(testcaseStatuses);
        bundle.setNonExecutedTestCaseImportanceStatistics(testcaseImportance);
        bundle.setTestCaseSuccessRateStatistics(testcaseSuccessRate);
        return bundle;
    }

    private StatisticsBundle initializeStatisticsBundleForLastExecutionScope(List<Long> campaignIds) {
        StatisticsBundle bundle = new StatisticsBundle();
        List<Long> itpiIdsInScope = this.itpiLastExecutionFilterDao.gatherLatestItpiIdsForTCInScopeForCampaign(campaignIds);
        LinkedHashMap<ExecutionStatus, Integer> testcaseStatuses = this.gatherTestCaseStatusStatisticsForLastExecScope(itpiIdsInScope);
        Map<TestCaseImportance, Integer> testcaseImportance = this.gatherNonExecutedTestCaseImportanceStatisticsForLastExecScope(itpiIdsInScope);
        CampaignTestCaseSuccessRateStatistics testcaseSuccessRate = this.gatherTestCaseSuccessRateStatisticsForLastExecScope(itpiIdsInScope);
        bundle.setTestCaseStatusStatistics(testcaseStatuses);
        bundle.setNonExecutedTestCaseImportanceStatistics(testcaseImportance);
        bundle.setTestCaseSuccessRateStatistics(testcaseSuccessRate);
        return bundle;
    }

    private List<Long> filterCampaignIdsByActiveMilestone(List<Long> campaignIds) {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent() && !campaignIds.isEmpty()) {
            return this.campaignDao.filterByMilestone(campaignIds, activeMilestone.get().getId());
        }
        if (activeMilestone.isPresent()) {
            return this.campaignDao.findAllIdsByMilestone(activeMilestone.get().getId());
        }
        return campaignIds;
    }

    private Map<ExecutionStatus, Integer> gatherTestCaseStatusStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.campaignStatisticsDao.getTestCaseStatusStatistics(campaignIds);
        return CountOnEnum.fromTuples(tuples, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private LinkedHashMap<ExecutionStatus, Integer> gatherTestCaseStatusStatisticsForLastExecScope(List<Long> itpiIds) {
        List<Object[]> tuples = this.iterationStatisticsDao.getTestPlanItemsTestCaseStatusStatistics(itpiIds);
        return CountOnEnum.fromTuples(tuples, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
    }

    private CampaignTestCaseSuccessRateStatistics gatherTestCaseSuccessRateStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.campaignStatisticsDao.getCampaignTestCaseStatistics(campaignIds);
        return CampaignTestCaseSuccessRateStatistics.fromTuples(tuples);
    }

    private CampaignTestCaseSuccessRateStatistics gatherTestCaseSuccessRateStatisticsForLastExecScope(List<Long> itpiIds) {
        List<Object[]> tuples = this.iterationStatisticsDao.getTestPlanItemsTestCaseStatistics(itpiIds);
        return CampaignTestCaseSuccessRateStatistics.fromTuples(tuples);
    }

    private Map<TestCaseImportance, Integer> gatherNonExecutedTestCaseImportanceStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.campaignStatisticsDao.getNonExecutedTestCaseImportanceStatistics(campaignIds);
        return CountOnEnum.fromTuples(tuples, TestCaseImportance.class).getStatistics();
    }

    private Map<TestCaseImportance, Integer> gatherNonExecutedTestCaseImportanceStatisticsForLastExecScope(List<Long> itpiIds) {
        List<Object[]> tuples = this.iterationStatisticsDao.getTestPlanItemsNonExecutedTestCaseImportanceStatistics(itpiIds);
        return CountOnEnum.fromTuples(tuples, TestCaseImportance.class).getStatistics();
    }

    public List<TestInventoryStatistics> gatherManyCampaignTestInventoryStatistics(List<Long> campaignIds) {
        List<Object[]> tuples = this.campaignStatisticsDao.getMultiCampaignIterationTestInventoryStatistics(campaignIds);
        return this.processTestInventory(Collections.emptyMap(), tuples);
    }

    public List<TestInventoryStatistics> gatherSingleCampaignTestInventoryStatistics(long campaignId) {
        List<Object[]> tuples = this.campaignStatisticsDao.getCampaignTestCaseStatusStatistics(campaignId);
        return this.processTestInventory(Collections.emptyMap(), tuples);
    }

    public ProgressionStatistics gatherSingleCampaignProgressionStatistics(long campaignId) {
        ProgressionStatistics progression = new ProgressionStatistics();
        List<ScheduledIteration> scheduledIterations = this.campaignStatisticsDao.getScheduledIterations(campaignId);
        List<Date> executionHistory = this.campaignStatisticsDao.getExecutionHistory(campaignId);
        try {
            progression.setScheduledIterations(scheduledIterations);
            progression.getScheduledIterations().forEach(scheduledIteration -> scheduledIteration.setName(scheduledIteration.getName()));
            ScheduledIteration.checkIterationsDatesIntegrity(scheduledIterations);
            progression.computeSchedule();
            progression.computeCumulativeTestPerDate(executionHistory);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info("CampaignStatistics : could not generate campaign progression statistics for campaign {}: some iterations scheduled dates are wrong", new Object[]{campaignId});
            progression.addi18nErrorMessage(ex.getMessage());
        }
        return progression;
    }

    public List<TestInventoryStatistics> gatherMilestoneTestInventoryStatistics() {
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        List<Object[]> tuples = activeMilestone.isPresent() ? this.campaignStatisticsDao.getMilestoneTestInventoryStatistics(activeMilestone.get().getId()) : Collections.emptyList();
        return this.processTestInventory(Collections.emptyMap(), tuples);
    }

    public List<TestInventoryStatistics> gatherMultiCampaignTestInventoryStatistics(Map<Long, String> campaignNameMap, List<Long> campaignIds) {
        if (campaignIds.isEmpty()) {
            return this.processTestInventory(campaignNameMap, Collections.emptyList());
        }
        List<Object[]> tuples = this.campaignStatisticsDao.getMultiCampaignTestInventoryStatistics(campaignIds);
        return this.processTestInventory(campaignNameMap, tuples);
    }

    private List<TestInventoryStatistics> processTestInventory(Map<Long, String> campaignNameMap, List<Object[]> res) {
        TestInventoryStatistics newStatistics = new TestInventoryStatistics();
        Long currentId = null;
        LinkedList<TestInventoryStatistics> result = new LinkedList<TestInventoryStatistics>();
        for (Object[] tuple : res) {
            Long id = (Long)tuple[0];
            if (!id.equals(currentId)) {
                newStatistics = new TestInventoryStatistics();
                String name = campaignNameMap.get(id) != null ? campaignNameMap.get(id) : (String)tuple[1];
                newStatistics.setName(name);
                result.add(newStatistics);
                currentId = id;
            }
            ExecutionStatus status = (ExecutionStatus)tuple[2];
            Long howmany = (Long)tuple[3];
            if (status == null) continue;
            newStatistics.setNumber(howmany.intValue(), status);
        }
        result.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        return result;
    }
}

