/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Record;
import org.squashtest.tm.core.foundation.lang.NullFilterListCollector;
import org.squashtest.tm.domain.Identified;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static <I extends Record, K, V> List<K> performJoinAggregate(Function<I, K> leftTupleTransformer, Function<I, V> rightTupleTransformer, Function<Map.Entry<K, List<V>>, K> injector, Collection<I> records) {
        return records.stream().collect(Collectors.groupingBy(leftTupleTransformer, Collectors.mapping(rightTupleTransformer, NullFilterListCollector.toNullFilteredList()))).entrySet().stream().map(injector).collect(Collectors.toList());
    }

    public static <I extends Record, K, V> List<K> performJoinAggregate(Function<I, K> leftTupleTransformer, Function<I, V> rightTupleTransformer, BiConsumer<K, List<V>> injector, Collection<I> records) {
        Function<Map.Entry, Object> function = entry -> {
            Object key = entry.getKey();
            List value = (List)entry.getValue();
            injector.accept(key, value);
            return key;
        };
        return StreamUtils.transformTupleIntoMap(leftTupleTransformer, rightTupleTransformer, records).entrySet().stream().map(function).collect(Collectors.toList());
    }

    private static <I extends Record, K, V> Map<K, List<V>> transformTupleIntoMap(Function<I, K> leftTupleTransformer, Function<I, V> rightTupleTransformer, Collection<I> records) {
        return records.stream().collect(Collectors.groupingBy(leftTupleTransformer, Collectors.mapping(rightTupleTransformer, NullFilterListCollector.toNullFilteredList())));
    }

    public static <I extends Record, K extends Identified, V> Map<Long, K> performJoinAggregateIntoMap(Function<I, K> leftTupleTransformer, Function<I, V> rightTupleTransformer, BiConsumer<K, List<V>> injector, Collection<I> records) {
        Function<Map.Entry, Identified> function = entry -> {
            Identified key = (Identified)entry.getKey();
            List value = (List)entry.getValue();
            injector.accept(key, value);
            return key;
        };
        return records.stream().collect(Collectors.groupingBy(leftTupleTransformer, Collectors.mapping(rightTupleTransformer, NullFilterListCollector.toNullFilteredList()))).entrySet().stream().map(function).collect(Collectors.toMap(Identified::getId, Function.identity()));
    }
}

