/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.deletion.NodeScopeType;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.testcase.TestCaseBinGrid;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.TestCaseBinDao;

@Repository
public class TestCaseBinDaoImpl
implements TestCaseBinDao {
    private final DSLContext dsl;

    public TestCaseBinDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public GridResponse getDeletedNodesGrid(GridRequest request, NodeScope scope) {
        TestCaseBinGrid grid = new TestCaseBinGrid(scope);
        return grid.getRows(request, this.dsl);
    }

    @Override
    public List<Long> getProjectIdsFromScope(NodeScope scope) {
        SelectConditionStep query = null;
        if (scope.hasLibraries()) {
            query = this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.TCL_ID.in(scope.getLibraryIds()));
        }
        if (scope.hasNodes()) {
            SelectConditionStep nodeQuery = this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(scope.getNodeIds()));
            Object object = query = query == null ? nodeQuery : query.union((Select)nodeQuery);
        }
        if (query == null) {
            return List.of();
        }
        return query.fetchInto(Long.class);
    }

    @Override
    public Map<Long, Long> findFirstAncestorsWithDeletedDescendants(Collection<Long> nodeIds, boolean isRestore) {
        if (nodeIds.isEmpty()) {
            return Map.of();
        }
        TclnRelationshipClosure ancestorClosure = Tables.TCLN_RELATIONSHIP_CLOSURE.as("ancestor_closure");
        CommonTableExpression ancestorWithDeletedTables = DSL.name((String)"ancestor_with_deleted_node").fields("ANCESTOR_ID", "TCLN_ID", "DEPTH").as((ResultQuery)DSL.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds)).and(DSL.exists((Select)DSL.selectOne().from((TableLike)ancestorClosure).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(ancestorClosure.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(ancestorClosure.ANCESTOR_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).and(Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON.isNotNull().and(ancestorClosure.DEPTH.ne((Object)0)))))));
        Field depthField = ancestorWithDeletedTables.field("DEPTH", Short.class);
        SortField sortField = isRestore ? depthField.desc() : depthField.asc();
        CommonTableExpression rankedAncestor = DSL.name((String)"ranked_ancestor").fields("ANCESTOR_ID", "TCLN_ID", "DEPTH", "RANK").as((ResultQuery)DSL.select((SelectField)ancestorWithDeletedTables.field("ANCESTOR_ID"), (SelectField)ancestorWithDeletedTables.field("TCLN_ID"), (SelectField)ancestorWithDeletedTables.field("DEPTH"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{ancestorWithDeletedTables.field("TCLN_ID")}).orderBy(new OrderField[]{sortField})).as("RANK")).from((TableLike)ancestorWithDeletedTables));
        return this.dsl.with(new CommonTableExpression[]{ancestorWithDeletedTables, rankedAncestor}).select((SelectField)rankedAncestor.field("TCLN_ID", Long.class), (SelectField)rankedAncestor.field("ANCESTOR_ID", Long.class)).from((TableLike)rankedAncestor).where(rankedAncestor.field("RANK", Integer.class).eq((Object)1)).fetchMap(rankedAncestor.field("TCLN_ID", Long.class), rankedAncestor.field("ANCESTOR_ID", Long.class));
    }

    @Override
    public List<Long> findLibraryIdsByNodeIds(Collection<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.TCL_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).fetchInto(Long.class);
    }

    @Override
    public Set<NodeReference> getParentReferences(Collection<Long> nodeIds) {
        if (nodeIds.isEmpty()) {
            return new HashSet<NodeReference>();
        }
        return this.dsl.selectDistinct((SelectField)DSL.coalesce((Field)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID, (Field[])new Field[]{Tables.PROJECT.TCL_ID}), (SelectField)Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.isNotNull()).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TCLN_RELATIONSHIP.DESCENDANT_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(nodeIds)).fetch().stream().map(tuple -> new NodeReference((Boolean)tuple.value2() != false ? NodeType.TEST_CASE_FOLDER : NodeType.TEST_CASE_LIBRARY, (Long)tuple.value1())).collect(Collectors.toSet());
    }

    @Override
    public int countRestorableNodes(NodeScope scope) {
        return this.countImpactedNodes(scope, true);
    }

    @Override
    public int countDeletableNodes(NodeScope scope) {
        return this.countImpactedNodes(scope, false);
    }

    private int countImpactedNodes(NodeScope scope, boolean isRestore) {
        ArrayList<SelectConditionStep> subQueries = new ArrayList<SelectConditionStep>();
        if (scope.hasLibraries()) {
            subQueries.add(this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.TCL_ID.in(scope.getLibraryIds())).and(ConditionsConstants.TCLN_IN_BIN));
        }
        if (scope.hasNodes()) {
            Set<Long> nodeIds = scope.getNodeIds();
            subQueries.add(this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds)).and(ConditionsConstants.TCLN_IN_BIN));
            if (isRestore) {
                subQueries.add(this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds)).and(ConditionsConstants.TCLN_IN_BIN));
            }
        }
        Select query = (Select)subQueries.stream().reduce(Select::union).orElseThrow(() -> new IllegalArgumentException("No scope provided"));
        return this.dsl.fetchCount(query);
    }

    @Override
    public Set<Long> filterHighestParentNodeIds(Set<NodeReference> references) {
        Set<Long> nodeIds = references.stream().filter(ref -> NodeScopeType.NODE.isCompatibleWith(ref.getNodeType())).map(NodeReference::getId).collect(Collectors.toSet());
        if (nodeIds.isEmpty()) {
            return Set.of();
        }
        Set<Long> libraryIds = references.stream().filter(ref -> NodeScopeType.LIBRARY.isCompatibleWith(ref.getNodeType())).map(NodeReference::getId).collect(Collectors.toSet());
        return this.dsl.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(TestCaseBinDaoImpl.buildFilteredDescendantCondition(nodeIds, libraryIds)).fetchSet((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }

    private static Condition buildFilteredDescendantCondition(Set<Long> nodeIds, Set<Long> libraryIds) {
        TclnRelationshipClosure ancestorClosure = Tables.TCLN_RELATIONSHIP_CLOSURE.as("ancestor_closure");
        Condition condition = Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(nodeIds);
        if (!libraryIds.isEmpty()) {
            condition = condition.and(Tables.PROJECT.TCL_ID.notIn(libraryIds));
        }
        return condition.and(DSL.notExists((Select)DSL.selectOne().from((TableLike)ancestorClosure).where(ancestorClosure.DESCENDANT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).and(ancestorClosure.ANCESTOR_ID.in(nodeIds)).and(ancestorClosure.DEPTH.notEqual((Object)0)))));
    }

    @Override
    public List<Long> findLibraryIdsByProjectIds(Collection<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.PROJECT.TCL_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetchInto(Long.class);
    }
}

