/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.orchestrator;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.internal.repository.TestAutomationServerDao;
import org.squashtest.tm.service.internal.testautomation.TestAutomationConnectorRegistry;
import org.squashtest.tm.service.orchestrator.OrchestratorOperationService;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.testautomation.spi.TestAutomationConnector;

@Service
public class OrchestratorOperationServiceImpl
implements OrchestratorOperationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrchestratorOperationServiceImpl.class);
    private final TestAutomationServerDao testAutomationServerDao;
    private final TestAutomationConnectorRegistry testAutomationConnectorRegistry;
    private final StoredCredentialsManager storedCredentialsManager;

    public OrchestratorOperationServiceImpl(TestAutomationServerDao testAutomationServerDao, TestAutomationConnectorRegistry testAutomationConnectorRegistry, StoredCredentialsManager storedCredentialsManager) {
        this.testAutomationServerDao = testAutomationServerDao;
        this.testAutomationConnectorRegistry = testAutomationConnectorRegistry;
        this.storedCredentialsManager = storedCredentialsManager;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public OrchestratorResponse<OrchestratorConfVersions> getOrchestratorConfVersions(Long testAutomationServerId) {
        return this.performOrchestratorOperation(testAutomationServerId, TestAutomationConnector::getOrchestratorConfVersions);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public OrchestratorResponse<List<WorkflowDto>> getProjectWorkflows(Long serverId, Long projectId) {
        TokenAuthCredentials credentials = this.findProjectToken(serverId, projectId).orElse(null);
        return this.performOrchestratorOperation(serverId, (connector, server) -> connector.getProjectWorkflows((TestAutomationServer)server, projectId, (Credentials)credentials));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public OrchestratorResponse<Void> killWorkflow(Long serverId, Long projectId, String workflowId) {
        TokenAuthCredentials credentials = this.findProjectToken(serverId, projectId).orElse(null);
        return this.performOrchestratorOperation(serverId, (connector, server) -> connector.killWorkflow((TestAutomationServer)server, projectId, credentials, workflowId));
    }

    @Override
    public <T> OrchestratorResponse<T> performOrchestratorOperation(Long testAutomationServerId, BiFunction<TestAutomationConnector, TestAutomationServer, OrchestratorResponse<T>> operation) {
        Optional server = this.testAutomationServerDao.findById(testAutomationServerId);
        if (server.isEmpty()) {
            throw new IllegalArgumentException("Invalid server id");
        }
        TestAutomationConnector connector = this.testAutomationConnectorRegistry.getConnectorForKind(((TestAutomationServer)server.get()).getKind());
        try {
            return operation.apply(connector, (TestAutomationServer)server.get());
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred during the operation.", (Throwable)ex);
            return new OrchestratorResponse(false);
        }
    }

    private Optional<TokenAuthCredentials> findProjectToken(Long testAutomationServerId, Long projectId) {
        return Optional.ofNullable(this.storedCredentialsManager.findProjectCredentials(testAutomationServerId, projectId)).filter(TokenAuthCredentials.class::isInstance).map(TokenAuthCredentials.class::cast);
    }
}

