/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;

public final class FacilityImplHelper {
    static final int STD_TRUNCATE_SIZE = 255;
    private final AbstractEntityFacilitySupport facility;

    public FacilityImplHelper(AbstractEntityFacilitySupport facility) {
        this.facility = facility;
    }

    public void fillNullWithDefaults(TestCase testCase) {
        if (testCase.getName() == null) {
            testCase.setName("");
        }
        if (testCase.getReference() == null) {
            testCase.setReference("");
        }
        if (testCase.getDescription() == null) {
            testCase.setDescription("");
        }
        if (testCase.getPrerequisite() == null) {
            testCase.setPrerequisite("");
        }
        if (testCase.getImportance() == null) {
            testCase.setImportance(TestCaseImportance.defaultValue());
        }
        if (testCase.getStatus() == null) {
            testCase.setStatus(TestCaseStatus.defaultValue());
        }
        if (testCase.getAutomatable() == null) {
            testCase.setAutomatable(TestCaseAutomatable.defaultValue());
        }
        if (testCase.isImportanceAuto() == null) {
            testCase.setImportanceAuto(Boolean.FALSE);
        }
        if (testCase.getUuid() == null) {
            testCase.setUuid(UUID.randomUUID().toString());
        }
    }

    public void fillNullWithDefaults(RequirementVersion reqVersion) {
        if (reqVersion.getName() == null) {
            reqVersion.setName("");
        }
        if (reqVersion.getReference() == null) {
            reqVersion.setReference("");
        }
        if (reqVersion.getDescription() == null) {
            reqVersion.setDescription("");
        }
        if (reqVersion.getCriticality() == null) {
            reqVersion.setCriticality(RequirementCriticality.MINOR);
        }
        if (reqVersion.getStatus() == null) {
            reqVersion.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
    }

    public void fillNullWithDefaults(ActionTestStep step) {
        if (step.getAction() == null) {
            step.setAction("");
        }
        if (step.getExpectedResult() == null) {
            step.setExpectedResult("");
        }
    }

    public void fillNullWithDefaults(Parameter param) {
        if (param.getName() == null) {
            param.setName("");
        }
        if (param.getDescription() == null) {
            param.setDescription("");
        }
    }

    public void fillNullWithDefaults(Dataset ds) {
        if (ds.getName() == null) {
            ds.setName("");
        }
    }

    public void truncate(TestCase testCase, Map<String, String> cufValues) {
        String name = testCase.getName();
        testCase.setName(this.truncate(name, 255));
        String ref = testCase.getReference();
        testCase.setReference(this.truncate(ref, 50));
        this.truncateCustomFields(cufValues);
    }

    public void truncate(RequirementVersion reqVersion, Map<String, String> cufValues, boolean shouldCheckStatus) {
        String ref = reqVersion.getReference();
        String truncatedRef = this.truncate(ref, 50);
        if (shouldCheckStatus) {
            reqVersion.setReference(truncatedRef);
        } else {
            reqVersion.updateReferenceWithoutCheckingStatus(truncatedRef);
        }
        this.truncateCustomFields(cufValues);
    }

    public void truncate(Map<String, String> cufValues) {
        this.truncateCustomFields(cufValues);
    }

    public void truncate(Parameter param) {
        String name = param.getName();
        param.setName(this.truncate(name, 255));
    }

    public void truncate(Dataset ds) {
        String name = ds.getName();
        ds.setName(this.truncate(name, 255));
    }

    public String truncate(String str, int cap) {
        if (str != null) {
            return str.substring(0, Math.min(str.length(), cap));
        }
        return null;
    }

    public String truncate(String str) {
        return this.truncate(str, 255);
    }

    void truncateCustomFields(Map<String, String> cufValues) {
        for (Map.Entry<String, String> cuf : cufValues.entrySet()) {
            InputType type = this.facility.getInputTypeFor(cuf.getKey());
            String value = cuf.getValue();
            if (type == null || value == null) continue;
            switch (type) {
                case TAG: {
                    String[] values = value.split("\\|");
                    CharSequence[] truncatedValues = (String[])Arrays.stream(values).map(v -> this.truncate((String)v, 255)).toArray(String[]::new);
                    String result = String.join((CharSequence)"|", truncatedValues);
                    cuf.setValue(result);
                    break;
                }
                case RICH_TEXT: {
                    break;
                }
                default: {
                    cuf.setValue(this.truncate(value, 255));
                }
            }
        }
    }
}

