/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.InsertValuesStepN;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;
import org.squashtest.tm.service.internal.dto.projectimporterxray.XrayField;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CalledTestXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.tables.CustomFieldTable;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.tables.ItemTable;
import org.squashtest.tm.service.pivot.projectimporter.xrayimporter.XrayTablesDao;

@Component
@RequestScope
public class XrayTablesDaoImpl
implements XrayTablesDao {
    private static final int FETCH_SIZE = 10;
    private final DSLContext dsl;
    private ItemTable itemTable;
    private CustomFieldTable customFieldTable;

    public XrayTablesDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public void createTables(ItemTable itemTable, CustomFieldTable customFieldTable) {
        this.customFieldTable = customFieldTable;
        this.itemTable = itemTable;
        this.createTmpTable((Table<?>)customFieldTable, (Field<?>)customFieldTable.ID);
        this.createTmpTable((Table<?>)itemTable, (Field<?>)itemTable.ID);
    }

    private void createTmpTable(Table<?> table, Field<?> primaryKey) {
        this.dsl.createTemporaryTableIfNotExists(table).columns(table.fields()).constraints(new Constraint[]{DSL.primaryKey((Field[])new Field[]{primaryKey})}).execute();
    }

    @Override
    public void createItems(List<ItemXrayDto> itemXrayDtos) {
        InsertValuesStepN insert = this.dsl.insertInto((Table)this.itemTable).columns(this.itemTable.getFields());
        InsertValuesStepN insertCuf = this.dsl.insertInto((Table)this.customFieldTable).columns(this.customFieldTable.getFields());
        for (ItemXrayDto itemXrayDto : itemXrayDtos) {
            insert = insert.values(this.itemTable.getValues(itemXrayDto));
            for (CustomFieldXrayDto customFieldXrayDto : itemXrayDto.getCustomFields()) {
                insertCuf = insertCuf.values(this.customFieldTable.getValues(customFieldXrayDto));
            }
        }
        insertCuf.execute();
        insert.execute();
    }

    @Override
    public void dropTablesIfExist() {
        this.dsl.dropTableIfExists((Table)this.customFieldTable).execute();
        this.dsl.dropTableIfExists((Table)this.itemTable).execute();
    }

    @Override
    public void executeBatchQueries(List<Query> queries) {
        if (!queries.isEmpty()) {
            this.dsl.batch(queries).execute();
        }
    }

    @Override
    public void addQueryUpdateItemName(Long itemId, String newName, List<Query> queries) {
        UpdateConditionStep updateQuery = this.dsl.update((Table)this.itemTable).set(this.itemTable.SUMMARY, (Object)newName).where(this.itemTable.ID.eq((Object)itemId));
        queries.add((Query)updateQuery);
    }

    @Override
    public void updateCustomFieldPivotId(Long customFieldId, String pivotIdValue) {
        this.dsl.update((Table)this.customFieldTable).set(this.customFieldTable.PIVOT_ID, (Object)pivotIdValue).where(this.customFieldTable.ID.eq((Object)customFieldId)).execute();
    }

    @Override
    public boolean isEmptyTestCaseFolder(XrayField.Type type) {
        return this.isEmptyRequest(this.selectTypeRepositoryFolder(type));
    }

    @Override
    public boolean isEmptyItemTable(XrayField.Type ... typeValue) {
        return this.isEmptyRequest(this.selectItemTable(typeValue));
    }

    @Override
    public boolean isEmptyCalledTestCase() {
        SelectLimitPercentStep selectCalledTestCases = this.dsl.select(this.itemTable.ID).from((TableLike)this.itemTable).join((TableLike)this.customFieldTable).on(this.customFieldTable.ITEM_ID.eq(this.itemTable.ID)).where(this.customFieldTable.STEP_CALLED_TEST_KEY.isNotNull()).limit((Number)1);
        return this.isEmptyRequest(selectCalledTestCases.fetchStream());
    }

    private <T extends Record> boolean isEmptyRequest(Stream<T> stream) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                return stream.limit(1L).toList().isEmpty();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Stream<Record1<Long>> selectItemTable(XrayField.Type ... typeValue) {
        List<String> typeValueName = this.getTypeNames(typeValue);
        return this.dsl.select(this.itemTable.ID).from((TableLike)this.itemTable).where(this.itemTable.TYPE.in(typeValueName)).fetchSize(10).fetchStream();
    }

    @Override
    public void selectTest(Consumer<ItemXrayDto> forEachItemDto, XrayField.Type ... typeValue) {
        List<String> typeValueName = this.getTypeNames(typeValue);
        CustomFieldTable cufPreconditionTable = this.customFieldTable.as("cufPreconditionTable");
        CustomFieldTable cufCalledParameterTable = this.customFieldTable.as("cufCalledParameterTable");
        Condition isCalledTest = cufCalledParameterTable.STEP_CALLED_TEST_KEY.isNotNull();
        ResultQuery queryResult = this.dsl.select((SelectFieldOrAsterisk[])this.itemTable.fields()).select((SelectFieldOrAsterisk[])this.customFieldTable.fields()).select(new SelectFieldOrAsterisk[]{cufPreconditionTable.VALUE}).select(new SelectFieldOrAsterisk[]{isCalledTest}).from((TableLike)this.itemTable).leftJoin((TableLike)this.customFieldTable).on(this.itemTable.ID.eq(this.customFieldTable.ITEM_ID)).leftJoin(this.addPrecondition(cufPreconditionTable)).on(cufPreconditionTable.ID.eq(this.customFieldTable.ID)).leftJoin(this.addCalledParameter(cufCalledParameterTable)).on(cufCalledParameterTable.STEP_CALLED_TEST_KEY.eq(this.itemTable.KEY)).where(this.itemTable.TYPE.in(typeValueName)).orderBy(this.itemTable.ID).fetchSize(10);
        this.commonConsumeItemIterator((ResultQuery<Record>)queryResult, forEachItemDto, (arg_0, arg_1) -> this.lambda$0(cufPreconditionTable, (Field)isCalledTest, arg_0, arg_1));
    }

    private Table<Record2<Long, String>> addPrecondition(CustomFieldTable cufPrecondition) {
        CustomFieldTable cufAssociatedPrecoTable = this.customFieldTable.as("cufAssociatedPrecoTable");
        ItemTable itemAssociatedCufPrecoTable = this.itemTable.as("itemAssociatedCufPrecoTable");
        CustomFieldTable cufAssociatedItemAssociatedPrecoTable = this.customFieldTable.as("cufAssociatedItemAssociatedPrecoTable");
        return this.dsl.select((SelectField)cufAssociatedPrecoTable.ID.as(cufPrecondition.ID), (SelectField)cufAssociatedItemAssociatedPrecoTable.VALUE.as(cufPrecondition.VALUE)).from((TableLike)cufAssociatedPrecoTable).join((TableLike)itemAssociatedCufPrecoTable).on(itemAssociatedCufPrecoTable.KEY.eq(cufAssociatedPrecoTable.VALUE)).join((TableLike)cufAssociatedItemAssociatedPrecoTable).on(cufAssociatedItemAssociatedPrecoTable.ITEM_ID.eq(itemAssociatedCufPrecoTable.ID)).where(cufAssociatedPrecoTable.KEY.contains((Object)XrayField.CustomFieldKey.TEST_ASSOCIATED_PRECONDITION.getKey())).and(cufAssociatedItemAssociatedPrecoTable.KEY.contains((Object)XrayField.CustomFieldKey.PRECONDITION_VALUE.getKey())).asTable((Table)cufPrecondition);
    }

    public Table<Record1<String>> addCalledParameter(CustomFieldTable cufCalledParameter) {
        return this.dsl.select(cufCalledParameter.STEP_CALLED_TEST_KEY).from((TableLike)cufCalledParameter).where(cufCalledParameter.STEP_CALLED_TEST_PARAMETERS.isNotNull()).groupBy(new GroupField[]{cufCalledParameter.STEP_CALLED_TEST_KEY}).asTable((Table)cufCalledParameter);
    }

    @Override
    public Stream<Record1<String>> selectTypeRepositoryFolder(XrayField.Type typeValue) {
        return this.dsl.select(this.customFieldTable.VALUE).from((TableLike)this.itemTable).join((TableLike)this.customFieldTable).on(this.customFieldTable.ITEM_ID.eq(this.itemTable.ID)).where(this.itemTable.TYPE.eq((Object)typeValue.getName())).and(this.customFieldTable.KEY.contains((Object)XrayField.CustomFieldKey.TEST_REPOSITORY_PATH.getKey())).and(this.customFieldTable.VALUE.isNotNull()).fetchSize(10).fetchStream();
    }

    @Override
    public void selectCalledTestCasesToAssignDataset(String testCaseXrayKey, ObjLongConsumer<String> consumStepCalledTestParameters) {
        ResultQuery resultQuery = this.dsl.select(this.customFieldTable.STEP_CALLED_TEST_PARAMETERS, this.customFieldTable.ID).from((TableLike)this.customFieldTable).where(this.customFieldTable.STEP_CALLED_TEST_KEY.eq((Object)testCaseXrayKey)).and(this.customFieldTable.STEP_CALLED_TEST_PARAMETERS.isNotNull()).fetchSize(10);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = resultQuery.fetchStream();){
            stream.forEach(parametersRecord -> consumStepCalledTestParameters.accept((String)parametersRecord.value1(), (Long)parametersRecord.value2()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void selectCalledTestCases(Consumer<List<CalledTestXrayDto>> calledTestXrayDtosConsumer) {
        ItemTable it = this.itemTable.as("it1");
        ResultQuery result = this.dsl.select(this.itemTable.PIVOT_ID, this.itemTable.KEY, this.itemTable.TITLE, this.customFieldTable.STEP_INDEX, this.customFieldTable.STEP_CALLED_TEST_KEY, this.customFieldTable.STEP_CALLED_TEST_PARAMETERS, this.customFieldTable.PIVOT_ID, (SelectField)it.PIVOT_ID.as("called_id")).from((TableLike)this.itemTable).join((TableLike)this.customFieldTable).on(this.customFieldTable.ITEM_ID.eq(this.itemTable.ID)).leftJoin((TableLike)it).on(it.KEY.eq(this.customFieldTable.STEP_CALLED_TEST_KEY)).where(this.customFieldTable.STEP_CALLED_TEST_KEY.isNotNull()).orderBy(this.itemTable.PIVOT_ID, this.customFieldTable.STEP_INDEX).fetchSize(10);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream stream = result.fetchStreamInto(CalledTestXrayDto.class);){
            this.consumeCalledTestCaseGroupByPivotId(stream.iterator(), calledTestXrayDtosConsumer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void consumeCalledTestCaseGroupByPivotId(Iterator<CalledTestXrayDto> iterable, Consumer<List<CalledTestXrayDto>> calledTestXrayDtosConsumer) {
        ArrayList<CalledTestXrayDto> currentGroup = new ArrayList<CalledTestXrayDto>();
        String currentPivotId = null;
        while (iterable.hasNext()) {
            CalledTestXrayDto calledTestXrayDto = iterable.next();
            if (currentPivotId == null || !currentPivotId.equals(calledTestXrayDto.getPivotId())) {
                if (!currentGroup.isEmpty()) {
                    calledTestXrayDtosConsumer.accept(currentGroup);
                    currentGroup.clear();
                }
                currentPivotId = calledTestXrayDto.getPivotId();
            }
            currentGroup.add(calledTestXrayDto);
        }
        if (!currentGroup.isEmpty()) {
            calledTestXrayDtosConsumer.accept(currentGroup);
            currentGroup.clear();
        }
    }

    @Override
    public void selectTestPlan(Consumer<ItemXrayDto> forEachItemDto, XrayField.Type ... typeValue) {
        List<String> typeValueName = this.getTypeNames(typeValue);
        CustomFieldTable testAssociatedTestPlanTable = this.customFieldTable.as("testAssociatedTestPlanTable");
        ResultQuery queryResult = this.dsl.select((SelectFieldOrAsterisk[])this.itemTable.fields()).select((SelectFieldOrAsterisk[])this.customFieldTable.fields()).select(new SelectFieldOrAsterisk[]{testAssociatedTestPlanTable.PIVOT_ID}).from((TableLike)this.itemTable).leftJoin((TableLike)this.customFieldTable).on(this.itemTable.ID.eq(this.customFieldTable.ITEM_ID)).leftJoin(this.addTestPlanOrExecutionAssociatedTest(testAssociatedTestPlanTable, XrayField.CustomFieldKey.TEST_PLAN_ASSOCIATED_TESTS)).on(testAssociatedTestPlanTable.ID.eq(this.customFieldTable.ID)).where(this.itemTable.TYPE.in(typeValueName)).orderBy(this.itemTable.ID).fetchSize(10);
        this.commonConsumeItemIterator((ResultQuery<Record>)queryResult, forEachItemDto, (testRecord, itemXrayDto) -> this.addElementToItemDtoDataMap(itemXrayDto.getAssociatedIssuesWithXrayKey(), (String)testRecord.get(this.customFieldTable.VALUE), (String)testRecord.get(customFieldTable.PIVOT_ID)));
    }

    private Table<Record2<Long, String>> addTestPlanOrExecutionAssociatedTest(CustomFieldTable tableAssociatedTest, XrayField.CustomFieldKey associatedTestKey) {
        CustomFieldTable cufTestPlanAssociatedTestTable = this.customFieldTable.as("cufTestPlanAssociatedTestTable");
        ItemTable itemTestAssociatedTestPlanTable = this.itemTable.as("itemTestAssociatedTestPlanTable");
        return this.dsl.select((SelectField)cufTestPlanAssociatedTestTable.ID.as(tableAssociatedTest.ID), (SelectField)itemTestAssociatedTestPlanTable.PIVOT_ID.as(tableAssociatedTest.PIVOT_ID)).from((TableLike)cufTestPlanAssociatedTestTable).join((TableLike)itemTestAssociatedTestPlanTable).on(itemTestAssociatedTestPlanTable.KEY.eq(cufTestPlanAssociatedTestTable.VALUE)).where(cufTestPlanAssociatedTestTable.KEY.contains((Object)associatedTestKey.getKey())).asTable((Table)tableAssociatedTest);
    }

    @Override
    public void selectOrphanTestExecution(Consumer<ItemXrayDto> forEachItemDto, XrayField.Type ... typeValue) {
        List<String> typeValueName = this.getTypeNames(typeValue);
        CustomFieldTable testAssociatedOrphanExecutionTable = this.customFieldTable.as("testAssociatedOrphanExecutionTable");
        ResultQuery queryResult = this.dsl.select((SelectFieldOrAsterisk[])this.itemTable.fields()).select((SelectFieldOrAsterisk[])this.customFieldTable.fields()).select(new SelectFieldOrAsterisk[]{testAssociatedOrphanExecutionTable.PIVOT_ID}).from((TableLike)this.itemTable).leftJoin((TableLike)this.customFieldTable).on(this.itemTable.ID.eq(this.customFieldTable.ITEM_ID)).leftJoin(this.addTestPlanOrExecutionAssociatedTest(testAssociatedOrphanExecutionTable, XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TESTS)).on(testAssociatedOrphanExecutionTable.ID.eq(this.customFieldTable.ID)).where(this.itemTable.TYPE.in(typeValueName)).andNotExists(this.selectOneForExecutionWithTestPlan()).orderBy(this.itemTable.ID).fetchSize(10);
        this.commonConsumeItemIterator((ResultQuery<Record>)queryResult, forEachItemDto, (testRecord, itemXrayDto) -> this.addElementToItemDtoDataMap(itemXrayDto.getAssociatedIssuesWithXrayKey(), (String)testRecord.get(this.customFieldTable.VALUE), (String)testRecord.get(customFieldTable.PIVOT_ID)));
    }

    private SelectConditionStep<Record1<Integer>> selectOneForExecutionWithTestPlan() {
        CustomFieldTable cufAssociatedTestPlanTable = this.customFieldTable.as("cufAssociatedTestPlanTable");
        return DSL.selectOne().from((TableLike)cufAssociatedTestPlanTable).where(cufAssociatedTestPlanTable.ITEM_ID.eq(this.itemTable.ID)).and(cufAssociatedTestPlanTable.KEY.contains((Object)XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TEST_PLAN.getKey()));
    }

    @Override
    public void selectTestExecutionForIteration(Consumer<ItemXrayDto> forEachItemDto, XrayField.Type ... typeValue) {
        List<String> typeValueName = this.getTypeNames(typeValue);
        CustomFieldTable testAssociatedExecutionTable = this.customFieldTable.as("testAssociatedExecutionTable");
        CustomFieldTable testPlanAssociatedExecutionTable = this.customFieldTable.as("testPlanAssociatedExecutionTable");
        ResultQuery queryResult = this.dsl.select((SelectFieldOrAsterisk[])this.itemTable.fields()).select((SelectFieldOrAsterisk[])this.customFieldTable.fields()).select(new SelectFieldOrAsterisk[]{testAssociatedExecutionTable.PIVOT_ID}).select(new SelectFieldOrAsterisk[]{testPlanAssociatedExecutionTable.PIVOT_ID}).from((TableLike)this.itemTable).leftJoin((TableLike)this.customFieldTable).on(this.itemTable.ID.eq(this.customFieldTable.ITEM_ID)).leftJoin(this.addTestPlanOrExecutionAssociatedTest(testAssociatedExecutionTable, XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TESTS)).on(testAssociatedExecutionTable.ID.eq(this.customFieldTable.ID)).leftJoin(this.addExecutionAssociatedTestPlan(testPlanAssociatedExecutionTable)).on(testPlanAssociatedExecutionTable.ID.eq(this.customFieldTable.ID)).where(this.itemTable.TYPE.in(typeValueName)).orderBy(this.itemTable.ID).fetchSize(10);
        this.commonConsumeItemIterator((ResultQuery<Record>)queryResult, forEachItemDto, (testRecord, itemXrayDto) -> {
            this.addElementToItemDtoDataMap(itemXrayDto.getAssociatedIssuesWithXrayKey(), (String)testRecord.get(this.customFieldTable.VALUE), (String)testRecord.get(customFieldTable.PIVOT_ID));
            this.addElementToItemDtoDataList(itemXrayDto.getTestPlanPivotIds(), (String)testRecord.get(customFieldTable2.PIVOT_ID));
        });
    }

    private Table<Record2<Long, String>> addExecutionAssociatedTestPlan(CustomFieldTable tableAssociatedTestPlan) {
        CustomFieldTable cufExecutionAssociatedTestPlanTable = this.customFieldTable.as("cufExecutionAssociatedTestPlanTable");
        ItemTable itemTestPlanAssociatedExecutionTable = this.itemTable.as("itemTestPlanAssociatedExecutionTable");
        return this.dsl.select((SelectField)cufExecutionAssociatedTestPlanTable.ID.as(tableAssociatedTestPlan.ID), (SelectField)itemTestPlanAssociatedExecutionTable.PIVOT_ID.as(tableAssociatedTestPlan.PIVOT_ID)).from((TableLike)cufExecutionAssociatedTestPlanTable).join((TableLike)itemTestPlanAssociatedExecutionTable).on(itemTestPlanAssociatedExecutionTable.KEY.eq(cufExecutionAssociatedTestPlanTable.VALUE)).where(cufExecutionAssociatedTestPlanTable.KEY.contains((Object)XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TEST_PLAN.getKey())).and(cufExecutionAssociatedTestPlanTable.VALUE.isNotNull()).asTable((Table)tableAssociatedTestPlan);
    }

    private void commonConsumeItemIterator(ResultQuery<Record> queryResult, Consumer<ItemXrayDto> forEachItemDto, BiConsumer<Record, ItemXrayDto> additionalFields) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream resultRecord = queryResult.fetchStream();){
            Iterator<Record> testIterator = resultRecord.iterator();
            this.consumeItemIterator(testIterator, forEachItemDto, additionalFields);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void consumeItemIterator(Iterator<Record> iterator, Consumer<ItemXrayDto> consumItemDto, BiConsumer<Record, ItemXrayDto> additionalFields) {
        Long currentIdItem = null;
        ItemXrayDto itemDto = null;
        while (iterator.hasNext()) {
            Record itemRecord = iterator.next();
            Long idItem = (Long)itemRecord.get(this.itemTable.ID);
            if (Objects.isNull(currentIdItem)) {
                itemDto = this.createItemDto(itemRecord);
                additionalFields.accept(itemRecord, itemDto);
                currentIdItem = idItem;
            } else if (currentIdItem.equals(idItem)) {
                this.addCustomFieldDto(itemDto, itemRecord.into(this.customFieldTable.fields()));
                additionalFields.accept(itemRecord, itemDto);
            } else {
                consumItemDto.accept(itemDto);
                itemDto = this.createItemDto(itemRecord);
                additionalFields.accept(itemRecord, itemDto);
                currentIdItem = idItem;
            }
            if (iterator.hasNext()) continue;
            consumItemDto.accept(itemDto);
        }
    }

    private ItemXrayDto createItemDto(Record itemRecord) {
        ItemXrayDto itemDto = (ItemXrayDto)itemRecord.into(this.itemTable.fields()).into(ItemXrayDto.class);
        this.addCustomFieldDto(itemDto, itemRecord.into(this.customFieldTable.fields()));
        return itemDto;
    }

    private void addCustomFieldDto(ItemXrayDto itemDto, Record customFieldRecord) {
        if (Objects.nonNull(customFieldRecord.get(this.customFieldTable.ID))) {
            CustomFieldXrayDto customFieldDto = (CustomFieldXrayDto)customFieldRecord.into(CustomFieldXrayDto.class);
            itemDto.getCustomFields().add(customFieldDto);
        }
    }

    private <T> void addElementToItemDtoDataList(List<T> itemDtoDataList, T element) {
        if (Objects.nonNull(element)) {
            itemDtoDataList.add(element);
        }
    }

    private <T> void addElementToItemDtoDataMap(Map<T, T> itemDtoDataList, T key, T element) {
        if (Objects.nonNull(element)) {
            itemDtoDataList.put(key, element);
        }
    }

    private void addIsCalledParameter(ItemXrayDto itemDto, Boolean isCalledParameter) {
        if (Objects.nonNull(isCalledParameter)) {
            itemDto.setCalledParameter(isCalledParameter);
        }
    }

    @Override
    public Stream<Record3<Long, String, String>> selectDuplicateNameGroupBy(XrayField.CustomFieldKey customFieldKey, XrayField.Type ... itemTypes) {
        List<String> typeValueName = Arrays.stream(itemTypes).map(XrayField.Type::getName).toList();
        Table duplicateTable = this.dsl.select(this.itemTable.SUMMARY, this.customFieldTable.VALUE).from((TableLike)this.itemTable).leftJoin((TableLike)this.dsl.select(this.customFieldTable.ITEM_ID, this.customFieldTable.VALUE).from((TableLike)this.customFieldTable).where(this.customFieldTable.KEY.containsIgnoreCase((Object)customFieldKey.getKey())).asTable((Table)this.customFieldTable)).on(this.itemTable.ID.eq(this.customFieldTable.ITEM_ID)).where(this.itemTable.TYPE.in(typeValueName)).groupBy(new GroupField[]{this.itemTable.SUMMARY, this.customFieldTable.VALUE}).having(DSL.count().gt((Object)1)).asTable("duplicateTable");
        return this.dsl.select(this.itemTable.ID, this.itemTable.SUMMARY, this.customFieldTable.VALUE).from((TableLike)this.itemTable).leftJoin((TableLike)this.dsl.select(this.customFieldTable.ITEM_ID, this.customFieldTable.VALUE).from((TableLike)this.customFieldTable).where(this.customFieldTable.KEY.containsIgnoreCase((Object)customFieldKey.getKey())).asTable((Table)this.customFieldTable)).on(this.itemTable.ID.eq(this.customFieldTable.ITEM_ID)).join((TableLike)duplicateTable).on(new Condition[]{this.itemTable.SUMMARY.eq(duplicateTable.field(this.itemTable.SUMMARY)), this.customFieldTable.VALUE.eq(duplicateTable.field(this.customFieldTable.VALUE)).or(this.customFieldTable.VALUE.isNull().and(duplicateTable.field(this.customFieldTable.VALUE).isNull()))}).orderBy(this.itemTable.SUMMARY).fetchSize(10).fetchStream();
    }

    @Override
    public Stream<Record2<Long, String>> selectDuplicateName(XrayField.Type ... typeValue) {
        return this.handleCommonDuplicateName(query -> query, typeValue);
    }

    @Override
    public Stream<Record2<Long, String>> selectDuplicateNameOrphanTestExecution(XrayField.Type ... typeValue) {
        return this.handleCommonDuplicateName(query -> query.andNotExists((Select)DSL.selectOne().from((TableLike)this.customFieldTable).where(this.customFieldTable.ITEM_ID.eq(this.itemTable.ID)).and(this.customFieldTable.KEY.containsIgnoreCase((Object)XrayField.CustomFieldKey.EXECUTION_ASSOCIATED_TEST_PLAN.getKey()))), typeValue);
    }

    private Stream<Record2<Long, String>> handleCommonDuplicateName(UnaryOperator<SelectOnConditionStep<Record2<Long, String>>> addAdditionalCondition, XrayField.Type ... typeValue) {
        ItemTable itemGroup = this.itemTable.as("itemGroup");
        List<String> typeValueName = this.getTypeNames(typeValue);
        Table itemGroupTable = this.dsl.select(itemGroup.SUMMARY).from((TableLike)itemGroup).where(itemGroup.TYPE.in(typeValueName)).groupBy(new GroupField[]{itemGroup.SUMMARY}).having(DSL.count().gt((Object)1)).asTable((Table)itemGroup);
        SelectOnConditionStep selectWithJoin = this.dsl.select(this.itemTable.ID, this.itemTable.SUMMARY).from((TableLike)this.itemTable).join((TableLike)itemGroupTable).on(this.itemTable.SUMMARY.eq(itemGroup.SUMMARY));
        SelectOnConditionStep selectWithConditions = (SelectOnConditionStep)addAdditionalCondition.apply(selectWithJoin);
        return selectWithConditions.orderBy(this.itemTable.SUMMARY).fetchSize(10).fetchStream();
    }

    private List<String> getTypeNames(XrayField.Type[] types) {
        return Arrays.stream(types).map(XrayField.Type::getName).toList();
    }

    @Override
    public ItemTable getItemTable() {
        return this.itemTable;
    }

    @Override
    public CustomFieldTable getCustomFieldTable() {
        return this.customFieldTable;
    }

    private /* synthetic */ void lambda$0(CustomFieldTable customFieldTable, Field field, Record testRecord, ItemXrayDto itemXrayDto) {
        this.addElementToItemDtoDataMap(itemXrayDto.getAssociatedIssuesWithXrayKey(), (String)testRecord.get(this.customFieldTable.VALUE), (String)testRecord.get(customFieldTable.VALUE));
        this.addIsCalledParameter(itemXrayDto, (Boolean)testRecord.get(field));
    }
}

