/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.LevelComparator;

public class CountOnEnum<E extends Enum<E>> {
    private final LinkedHashMap<E, Integer> statistics;

    public CountOnEnum(Class<E> enumClass) {
        this(EnumSet.allOf(Objects.requireNonNull(enumClass)));
    }

    public CountOnEnum(Set<E> subSet) {
        Objects.requireNonNull(subSet);
        this.statistics = subSet.stream().sorted(LevelComparator.getInstance()).collect(Collectors.toMap(Function.identity(), e -> 0, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public LinkedHashMap<E, Integer> getStatistics() {
        return this.statistics;
    }

    public LinkedHashMap<E, Integer> getStatistics(Set<E> subset) {
        return this.getStatistics(Function.identity(), subset);
    }

    public <T extends Enum<T>> LinkedHashMap<T, Integer> getStatistics(Function<E, T> keyMapper, Class<T> outputClass) {
        return this.getStatistics(keyMapper, EnumSet.allOf(outputClass));
    }

    public <T extends Enum<T>> LinkedHashMap<T, Integer> getStatistics(Function<E, T> keyMapper, Set<T> subset) {
        CountOnEnum<T> output = this.convert(keyMapper, subset);
        return output.statistics;
    }

    public CountOnEnum<E> keep(Set<E> subset) {
        return this.convert(Function.identity(), subset);
    }

    public <T extends Enum<T>> CountOnEnum<T> convert(Function<E, T> keyMapper, Class<T> enumClass) {
        return this.convert(keyMapper, EnumSet.allOf(enumClass));
    }

    public <T extends Enum<T>> CountOnEnum<T> convert(Function<E, T> keyMapper, Set<T> subset) {
        CountOnEnum output = new CountOnEnum(subset);
        this.statistics.forEach((key, value) -> {
            Enum mappedKey = (Enum)keyMapper.apply(key);
            output.add(mappedKey, this.statistics.get(key));
        });
        return output;
    }

    public int calculateTotal() {
        return this.statistics.values().stream().mapToInt(Integer::intValue).sum();
    }

    public void add(E key, Long value) {
        this.add(key, value.intValue());
    }

    public void add(E key, Integer value) {
        if (this.statistics.containsKey(Objects.requireNonNull(key))) {
            Integer newValue = Objects.requireNonNull(value) + this.statistics.get(Objects.requireNonNull(key));
            this.statistics.put(key, newValue);
        }
    }

    public static <E extends Enum<E>> CountOnEnum<E> fromTuples(List<Object[]> tuples, Class<E> enumClass) {
        return CountOnEnum.fromTuples(tuples, enumClass, EnumSet.allOf(enumClass));
    }

    public static <E extends Enum<E>> CountOnEnum<E> fromTuples(List<Object[]> tuples, Class<E> enumClass, Set<E> subset) {
        CountOnEnum<E> countOnEnum = new CountOnEnum<E>(subset);
        for (Object[] tuple : tuples) {
            CountOnEnum.validateTuple(tuple);
            E key = CountOnEnum.extractKey(enumClass, tuple[0]);
            Integer value = CountOnEnum.extractValue(tuple[1]);
            countOnEnum.add(key, value);
        }
        return countOnEnum;
    }

    private static void validateTuple(Object[] tuple) {
        if (Objects.isNull(tuple) || tuple.length < 2) {
            throw new IllegalArgumentException("Illegal Tuple. Null or tuples with less than two columns are rejected");
        }
    }

    private static Integer extractValue(Object obj) {
        Integer value;
        Object valueCandidate = Objects.requireNonNull(obj);
        if (Integer.class.isAssignableFrom(valueCandidate.getClass())) {
            value = (Integer)valueCandidate;
        } else if (Long.class.isAssignableFrom(valueCandidate.getClass())) {
            value = ((Long)valueCandidate).intValue();
        } else {
            throw new IllegalArgumentException(String.format("Illegal value %s of %s", valueCandidate, valueCandidate.getClass()));
        }
        return value;
    }

    private static <E extends Enum<E>> E extractKey(Class<E> enumClass, Object obj) {
        Enum key;
        Object keyCandidate = Objects.requireNonNull(obj);
        if (enumClass.isAssignableFrom(keyCandidate.getClass())) {
            key = (Enum)keyCandidate;
        } else if (String.class.isAssignableFrom(keyCandidate.getClass())) {
            key = Enum.valueOf(enumClass, (String)keyCandidate);
        } else {
            throw new IllegalArgumentException(String.format("Illegal key %s for enum %s", keyCandidate, enumClass));
        }
        return (E)key;
    }
}

