/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.jooq;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.JooqIterationDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class JooqIterationDaoImpl
implements JooqIterationDao {
    private final DSLContext dslContext;

    public JooqIterationDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public List<Long> getVerifiedTcIdsInIterations(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.ITERATION.ITERATION_ID.in(iterationIds).and(Tables.TEST_PLAN_ITEM.TCLN_ID.in(testCasesIds))).fetch((Field)Tables.TEST_PLAN_ITEM.TCLN_ID);
    }

    @Override
    public List<Long> getVerifiedAndExecutedTcIdsInIterations(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.dslContext.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.ITERATION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).where(Tables.ITERATION.ITERATION_ID.in(iterationIds).and(Tables.TEST_PLAN_ITEM.TCLN_ID.in(testCasesIds))).fetch((Field)Tables.TEST_PLAN_ITEM.TCLN_ID);
    }

    @Override
    public List<TestCaseExecutionStatus> getExecStatusForIterationsAndTestCases(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.fetchExecutionStatusRecords(testCasesIds, iterationIds).stream().map(this::toTestCaseExecutionStatus).toList();
    }

    @Override
    public Map<Long, List<TestCaseExecutionStatus>> findItemsStatusByTestCaseId(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.fetchExecutionStatusRecords(testCasesIds, iterationIds).stream().map(this::toTestCaseExecutionStatus).collect(Collectors.groupingBy(TestCaseExecutionStatus::getTestCaseId));
    }

    private List<Record2<String, Long>> fetchExecutionStatusRecords(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.dslContext.select((SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.ITERATION).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.ITERATION.ITERATION_ID.in(iterationIds).and(Tables.TEST_PLAN_ITEM.TCLN_ID.in(testCasesIds))).fetch();
    }

    private TestCaseExecutionStatus toTestCaseExecutionStatus(Record2<String, Long> record) {
        ExecutionStatus status = ExecutionStatus.valueOf((String)((String)record.value1()));
        Long testCaseId = (Long)record.value2();
        return new TestCaseExecutionStatus(status, testCaseId);
    }

    @Override
    public List<NamedReference> findAllTestSuitesAsNamedReferences(Long iterationId) {
        return this.dslContext.select((SelectField)Tables.TEST_SUITE.ID, (SelectField)Tables.TEST_SUITE.NAME).from((TableLike)Tables.ITERATION_TEST_SUITE).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).where(Tables.ITERATION_TEST_SUITE.ITERATION_ID.eq((Object)iterationId)).orderBy((OrderField)Tables.TEST_SUITE.NAME.asc()).fetchInto(NamedReference.class);
    }

    @Override
    public List<NodeReference> findAllChildReferences(Collection<Long> parentIds) {
        return this.dslContext.select((SelectField)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID).from((TableLike)Tables.ITERATION_TEST_SUITE).where(Tables.ITERATION_TEST_SUITE.ITERATION_ID.in(parentIds)).fetch().stream().map(record -> new NodeReference(NodeType.TEST_SUITE, (Long)record.get((Field)Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID))).toList();
    }
}

