/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.quicktestnote;

import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.quicktest.QuickTest;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.internal.display.dto.sprint.QuickTestNoteDto;
import org.squashtest.tm.service.internal.repository.QuickTestNoteDao;
import org.squashtest.tm.service.quicktestnote.QuickTestNoteViewService;

@Service
@Transactional(readOnly=true)
public class QuickTestNoteViewServiceImpl
implements QuickTestNoteViewService {
    private final QuickTestNoteDao quickTestNoteDao;

    public QuickTestNoteViewServiceImpl(QuickTestNoteDao quickTestNoteDao) {
        this.quickTestNoteDao = quickTestNoteDao;
    }

    @Override
    @CheckEntityExists(entityType=QuickTest.class)
    public List<QuickTestNoteDto> getQuickTestNotes(long quickTestId) {
        return this.quickTestNoteDao.findByQuickTestIdOrderByIdDesc(quickTestId).stream().map(quickTestNote -> new QuickTestNoteDto(quickTestNote.getId(), quickTestNote.getQuickTest().getId(), quickTestNote.getContent())).toList();
    }
}

