/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction;

import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.Facility;
import org.squashtest.tm.service.internal.batchimport.LogTrain;

public abstract class Instruction<T extends Target> {
    private final T target;
    protected final LogTrain logTrain;
    private int line;
    private ImportMode mode = ImportMode.getDefault();

    protected Instruction(T target) {
        this.logTrain = new LogTrain();
        this.target = target;
    }

    public String getSourcePath(boolean isTcContext) {
        this.target.setTcContext(isTcContext);
        return this.getSourcePath();
    }

    public String getSourcePath() {
        return this.target.getSourcePath();
    }

    public String getLinkPath() {
        return this.target.getLinkPath();
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public ImportMode getMode() {
        return this.mode;
    }

    public void setMode(ImportMode mode) {
        if (mode != null) {
            this.mode = mode;
        }
    }

    public void addLogEntry(ImportStatus status, String messageKey, String impactKey, Object ... messageArgs) {
        LogEntry entry = LogEntry.status(status).forTarget((Target)this.target).atLine(this.line).withMessage(messageKey, messageArgs).withImpact(impactKey, new Object[0]).build();
        this.logTrain.addEntry(entry);
    }

    public T getTarget() {
        return this.target;
    }

    public void execute(Facility facility) {
        if (this.logTrain.hasCriticalErrors()) {
            return;
        }
        this.logTrain.append(switch (this.mode) {
            case ImportMode.CREATE -> this.executeCreate(facility);
            case ImportMode.DELETE -> this.executeDelete(facility);
            case ImportMode.UPDATE -> this.executeUpdate(facility);
            default -> throw new IllegalStateException("Unrecognized ImportMode " + String.valueOf((Object)this.mode) + ". One must have forgotten to handle new modes");
        });
    }

    public boolean canImport(boolean isTcContext) {
        if (this.hasCriticalErrors()) {
            return false;
        }
        String path = this.getSourcePath(isTcContext);
        if (!PathUtils.isPathWellFormed((String)path)) {
            this.addLogEntry(ImportStatus.FAILURE, "message.import.log.error.field.malformedPath", null, path);
            return false;
        }
        return true;
    }

    public void addLogs(LogTrain logs) {
        this.logTrain.append(logs);
    }

    public LogTrain getLogTrain() {
        return this.logTrain;
    }

    public boolean hasCriticalErrors() {
        return this.logTrain.hasCriticalErrors();
    }

    protected abstract LogTrain executeUpdate(Facility var1);

    protected abstract LogTrain executeDelete(Facility var1);

    protected abstract LogTrain executeCreate(Facility var1);
}

