/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.column.testcase;

import jakarta.validation.constraints.NotNull;
import org.apache.poi.ss.usermodel.Row;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.column.AbstractInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.column.StdColumnDef;
import org.squashtest.tm.service.internal.batchimport.column.WorksheetDef;
import org.squashtest.tm.service.internal.batchimport.column.testcase.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.instruction.ActionStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.StepInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.TestStepTarget;

public class StepInstructionBuilder
extends AbstractInstructionBuilder<StepSheetColumn, StepInstruction> {
    private final StdColumnDef<StepSheetColumn> stepTypeColDef;

    public StepInstructionBuilder(@NotNull WorksheetDef<StepSheetColumn> swd) {
        super(swd);
        this.stepTypeColDef = this.worksheetDef.getColumnDef(StepSheetColumn.TC_STEP_IS_CALL_STEP);
    }

    @Override
    protected StepInstruction createInstruction(Row row) {
        StepInstruction instruction = this.isActionStepRow(row) ? new ActionStepInstruction(new TestStepTarget(), ActionTestStep.createBlankActionStep()) : new CallStepInstruction(new TestStepTarget(), new TestCaseTarget(), ActionTestStep.createBlankActionStep(), new CallStepParamsInfo());
        return instruction;
    }

    private boolean isActionStepRow(Row row) {
        if (this.stepTypeColDef == null) {
            return true;
        }
        Boolean callStep = (Boolean)this.getValue(row, this.stepTypeColDef);
        return callStep == null || callStep == false;
    }
}

