/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport.models;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;

public final class TestStepModel {
    public static final Comparator<TestStepModel> COMPARATOR = new Comparator<TestStepModel>(){

        @Override
        public int compare(TestStepModel o1, TestStepModel o2) {
            int comp1 = o1.getTcOwnerPath().compareTo(o2.getTcOwnerPath());
            if (comp1 == 0) {
                return o1.getOrder() - o2.getOrder();
            }
            return comp1;
        }
    };
    private String tcOwnerPath;
    private long tcOwnerId;
    private long id;
    private int order;
    private Integer isCallStep;
    private String action;
    private String result;
    private Long nbReq;
    private Long nbAttach;
    private String calledDsName;
    private boolean delegateParameters;
    private List<ExportModel.CustomField> cufs = new LinkedList<ExportModel.CustomField>();

    public TestStepModel(long tcOwnerId, long id, int order, Integer isCallStep, String action, String result, Long nbReq, Long nbAttach, String calledDsName, Integer delegateParameters) {
        this.tcOwnerId = tcOwnerId;
        this.id = id;
        this.order = order;
        this.isCallStep = isCallStep;
        this.action = action;
        this.result = result;
        this.nbReq = nbReq;
        this.nbAttach = nbAttach;
        this.calledDsName = calledDsName;
        this.delegateParameters = delegateParameters == 1;
    }

    public String getTcOwnerPath() {
        return this.tcOwnerPath;
    }

    public void setTcOwnerPath(String tcOwnerPath) {
        this.tcOwnerPath = tcOwnerPath;
    }

    public long getTcOwnerId() {
        return this.tcOwnerId;
    }

    public void setTcOwnerId(long tcOwnerId) {
        this.tcOwnerId = tcOwnerId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Integer getIsCallStep() {
        return this.isCallStep;
    }

    public void setIsCallStep(Integer isCallStep) {
        this.isCallStep = isCallStep;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Long getNbReq() {
        return this.nbReq;
    }

    public void setNbReq(Long nbReq) {
        this.nbReq = nbReq;
    }

    public Long getNbAttach() {
        return this.nbAttach;
    }

    public void setNbAttach(Long nbAttach) {
        this.nbAttach = nbAttach;
    }

    public void addCuf(ExportModel.CustomField cuf) {
        this.cufs.add(cuf);
    }

    public List<ExportModel.CustomField> getCufs() {
        return this.cufs;
    }

    public String getDsName() {
        String name = this.delegateParameters ? "INHERIT" : this.calledDsName;
        return name;
    }
}

