/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.annotation;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.promptset.Prompt;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.domain.quicktest.QuickTest;
import org.squashtest.tm.domain.quicktest.QuickTestNote;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;

@Aspect
@Component
public class CheckEntityExistsAspect {
    private static final String ADVISING_METHOD = "Advising method {}{}.";
    private static final String FOUND_ID_IN_METHOD = "Found required @{} on arg #{} of method {}.";
    private static final String MISSING_ID_PARAMETER = "Could not find any argument annotated @Id in @CheckEntityExistsAspect method %s%s. This must be a structural programming error.";
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckEntityExists.class);
    private static final Map<Class<?>, Table<?>> TABLE_BY_CLASS = Map.ofEntries(Map.entry(AclGroup.class, Tables.ACL_GROUP), Map.entry(AiServer.class, Tables.AI_SERVER), Map.entry(Attachment.class, Tables.ATTACHMENT), Map.entry(AttachmentList.class, Tables.ATTACHMENT_LIST), Map.entry(BugTracker.class, Tables.BUGTRACKER), Map.entry(CustomField.class, Tables.CUSTOM_FIELD), Map.entry(CustomReportLibraryNode.class, Tables.CUSTOM_REPORT_LIBRARY_NODE), Map.entry(Campaign.class, Tables.CAMPAIGN), Map.entry(CampaignLibrary.class, Tables.CAMPAIGN_LIBRARY), Map.entry(CampaignFolder.class, Tables.CAMPAIGN_FOLDER), Map.entry(EnvironmentVariable.class, Tables.ENVIRONMENT_VARIABLE), Map.entry(Execution.class, Tables.EXECUTION), Map.entry(InfoList.class, Tables.INFO_LIST), Map.entry(Iteration.class, Tables.ITERATION), Map.entry(Milestone.class, Tables.MILESTONE), Map.entry(Project.class, Tables.PROJECT), Map.entry(PromptSet.class, Tables.PROMPT_SET), Map.entry(Prompt.class, Tables.PROMPT), Map.entry(Requirement.class, Tables.REQUIREMENT), Map.entry(RequirementFolder.class, Tables.REQUIREMENT_FOLDER), Map.entry(RequirementVersion.class, Tables.REQUIREMENT_VERSION), Map.entry(ScmServer.class, Tables.SCM_SERVER), Map.entry(Sprint.class, Tables.SPRINT), Map.entry(SprintGroup.class, Tables.SPRINT_GROUP), Map.entry(SprintReqVersion.class, Tables.SPRINT_REQ_VERSION), Map.entry(Team.class, Tables.CORE_TEAM), Map.entry(TestAutomationServer.class, Tables.TEST_AUTOMATION_SERVER), Map.entry(TestCase.class, Tables.TEST_CASE), Map.entry(TestCaseFolder.class, Tables.TEST_CASE_FOLDER), Map.entry(TestCaseLibrary.class, Tables.TEST_CASE_LIBRARY), Map.entry(TestSuite.class, Tables.TEST_SUITE), Map.entry(User.class, Tables.CORE_USER), Map.entry(QuickTest.class, Tables.QUICK_TEST), Map.entry(QuickTestNote.class, Tables.QUICK_TEST_NOTE));
    private static final Map<Table<?>, TableField<?, Timestamp>> SOFT_DELETE = Map.ofEntries(Map.entry(Tables.TEST_CASE, Tables.TEST_CASE_LIBRARY_NODE.DELETED_ON));
    @Inject
    DSLContext dsl;

    @Around(value="execution(@org.squashtest.tm.service.annotation.CheckEntityExists * * (..)) && @annotation(checkEntityExists)")
    public Object checkEntityExists(ProceedingJoinPoint pjp, CheckEntityExists checkEntityExists) throws Throwable {
        Long entityId = this.findEntityId(pjp);
        Class<?> entityType = checkEntityExists.entityType();
        this.checkEntityExist(entityType, entityId);
        return pjp.proceed();
    }

    private void checkEntityExist(Class<?> entityType, Long entityId) {
        boolean exists;
        Table<?> entityTable = TABLE_BY_CLASS.get(entityType);
        Field<Long> primaryColumn = CheckEntityExistsAspect.getPrimaryColumn(entityType, entityTable);
        TableField<?, Timestamp> softDeletedField = SOFT_DELETE.get(entityTable);
        boolean bl = exists = softDeletedField != null ? this.checkWithSoftDelete(entityTable, primaryColumn, softDeletedField, entityId) : this.checkWithoutSoftDelete(entityTable, primaryColumn, entityId);
        if (!exists) {
            throw new EntityDoesNotExistException(entityType.getSimpleName(), entityId.toString());
        }
    }

    private static Field<Long> getPrimaryColumn(Class<?> entityType, Table<?> entityTable) {
        if (entityTable == null) {
            throw new IllegalArgumentException("Unknown entity type: " + entityType.getSimpleName());
        }
        UniqueKey primaryKey = entityTable.getPrimaryKey();
        if (primaryKey == null || primaryKey.getFields().isEmpty()) {
            throw new IllegalStateException("Missing primary key for entity: " + entityType.getSimpleName());
        }
        return (Field)primaryKey.getFields().getFirst();
    }

    private boolean checkWithoutSoftDelete(Table<?> table, Field<Long> primaryColumn, Long entityId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from(table).where(primaryColumn.eq((Object)entityId)));
    }

    private boolean checkWithSoftDelete(Table<?> entityTable, Field<Long> primaryColumn, TableField<?, Timestamp> softDeletedField, Long entityId) {
        Table softDeleteTable = softDeletedField.getTable();
        if (entityTable.equals((Object)softDeleteTable)) {
            return this.dsl.fetchExists((Select)this.dsl.selectOne().from(entityTable).where(primaryColumn.eq((Object)entityId).and(softDeletedField.isNull())));
        }
        Field softDeletePrimaryKey = (Field)softDeleteTable.getPrimaryKey().getFields().getFirst();
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from(entityTable).join((TableLike)softDeleteTable).on(primaryColumn.eq(softDeletePrimaryKey)).where(primaryColumn.eq((Object)entityId).and(softDeletedField.isNull())));
    }

    private Long findEntityId(ProceedingJoinPoint pjp) {
        return (Long)this.findAnnotatedParamValue(pjp);
    }

    private <T> T findAnnotatedParamValue(ProceedingJoinPoint pjp) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        LOGGER.trace(ADVISING_METHOD, new Object[]{signature.getDeclaringTypeName(), method.getName()});
        Annotation[][] annotations = method.getParameterAnnotations();
        int iArg = 0;
        while (iArg < annotations.length) {
            Annotation[] currentArgAnnotations;
            Annotation[] annotationArray = currentArgAnnotations = annotations[iArg];
            int n = currentArgAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (Id.class.equals(annotation.annotationType())) {
                    LOGGER.trace(FOUND_ID_IN_METHOD, new Object[]{Id.class.getSimpleName(), iArg, method.getName()});
                    return (T)pjp.getArgs()[iArg];
                }
                ++n2;
            }
            ++iArg;
        }
        throw new IllegalArgumentException(String.format(MISSING_ID_PARAMETER, signature.getDeclaringTypeName(), method.getName()));
    }
}

