/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.codec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.opentestfactory.messages.OTFMessage;
import org.opentestfactory.messages.Status;
import org.squashtest.tm.service.internal.testautomation.codec.ChannelDeserializer;
import org.squashtest.tm.service.internal.testautomation.codec.ChannelStatusMixin;
import org.squashtest.tm.service.internal.testautomation.codec.SquashTFMessageMixin;
import org.squashtest.tm.service.internal.testautomation.codec.StatusMixin;
import org.squashtest.tm.service.internal.testautomation.codec.VersionStatusMixin;
import org.squashtest.tm.service.internal.testautomation.codec.WorkflowHandleMixin;
import org.squashtest.tm.service.internal.testautomation.codec.WorkflowsStatusMixin;
import org.squashtest.tm.service.internal.testautomation.model.messages.ChannelStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.VersionStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowHandle;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowsStatus;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;

public final class ObjectMapperFactory {
    private ObjectMapperFactory() {
    }

    public static ObjectMapper getJsonObjectMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        return ObjectMapperFactory.getSetupObjectMapper(jsonFactory);
    }

    private static ObjectMapper getSetupObjectMapper(JsonFactory jsonFactory) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(AutomatedExecutionEnvironment.class, (JsonDeserializer)new ChannelDeserializer());
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
        objectMapper.registerModule((Module)module);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.addMixIn(OTFMessage.class, SquashTFMessageMixin.class).addMixIn(Status.class, StatusMixin.class).addMixIn(WorkflowHandle.class, WorkflowHandleMixin.class).addMixIn(ChannelStatus.class, ChannelStatusMixin.class).addMixIn(VersionStatus.class, VersionStatusMixin.class).addMixIn(WorkflowsStatus.class, WorkflowsStatusMixin.class);
        return objectMapper;
    }
}

