/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.security.ObjectIdentityService;
import org.squashtest.tm.service.security.acls.jdbc.ManageableAclService;

@Service(value="squashtest.core.security.ObjectIdentityService")
@Transactional
public class ObjectIdentityServiceImpl
implements ObjectIdentityService {
    @Inject
    @Named(value="squashtest.core.security.AclService")
    private ManageableAclService aclService;

    @Override
    public void addObjectIdentity(long objectId, Class<?> entityClass) {
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(entityClass, (Serializable)Long.valueOf(objectId));
        this.aclService.createObjectIdentity((ObjectIdentity)objectIdentity);
    }

    @Override
    public void removeObjectIdentity(long entityId, Class<?> entityType) {
        ObjectIdentityImpl objectIdentity = new ObjectIdentityImpl(entityType, (Serializable)Long.valueOf(entityId));
        this.aclService.removeObjectIdentity((ObjectIdentity)objectIdentity);
    }
}

