/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.service.internal.repository.CustomDatasetDao;
import org.squashtest.tm.service.internal.repository.JooqCallTestCaseDao;

@Repository
public class DatasetDaoImpl
implements CustomDatasetDao {
    private final EntityManager em;
    private final JooqCallTestCaseDao jooqCallTestCaseDao;

    public DatasetDaoImpl(EntityManager em, JooqCallTestCaseDao jooqCallTestCaseDao) {
        this.em = em;
        this.jooqCallTestCaseDao = jooqCallTestCaseDao;
    }

    @Override
    public List<Dataset> findAllDelegateDatasets(Long testCaseId) {
        return this.findAllDatasetsByTestCaseIds(List.of(testCaseId)).getOrDefault(testCaseId, Collections.emptyList());
    }

    @Override
    public Map<Long, List<Dataset>> findAllDatasetsByTestCaseIds(Collection<Long> sourceTestCaseIds) {
        Map<Long, List<Long>> callerTestCaseIdsByCalled = this.jooqCallTestCaseDao.findTestCaseIdsInheritParameters(sourceTestCaseIds);
        Set<Long> allTestCaseIds = Stream.concat(sourceTestCaseIds.stream(), callerTestCaseIdsByCalled.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
        Map<Long, List<Dataset>> datasetsByTestCaseId = this.findOwnDatasetsByTestCaseIds(allTestCaseIds);
        return sourceTestCaseIds.stream().map(testCaseId -> {
            ArrayList datasets = new ArrayList(datasetsByTestCaseId.getOrDefault(testCaseId, List.of()));
            callerTestCaseIdsByCalled.getOrDefault(testCaseId, Collections.emptyList()).stream().map(callerId -> datasetsByTestCaseId.getOrDefault(callerId, List.of())).forEach(datasets::addAll);
            return datasets.isEmpty() ? null : Map.entry(testCaseId, datasets);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<Long, List<Dataset>> findOwnDatasetsByTestCaseIds(Collection<Long> testCaseIds) {
        return this.em.createQuery("select d\nfrom Dataset d\njoin fetch d.testCase\nleft join fetch d.parameterValues pv\nleft join fetch pv.parameter\nwhere d.testCase.id in :ids", Dataset.class).setParameter("ids", testCaseIds).getResultStream().collect(Collectors.groupingBy(d -> d.getTestCase().getId()));
    }

    @Override
    public void removeDatasetFromTestPlanItems(Long datasetId) {
        this.em.createQuery("update TestPlanItem\nset referencedDataset = null\nwhere referencedDataset.id = :datasetId").setParameter("datasetId", (Object)datasetId).executeUpdate();
        this.em.createQuery("update CampaignTestPlanItem\nset referencedDataset = null\nwhere referencedDataset.id = :datasetId").setParameter("datasetId", (Object)datasetId).executeUpdate();
    }

    @Override
    public Dataset findByTestCaseIdAndNameWithDatasetParamValues(Long testCaseId, String name) {
        return (Dataset)this.em.createQuery("select dataset\nfrom Dataset dataset\njoin fetch dataset.testCase testCase\njoin fetch dataset.parameterValues paramvalue\njoin fetch paramvalue.parameter\nwhere testCase.id = :testCaseId and dataset.name = :name", Dataset.class).setParameter("testCaseId", (Object)testCaseId).setParameter("name", (Object)name).getSingleResult();
    }

    @Override
    public Map<Long, List<String>> findOwnDatasetNamesByTestCaseIds(Collection<Long> testCaseIds) {
        return this.em.createQuery("select tc.id, d.name\nfrom Dataset d\njoin fetch d.testCase tc\nwhere tc.id in :ids", Object[].class).setParameter("ids", testCaseIds).getResultStream().collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (String)result[1], Collectors.toList())));
    }
}

