/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.helper;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.Update;
import org.jooq.UpdateSetFirstStep;
import org.jooq.UpdateSetMoreStep;

public final class JooqUpdateHelper {
    private JooqUpdateHelper() {
    }

    public static void nullifyColumnsWithJoin(DSLContext dslContext, Table<?> joinTable, Condition joinCondition, TableField<?, ?> ... fieldsToNullify) {
        JooqUpdateHelper.getQueryNullifyColumnsWithJoin(dslContext, joinTable, joinCondition, fieldsToNullify).execute();
    }

    public static Update<?> getQueryNullifyColumnsWithJoin(DSLContext dslContext, Table<?> joinTable, Condition joinCondition, TableField<?, ?> ... fieldsToNullify) {
        if (fieldsToNullify.length == 0) {
            throw new IllegalArgumentException("At least one field must be specified to set to NULL");
        }
        Table<?> targetTable = JooqUpdateHelper.getTargetTable(fieldsToNullify);
        return JooqUpdateHelper.getUpdateWithJoin(dslContext, targetTable, joinTable, joinCondition, update -> JooqUpdateHelper.applySetNullFields(update, fieldsToNullify));
    }

    public static void updateColumnsWithJoin(DSLContext dslContext, Table<?> joinTable, Condition joinCondition, Map<TableField<?, ?>, Object> fieldUpdates) {
        if (fieldUpdates.isEmpty()) {
            throw new IllegalArgumentException("At least one field update must be specified");
        }
        Table<?> targetTable = JooqUpdateHelper.getTargetTable((TableField[])fieldUpdates.keySet().toArray(TableField[]::new));
        JooqUpdateHelper.getUpdateWithJoin(dslContext, targetTable, joinTable, joinCondition, update -> JooqUpdateHelper.applyUpdateFields(update, fieldUpdates)).execute();
    }

    private static Update<?> getUpdateWithJoin(DSLContext dslContext, Table<?> targetTable, Table<?> joinTable, Condition joinCondition, Function<UpdateSetFirstStep<?>, UpdateSetMoreStep<?>> setOperation) {
        switch (dslContext.dialect()) {
            case MARIADB: {
                UpdateSetFirstStep update = dslContext.update((Table)targetTable.innerJoin(joinTable).on(joinCondition));
                return (Update)setOperation.apply(update);
            }
            case POSTGRES: {
                UpdateSetFirstStep update = dslContext.update(targetTable);
                UpdateSetMoreStep<?> updateStep = setOperation.apply(update);
                return updateStep.from(joinTable).where(joinCondition);
            }
        }
        throw new IllegalArgumentException("Unsupported SQL dialect: %s. Only MARIADB and POSTGRES are supported for UPDATE with JOIN operations.".formatted(dslContext.dialect()));
    }

    private static UpdateSetMoreStep<?> applyUpdateFields(UpdateSetFirstStep<?> update, Map<TableField<?, ?>, Object> fieldUpdates) {
        Iterator<Map.Entry<TableField<?, ?>, Object>> iterator = fieldUpdates.entrySet().iterator();
        Map.Entry<TableField<?, ?>, Object> firstEntry = iterator.next();
        UpdateSetMoreStep updateStep = update.set((Field)firstEntry.getKey(), firstEntry.getValue());
        while (iterator.hasNext()) {
            Map.Entry<TableField<?, ?>, Object> entry = iterator.next();
            updateStep = updateStep.set((Field)entry.getKey(), entry.getValue());
        }
        return updateStep;
    }

    private static UpdateSetMoreStep<?> applySetNullFields(UpdateSetFirstStep<?> update, TableField<?, ?> ... fieldsToNull) {
        UpdateSetMoreStep updateStep = update.setNull(fieldsToNull[0]);
        int i = 1;
        while (i < fieldsToNull.length) {
            updateStep = updateStep.setNull(fieldsToNull[i]);
            ++i;
        }
        return updateStep;
    }

    private static Table<?> getTargetTable(TableField<?, ?>[] fields) {
        Table targetTable = fields[0].getTable();
        if (targetTable == null) {
            throw new IllegalArgumentException("Cannot determine target table from fields");
        }
        TableField<?, ?>[] tableFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            TableField<?, ?> field = tableFieldArray[n2];
            if (!targetTable.equals((Object)field.getTable())) {
                throw new IllegalArgumentException(String.format("All fields must belong to the same table. Expected: %s, but found: %s", targetTable.getName(), field.getTable() != null ? field.getTable().getName() : "null"));
            }
            ++n2;
        }
        return targetTable;
    }
}

