/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Record6;
import org.jooq.Record8;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.CoreUser;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public abstract class AbstractTestPlanGrid<R extends Record>
extends AbstractGrid {
    private static final String HAS_EXECUTABLE_STEPS_TABLE = "HAS_EXECUTABLE_STEPS";
    protected static final String ASSIGNEE_USER = "ASSIGNEE_USER";
    protected static final String EXECUTOR_USER = "EXECUTOR_USER";
    protected static final String TEST_CASE_TABLE = "TEST_CASE";
    protected static final String LAST_EXECUTION_TABLE = "LAST_EXECUTION";
    protected static final String INFERRED_EXECUTION_MODE_TABLE = "INFERRED_EXECUTION_MODE";
    protected static final String MILESTONE_DATES_TABLE = "MILESTONE_DATES";
    protected static final String BLOCKED_MILESTONE_TABLE = "BLOCKED_MILESTONE";
    protected String userLoginToRestrictTo;

    protected AbstractTestPlanGrid(String userLoginToRestrictTo) {
        this.userLoginToRestrictTo = userLoginToRestrictTo;
    }

    protected abstract TableOnConditionStep<Record> getItemTable();

    protected abstract TableField<R, Long> getItemIdColumn();

    protected abstract Condition getSourceEntityCondition();

    protected abstract TableField<R, Long> getAssigneeIdColumn();

    protected abstract TableField<R, Long> getTestCaseIdColumn();

    protected abstract List<GridColumn> getSpecificColumns();

    @Override
    protected Condition craftInvariantFilter() {
        Condition condition = this.buildCommonItemFilter();
        return condition.and(Tables.TEST_PLAN_ITEM.DELETED.isFalse());
    }

    protected Condition buildCommonItemFilter() {
        Condition condition = this.getItemFilter();
        if (this.userLoginToRestrictTo != null) {
            Field assigneeLoginField = DSL.field((Name)DSL.name((String[])new String[]{ASSIGNEE_USER, "LOGIN"}), String.class);
            condition = condition.and(assigneeLoginField.eq((Object)this.userLoginToRestrictTo).or(this.isExploratoryRow()));
        }
        return condition;
    }

    protected Condition getItemFilter() {
        return this.getSourceEntityCondition().and(Tables.TEST_PLAN_ITEM.DELETED.isFalse());
    }

    @Override
    protected List<GridColumn> getColumns() {
        CoreUser executorUser = this.getExecutorUser();
        CoreUser assigneeUser = this.getAssigneeUser();
        ArrayList<GridColumn> commonColumns = new ArrayList<GridColumn>(List.of(new GridColumn((Field<?>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID), new GridColumn((Field<?>)Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON), new GridColumn(DSL.field(TestPlanGridHelpers.formatAssigneeFullName(executorUser)).as("LAST_EXECUTED_BY")), new GridColumn((Field<?>)executorUser.LOGIN.as("EXECUTOR_LOGIN"), (Field<?>)executorUser.LOGIN), new GridColumn(Tables.TEST_PLAN_ITEM.ASSIGNEE_ID.as("ASSIGNEE_ID")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID")), new GridColumn((Field<?>)Tables.DATASET.NAME.as("DATASET_NAME"), (Field<?>)Tables.DATASET.NAME), new GridColumn(Tables.DATASET.DATASET_ID.as("DATASET_ID")), new GridColumn((Field<?>)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{LAST_EXECUTION_TABLE, "LATEST_EXECUTION_ID"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{LAST_EXECUTION_TABLE, "LAST_EXECUTION_MODE"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{LAST_EXECUTION_TABLE, "EXECUTION_LATEST_STATUS"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{LAST_EXECUTION_TABLE, "EXECUTION_LAST_EXECUTED_ON"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "TEST_CASE_ID"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "KIND"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "TEST_CASE_NAME"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "PROJECT_NAME"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "TEST_CASE_REFERENCE"}))), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "IMPORTANCE"}), String.class)), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "SCRIPT"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{TEST_CASE_TABLE, "TEST_CASE_ID"})).isNull().as("TEST_CASE_DELETED")), new GridColumn(DSL.field(TestPlanGridHelpers.formatAssigneeFullName(assigneeUser)).as("ASSIGNEE_FULL_NAME")), new GridColumn((Field<?>)DSL.field((SelectField)assigneeUser.LOGIN).as("ASSIGNEE_LOGIN"), (Field<?>)assigneeUser.LOGIN), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{HAS_EXECUTABLE_STEPS_TABLE, "ITEM_ID"})).isNotNull().as(HAS_EXECUTABLE_STEPS_TABLE))));
        commonColumns.addAll(this.getSpecificColumns());
        return commonColumns;
    }

    protected Table<Record6<Long, Long, String, String, Timestamp, String>> getLatestExecutionTable() {
        SelectHavingStep<Record2<Long, Integer>> findLastExecutionByOrder = this.findLastExecutionByOrder();
        return DSL.select((SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID.as("ITEM_ID"), (SelectField)Tables.EXECUTION.EXECUTION_ID.as("LATEST_EXECUTION_ID"), (SelectField)Tables.EXECUTION.EXECUTION_MODE.as("LAST_EXECUTION_MODE"), (SelectField)Tables.EXECUTION.EXECUTION_STATUS.as("EXECUTION_LATEST_STATUS"), (SelectField)Tables.EXECUTION.LAST_EXECUTED_ON.as("EXECUTION_LAST_EXECUTED_ON"), (SelectField)Tables.EXECUTION.LAST_EXECUTED_BY.as("EXECUTION_LAST_EXECUTED_BY")).from((TableLike)Tables.EXECUTION).innerJoin(findLastExecutionByOrder).on(Tables.EXECUTION.EXECUTION_ID.eq(findLastExecutionByOrder.field("EXECUTION_ID", Long.class))).where(findLastExecutionByOrder.field("ROW_NUMBER", Integer.class).eq((Object)1)).asTable(LAST_EXECUTION_TABLE);
    }

    private SelectHavingStep<Record2<Long, Integer>> findLastExecutionByOrder() {
        return DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID, (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()})).as("ROW_NUMBER")).from(this.getItemTable()).innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(this.getItemFilter());
    }

    protected Table<Record> getUser() {
        return DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[]{this.getItemIdColumn().as("ITEM_ID"), Tables.CORE_USER.LOGIN.as("ASSIGNEE_LOGIN"), TestPlanGridHelpers.formatAssigneeFullName()}).from(this.getItemTable()).innerJoin((TableLike)Tables.CORE_USER).on(this.getAssigneeIdColumn().eq((Field)Tables.CORE_USER.PARTY_ID)).where(this.getItemFilter()).asTable(ASSIGNEE_USER);
    }

    protected Table<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)this.getItemIdColumn().as("ITEM_ID"), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MIN_DATE"), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MAX_DATE"), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as("MILESTONE_LABELS")).from(this.getItemTable()).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(this.getTestCaseIdColumn().eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).where(this.getItemFilter()).groupBy(new GroupField[]{this.getItemIdColumn(), Tables.MILESTONE_TEST_CASE.TEST_CASE_ID}).asTable(MILESTONE_DATES_TABLE);
    }

    protected Table<Record2<Long, String>> getAutomationFields() {
        return DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("ITEM_ID"), (SelectField)DSL.when((Condition)Tables.TEST_CASE.EXECUTION_MODE.eq((Object)TestCaseExecutionMode.EXPLORATORY.name()), (Object)TestCaseExecutionMode.EXPLORATORY.name()).otherwise(DSL.when((Condition)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NONE.name()).or(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name()).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name())).and(Tables.AUTOMATION_REQUEST.REQUEST_STATUS.eq((Object)AutomationRequestStatus.AUTOMATED.name()))).and(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.jenkins.name()).and(Tables.TEST_CASE.TA_TEST.isNotNull()).or(Tables.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()))), (Object)TestCaseExecutionMode.AUTOMATED.name()).otherwise((Object)TestCaseExecutionMode.MANUAL.name())).as(INFERRED_EXECUTION_MODE_TABLE)).from(this.getItemTable()).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID.eq((Field)Tables.TEST_CASE.AUTOMATION_REQUEST_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.TEST_AUTOMATION_SERVER).on(Tables.TEST_AUTOMATION_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID)).where(this.getItemFilter()).asTable(INFERRED_EXECUTION_MODE_TABLE);
    }

    protected Table<Record8<Long, String, Long, String, String, String, String, String>> getTestCaseTable() {
        return DSL.select((SelectField)this.getItemIdColumn().as("ITEM_ID"), (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("TEST_CASE_ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME"), (SelectField)Tables.TEST_CASE.REFERENCE.as("TEST_CASE_REFERENCE"), (SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.toString()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.toString()).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.toString()).otherwise((Object)TestCaseKind.STANDARD.toString()).as("KIND"), (SelectField)Tables.SCRIPTED_TEST_CASE.SCRIPT).from(this.getItemTable()).innerJoin((TableLike)Tables.TEST_CASE).on(this.getTestCaseIdColumn().eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).where(this.getItemFilter()).asTable(TEST_CASE_TABLE);
    }

    protected Table<Record1<Long>> getHasExecutableSteps() {
        return DSL.selectDistinct((SelectField)this.getItemIdColumn().as("ITEM_ID")).from(this.getItemTable()).innerJoin((TableLike)Tables.TEST_CASE).on(this.getTestCaseIdColumn().eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).where(this.getItemFilter().and(Tables.TEST_CASE.EXECUTION_MODE.notEqual((Object)TestCaseExecutionMode.EXPLORATORY.name()))).asTable(HAS_EXECUTABLE_STEPS_TABLE);
    }

    protected Condition isExploratoryRow() {
        return Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.isNotNull();
    }

    protected Table<Record1<Long>> getBoundToBlockingMilestone() {
        return DSL.selectDistinct((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("ITEM_ID")).from(this.getItemTable()).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).where(this.getItemFilter().and(Tables.MILESTONE.STATUS.in((Collection)MilestoneStatus.MILESTONE_BLOCKING_STATUSES))).asTable(BLOCKED_MILESTONE_TABLE);
    }

    protected CoreUser getExecutorUser() {
        return Tables.CORE_USER.as(EXECUTOR_USER);
    }

    protected CoreUser getAssigneeUser() {
        return Tables.CORE_USER.as(ASSIGNEE_USER);
    }
}

