/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Component;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcCampaignDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandlerFactory;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcSprintDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcSprintDeletionHandlerFactory;

@Component
public class JdbcCampaignDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;
    private final JdbcIterationDeletionHandlerFactory iterationDeletionHandlerFactory;
    private final JdbcSprintDeletionHandlerFactory sprintDeletionHandlerFactory;
    private final EntityManager entityManager;

    public JdbcCampaignDeletionHandlerFactory(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, JdbcIterationDeletionHandlerFactory iterationDeletionHandlerFactory, JdbcSprintDeletionHandlerFactory sprintDeletionHandlerFactory) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.iterationDeletionHandlerFactory = iterationDeletionHandlerFactory;
        this.sprintDeletionHandlerFactory = sprintDeletionHandlerFactory;
        this.entityManager = entityManager;
    }

    public JdbcCampaignDeletionHandler build(Collection<Long> nodeIds) {
        Set<Long> folderIds = this.findFolderIds(nodeIds);
        Set<Long> campaignIds = this.findCampaignIds(nodeIds);
        String operationId = UUID.randomUUID().toString();
        Set<Long> iterationIds = this.findIterationIds(campaignIds);
        JdbcIterationDeletionHandler iterationDeletionHandler = this.iterationDeletionHandlerFactory.build(iterationIds, operationId);
        Set<Long> sprintGroupIds = this.findSprintGroupIds(nodeIds);
        Set<Long> sprintIds = this.findSprintIds(nodeIds);
        JdbcSprintDeletionHandler sprintDeletionHandler = this.sprintDeletionHandlerFactory.build(sprintIds, operationId);
        return new JdbcCampaignDeletionHandler(folderIds, campaignIds, sprintGroupIds, sprintIds, this.dslContext, this.entityManager, this.attachmentRepository, this.reorderHelper, iterationDeletionHandler, sprintDeletionHandler, operationId);
    }

    private Set<Long> findFolderIds(Collection<Long> nodeIds) {
        return this.dslContext.select((SelectField)Tables.CAMPAIGN_FOLDER.CLN_ID).from((TableLike)Tables.CAMPAIGN_FOLDER).where(Tables.CAMPAIGN_FOLDER.CLN_ID.in(nodeIds)).fetchSet((Field)Tables.CAMPAIGN_FOLDER.CLN_ID);
    }

    private Set<Long> findCampaignIds(Collection<Long> nodeIds) {
        return this.dslContext.select((SelectField)Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).where(Tables.CAMPAIGN.CLN_ID.in(nodeIds)).fetchSet((Field)Tables.CAMPAIGN.CLN_ID);
    }

    private Set<Long> findIterationIds(Collection<Long> campaignIds) {
        return this.dslContext.select((SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIds)).fetchSet((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID);
    }

    private Set<Long> findSprintGroupIds(Collection<Long> nodeIds) {
        return this.dslContext.select((SelectField)Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).where(Tables.SPRINT_GROUP.CLN_ID.in(nodeIds)).fetchSet((Field)Tables.SPRINT_GROUP.CLN_ID);
    }

    private Set<Long> findSprintIds(Collection<Long> nodeIds) {
        return this.dslContext.select((SelectField)Tables.SPRINT.CLN_ID).from((TableLike)Tables.SPRINT).where(Tables.SPRINT.CLN_ID.in(nodeIds)).fetchSet((Field)Tables.SPRINT.CLN_ID);
    }
}

