/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.internal.actionword.ActionWordArranger;
import org.squashtest.tm.service.internal.repository.ActionWordDao;
import org.squashtest.tm.service.internal.repository.KeywordTestStepDao;

@Component
public class ActionWordArrangerImpl
implements ActionWordArranger {
    @Inject
    private ActionWordDao actionWordDao;
    @Inject
    private KeywordTestStepDao keywordTestStepDao;
    @Inject
    private ActionWordLibraryNodeService actionWordLibraryNodeService;

    @Override
    public void arrangeActionWordsBeforeProjectDeleting(Long projectId) {
        Map actionsWordsWithSubstitute = this.actionWordDao.findAllWithDuplicateTokenByProjectId(projectId);
        this.replaceInEachBySubstitute(actionsWordsWithSubstitute);
        Map actionWordsToMove = this.actionWordDao.findAllWithoutDuplicateTokenByProjectId(projectId);
        if (!actionWordsToMove.isEmpty()) {
            this.actionWordLibraryNodeService.moveNodes(new ArrayList<Long>(actionWordsToMove.keySet()), (Long)Collections.min(actionWordsToMove.values()));
        }
    }

    private void replaceInEachBySubstitute(Map<Long, Long> actionsWordsWithSubstitute) {
        if (actionsWordsWithSubstitute.isEmpty()) {
            return;
        }
        Map substituteActionWordById = this.actionWordDao.findAllActionWordWithParameterByIds(actionsWordsWithSubstitute.values());
        Iterables.partition(actionsWordsWithSubstitute.keySet(), (int)1000).forEach(originalActionWordIds -> {
            Map keywordTestStepsByActionWord = this.keywordTestStepDao.findWithParameterByActionWords((Collection<Long>)originalActionWordIds).stream().collect(Collectors.groupingBy(k -> k.getActionWord().getId(), Collectors.toList()));
            originalActionWordIds.forEach(originalActionWordId -> {
                Collection keywordTestSteps = keywordTestStepsByActionWord.getOrDefault(originalActionWordId, Collections.emptyList());
                ActionWord substitute = (ActionWord)substituteActionWordById.get(actionsWordsWithSubstitute.get(originalActionWordId));
                this.replaceActionWordInKeywordTestSteps(keywordTestSteps, substitute);
            });
        });
    }

    private void replaceActionWordInKeywordTestSteps(Collection<KeywordTestStep> keywordTestSteps, ActionWord substitute) {
        keywordTestSteps.forEach(keywordTestStep -> {
            keywordTestStep.setActionWord(substitute);
            this.updateActionWordParams((KeywordTestStep)keywordTestStep, substitute);
        });
    }

    private void updateActionWordParams(KeywordTestStep targetKeywordTestStep, ActionWord substitute) {
        List parameterValues = targetKeywordTestStep.getParamValues();
        List actionWordParameters = substitute.getActionWordParams();
        parameterValues.forEach(parameterValue -> {
            String parameterValueName = parameterValue.getActionWordParam().getName();
            ActionWordParameter actionWordParameter = actionWordParameters.stream().filter(parameter -> parameter.getName().equals(parameterValueName)).toList().getFirst();
            parameterValue.setActionWordParam(actionWordParameter);
        });
    }
}

