/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.testingstatus;

import java.util.Collection;
import java.util.stream.Collectors;
import org.squashtest.tm.service.statistics.requirement.RequirementVersionBundleStat;

public final class RemoteRequirementStatistics {
    public final Rate redactionRate;
    public final Rate verificationRate;
    public final Rate validationRate;

    private RemoteRequirementStatistics(RequirementVersionBundleStat.SimpleRequirementStats simpleRequirementStats) {
        this.redactionRate = new Rate(simpleRequirementStats.getRedactedTestCase(), simpleRequirementStats.getAllTestCaseCount());
        this.verificationRate = new Rate(simpleRequirementStats.getVerifiedTestCase(), simpleRequirementStats.getPlannedTestCase());
        this.validationRate = new Rate(simpleRequirementStats.getValidatedTestCase(), simpleRequirementStats.getExecutedTestCase());
    }

    private RemoteRequirementStatistics(Collection<RemoteRequirementStatistics> statisticsToMerge) {
        this.redactionRate = Rate.merging(statisticsToMerge.stream().map(stat -> stat.redactionRate).collect(Collectors.toSet()));
        this.verificationRate = Rate.merging(statisticsToMerge.stream().map(stat -> stat.verificationRate).collect(Collectors.toSet()));
        this.validationRate = Rate.merging(statisticsToMerge.stream().map(stat -> stat.validationRate).collect(Collectors.toSet()));
    }

    private RemoteRequirementStatistics(Rate redactionRate, Rate verificationRate, Rate validationRate) {
        this.redactionRate = redactionRate;
        this.verificationRate = verificationRate;
        this.validationRate = validationRate;
    }

    public static RemoteRequirementStatistics fromSimpleStats(RequirementVersionBundleStat.SimpleRequirementStats simpleRequirementStats) {
        return new RemoteRequirementStatistics(simpleRequirementStats);
    }

    public static RemoteRequirementStatistics merging(Collection<RemoteRequirementStatistics> statisticsToMerge) {
        return new RemoteRequirementStatistics(statisticsToMerge);
    }

    public static RemoteRequirementStatistics fromRates(Rate redactionRate, Rate verificationRate, Rate validationRate) {
        return new RemoteRequirementStatistics(redactionRate, verificationRate, validationRate);
    }

    public static final class Rate {
        public final int totalCount;
        public final int matchingCount;
        public final int percentRoundedRate;
        public final double normalizedRate;

        private Rate(int matchingCount, int totalCount) {
            this.totalCount = totalCount;
            this.matchingCount = matchingCount;
            this.normalizedRate = totalCount > 0 ? (double)((float)matchingCount / (float)totalCount) : 0.0;
            this.percentRoundedRate = (int)Math.round(this.normalizedRate * 100.0);
        }

        public static Rate from(int matchingCount, int totalCount) {
            return new Rate(matchingCount, totalCount);
        }

        public static Rate merging(Collection<Rate> ratesToMerge) {
            int totalSum = ratesToMerge.stream().map(r -> r.totalCount).reduce(0, Integer::sum);
            int matchingSum = ratesToMerge.stream().map(r -> r.matchingCount).reduce(0, Integer::sum);
            return Rate.from(matchingSum, totalSum);
        }
    }
}

