/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateLibraryDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;

@Repository
public class HibernateTestCaseLibraryDao
extends HibernateLibraryDao<TestCaseLibrary, TestCaseLibraryNode>
implements TestCaseLibraryDao {
    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.entityManager.createQuery("select content.name from TestCaseLibrary library join library.rootContent content where library.id = :id", String.class).setParameter("id", (Object)libraryId).getResultList();
    }

    @Override
    public TestCaseLibrary loadContainerForPaste(long id) {
        TestCaseLibrary testCaseLibrary = (TestCaseLibrary)this.entityManager.createQuery("select tcl from TestCaseLibrary tcl left join fetch tcl.rootContent where tcl.id = :id", TestCaseLibrary.class).setParameter("id", (Object)id).getSingleResult();
        this.entityManager.createQuery("select p from Project p\nleft join fetch p.testCaseNatures tcN\nleft join fetch tcN.items\nleft join fetch p.testCaseTypes tcT\nleft join fetch tcT.items\nwhere p.testCaseLibrary = :id\n", Project.class).setParameter("id", (Object)testCaseLibrary).getSingleResult();
        NestedEntityGraphQueryBuilder.of(this.entityManager, Project.class, "select p from Project p where p.testCaseLibrary = :id", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("testAutomationProjects"), NestedEntityGraphQueryBuilder.GraphDefinition.attr("milestones"))).executeDistinctList(Map.of("id", testCaseLibrary));
        return testCaseLibrary;
    }

    @Override
    public TestCaseLibrary loadForNodeAddition(Long libraryId) {
        return (TestCaseLibrary)this.entityManager.createQuery("select tcl from TestCaseLibrary tcl\njoin fetch tcl.project project\njoin fetch project.testCaseNatures nature\njoin fetch nature.items\njoin fetch project.testCaseTypes type\njoin fetch type.items\nleft join fetch tcl.rootContent\nwhere tcl.id = :id", TestCaseLibrary.class).setParameter("id", (Object)libraryId).getSingleResult();
    }
}

