/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateLibraryDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.NestedEntityGraphQueryBuilder;

@Repository
public class HibernateRequirementLibraryDao
extends HibernateLibraryDao<RequirementLibrary, RequirementLibraryNode>
implements RequirementLibraryDao {
    @Override
    public List<String> findContentNamesByLibraryId(Long libraryId) {
        return this.entityManager.createQuery("select content.mainResource.name\nfrom RequirementLibrary library\njoin library.rootContent content\nwhere library.id = :id", String.class).setParameter("id", (Object)libraryId).getResultList();
    }

    @Override
    public RequirementLibrary loadContainerForPaste(long id) {
        RequirementLibrary requirementFolders = (RequirementLibrary)this.entityManager.createQuery("    select rl from RequirementLibrary rl\n    left join fetch rl.rootContent\n    left join fetch rl.project p\n    where rl.id = :id\n", RequirementLibrary.class).setParameter("id", (Object)id).getSingleResult();
        Project project = (Project)this.entityManager.createQuery("    select p from Project p\n    left join fetch p.requirementCategories rC\n    left join fetch rC.items\n    where p.requirementLibrary.id = :id\n", Project.class).setParameter("id", (Object)id).getSingleResult();
        NestedEntityGraphQueryBuilder.of(this.entityManager, Project.class, "select p from Project p where p = :id", NestedEntityGraphQueryBuilder.GraphDefinition.graphDefinition(NestedEntityGraphQueryBuilder.GraphDefinition.attr("milestones"))).executeDistinctList(Map.of("id", project));
        return requirementFolders;
    }

    @Override
    public RequirementLibrary loadForNodeAddition(Long libraryId) {
        return (RequirementLibrary)this.entityManager.createQuery("select library from RequirementLibrary library\njoin fetch library.project project\njoin fetch project.requirementCategories\nleft join fetch library.rootContent content\nleft join fetch content.syncExtender\nleft join fetch content.requirementFolderSyncExtender\nwhere library.id = :id", RequirementLibrary.class).setParameter("id", (Object)libraryId).getSingleResult();
    }
}

