/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.promptset;

import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.promptset.PromptSet;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.promptset.PromptSetDisplayService;
import org.squashtest.tm.service.internal.display.dto.PromptSetAdminViewDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.PromptSetGrid;
import org.squashtest.tm.service.internal.repository.display.PromptSetDisplayDao;

@Service
@Transactional
public class PromptSetDisplayServiceImpl
implements PromptSetDisplayService {
    private final DSLContext dsl;
    private final PromptSetDisplayDao promptSetDisplayDao;

    public PromptSetDisplayServiceImpl(DSLContext dsl, PromptSetDisplayDao promptSetDisplayDao) {
        this.dsl = dsl;
        this.promptSetDisplayDao = promptSetDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest request) {
        GridResponse response = new PromptSetGrid().getRows(request, this.dsl);
        response.sanitizeField("description");
        return response;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=PromptSet.class)
    public PromptSetAdminViewDto getPromptSetView(@Id Long promptSetId) {
        return this.promptSetDisplayDao.getPromptSetById(promptSetId);
    }
}

