/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedExecutionExtender;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.repository.display.AutomatedSuiteDisplayDao;

public abstract class AbstractAutomatedSuiteGrid
extends AbstractGrid {
    protected static final Field<Long> suiteHolderIdField = DSL.field((String)"suite_holder_id", Long.class);
    private static final String AUTOMATED_EXECUTION_EXTENDER_TYPE = DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER.name();
    protected final Long holderId;
    protected final MessageSource messageSource;
    protected final AutomatedSuiteDisplayDao automatedSuiteDisplayDao;

    protected AbstractAutomatedSuiteGrid(Long holderId, MessageSource messageSource, AutomatedSuiteDisplayDao automatedSuiteDisplayDao) {
        this.holderId = holderId;
        this.messageSource = messageSource;
        this.automatedSuiteDisplayDao = automatedSuiteDisplayDao;
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"SUITE_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"CREATED_ON").coerce(Timestamp.class)), new GridColumn(DSL.field((String)"CREATED_BY")), new GridColumn(DSL.field((String)"EXECUTION_STATUS")), new GridColumn(DSL.field((String)"LAST_MODIFIED_ON").coerce(Timestamp.class)), new GridColumn(DSL.field((String)"SUITE_ID")), new GridColumn(DSL.field((String)"ENVIRONMENT_VARIABLES")), new GridColumn(DSL.field((String)"ENVIRONMENT_TAGS")), new GridColumn(DSL.field((String)"LAUNCHED_FROM")), new GridColumn(DSL.field((String)"PROJECT_ID")));
    }

    @Override
    protected Table<?> getTable() {
        Table<Record> suiteTable = this.getAutomatedSuiteTable();
        Table<Record2<Long, String>> environmentVariableTable = this.getDenormalizedEnvironmentVariablesTable();
        Table<Record2<Long, String>> environmentTagTable = this.getDenormalizedEnvironmentTagsTable();
        return DSL.select(this.getSelectFields()).from(suiteTable).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq(suiteTable.field(suiteHolderIdField))).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin(environmentVariableTable).on(Objects.requireNonNull(suiteTable.field((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)).eq(environmentVariableTable.field((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID))).leftJoin(environmentTagTable).on(Objects.requireNonNull(suiteTable.field((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)).eq(environmentTagTable.field((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID))).asTable();
    }

    protected List<Field<?>> getSuiteFields() {
        return List.of(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.as("SUITE_ID"), AutomatedSuite.AUTOMATED_SUITE.CREATED_ON.as("CREATED_ON"), AutomatedSuite.AUTOMATED_SUITE.CREATED_BY.as("CREATED_BY"), AutomatedSuite.AUTOMATED_SUITE.EXECUTION_STATUS.as("EXECUTION_STATUS"), AutomatedSuite.AUTOMATED_SUITE.LAST_MODIFIED_ON.as("LAST_MODIFIED_ON"), AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.as("ITERATION_ID"), DSL.when((Condition)AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.isNotNull(), (Object)this.messageSource.getMessage("iteration.header.title", null, LocaleContextHolder.getLocale())).otherwise((Object)this.messageSource.getMessage("test-suite.launcher.title", null, LocaleContextHolder.getLocale())).as("LAUNCHED_FROM"));
    }

    protected List<Field<?>> getSelectFields() {
        ArrayList fields = new ArrayList();
        fields.add(DSL.field((String)"ENVIRONMENT_VARIABLES", String.class).as("ENVIRONMENT_VARIABLES"));
        fields.add(DSL.field((String)"ENVIRONMENT_TAGS", String.class).as("ENVIRONMENT_TAGS"));
        fields.add(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID"));
        this.getSuiteFields().forEach(f -> {
            boolean bl = fields.add(this.getAutomatedSuiteTable().field(f));
        });
        return fields;
    }

    protected abstract Table<Record> getAutomatedSuiteTable();

    protected abstract Field<Long> getAutomatedSuiteHolderField();

    protected Table<Record2<Long, String>> getDenormalizedEnvironmentVariablesTable() {
        return DSL.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, (SelectField)DSL.groupConcatDistinct((Field)DSL.concat((Field[])new Field[]{Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.NAME, DSL.val((String)" : "), Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.VALUE})).separator(", ").as("ENVIRONMENT_VARIABLES")).from((TableLike)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE).join((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).on(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_ID.eq((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).join((TableLike)AutomatedSuite.AUTOMATED_SUITE).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)).where(this.getAutomatedSuiteHolderField().eq((Object)this.holderId)).and(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_TYPE.eq((Object)AUTOMATED_EXECUTION_EXTENDER_TYPE).and(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID))).groupBy(new GroupField[]{AutomatedSuite.AUTOMATED_SUITE.SUITE_ID}).asTable();
    }

    protected Table<Record2<Long, String>> getDenormalizedEnvironmentTagsTable() {
        return DSL.select((SelectField)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID, (SelectField)DSL.substring((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)DSL.concat((Field[])new Field[]{DSL.inline((String)", "), DSL.groupConcatDistinct((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE).separator(", ")}), (Object)""), DSL.coalesce((Field)DSL.concat((Field[])new Field[]{DSL.inline((String)", "), DSL.groupConcatDistinct((Field)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.TEST_TECHNOLOGY).separator(", ")}), (Object)"")}), (int)3).as("ENVIRONMENT_TAGS")).from((TableLike)AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER).join((TableLike)AutomatedSuite.AUTOMATED_SUITE).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)).leftJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_TAG).on(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_ID)).and(Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_TYPE.eq((Object)AUTOMATED_EXECUTION_EXTENDER_TYPE)).where(this.getAutomatedSuiteHolderField().eq((Object)this.holderId)).and(AutomatedExecutionExtender.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID.eq((Field)AutomatedSuite.AUTOMATED_SUITE.SUITE_ID)).groupBy(new GroupField[]{AutomatedSuite.AUTOMATED_SUITE.SUITE_ID}).asTable();
    }
}

