/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.restoration.jdbc;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jooq.DSLContext;
import org.jooq.Param;
import org.jooq.Record3;
import org.jooq.SelectField;
import org.jooq.SelectSelectStep;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcWorkingTables;
import org.squashtest.tm.service.internal.deletion.jdbc.delegate.AbstractDelegateDeleteQuery;

public abstract class AbstractJdbcRestorationHandler {
    protected final EntityManager entityManager;
    protected final DSLContext dslContext;
    protected final JdbcWorkingTables workingTables;
    protected final String operationId;
    protected final LocalDateTime startDate = LocalDateTime.now();

    protected AbstractJdbcRestorationHandler(EntityManager entityManager, DSLContext dslContext) {
        this.entityManager = entityManager;
        this.dslContext = dslContext;
        this.operationId = UUID.randomUUID().toString();
        this.workingTables = new JdbcWorkingTables(dslContext, this.operationId);
    }

    protected SelectSelectStep<Record3<Long, String, String>> makeSelectClause(TableField<?, Long> tableField) {
        Param<String> fieldName = AbstractDelegateDeleteQuery.extractFieldTableNameAsParam(tableField);
        return DSL.select(tableField, fieldName, (SelectField)DSL.val((String)this.operationId));
    }
}

