/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement;

import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.internal.batchimport.column.ExcelWorkbookParser;
import org.squashtest.tm.service.internal.batchimport.excel.ExcelBatchImporter;
import org.squashtest.tm.service.internal.batchimport.instruction.container.CoverageInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.Importer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.LinkedLowLevelRequirementInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.RequirementLinkInstructionContainer;
import org.squashtest.tm.service.internal.batchimport.instruction.container.RequirementVersionInstructionContainer;

@Component
public class RequirementExcelBatchImporter
extends ExcelBatchImporter {
    private static final List<EntityType> REQ_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER = Arrays.asList(EntityType.REQUIREMENT_VERSION, EntityType.COVERAGE, EntityType.REQUIREMENT_LINK, EntityType.LINKED_LOW_LEVEL_REQ);

    public RequirementExcelBatchImporter() {
        super(LoggerFactory.getLogger(RequirementExcelBatchImporter.class));
    }

    @Override
    public void addInstructionsByEntity(ExcelWorkbookParser parser, EntityType entityType, Importer importer) {
        this.LOGGER.debug("creating instructions container for entity type : {}", new Object[]{entityType});
        switch (entityType) {
            case REQUIREMENT_VERSION: {
                this.addInstructionsToImporter(parser.getRequirementVersionInstructions(), importer, RequirementVersionInstructionContainer::new);
                break;
            }
            case COVERAGE: {
                this.addInstructionsToImporter(parser.getCoverageInstructions(), importer, CoverageInstructionContainer::new);
                break;
            }
            case REQUIREMENT_LINK: {
                this.addInstructionsToImporter(parser.getRequirementLinkInstructions(), importer, RequirementLinkInstructionContainer::new);
                break;
            }
            case LINKED_LOW_LEVEL_REQ: {
                this.addInstructionsToImporter(parser.getLinkedLowLevelRequirementInstruction(), importer, LinkedLowLevelRequirementInstructionContainer::new);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EntityType for Requirement import : " + String.valueOf(this));
            }
        }
    }

    @Override
    public List<EntityType> getEntityType() {
        return REQ_ENTITIES_ORDERED_BY_INSTRUCTION_ORDER;
    }

    @Override
    public boolean isTcContext() {
        return false;
    }
}

