/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Closure;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntityVisitor;
import org.squashtest.tm.domain.actionword.ActionWordTreeLibraryNode;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.actionword.AWLNDeletionVisitor;
import org.squashtest.tm.service.internal.customreport.TreeLibraryNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.DeletionPreview;
import org.squashtest.tm.service.internal.deletion.LockedFolderInferenceTree;
import org.squashtest.tm.service.internal.repository.ActionWordLibraryNodeDao;

@Component
public class AWLNDeletionHandler
implements TreeLibraryNodeDeletionHandler<ActionWordLibraryNode> {
    @Inject
    private ActionWordLibraryNodeDao actionWordLibraryNodeDao;
    @Inject
    private ConfigurationService configurationService;

    @Override
    public DeletionPreview simulateDeletion(List<Long> targetIds) {
        return new DeletionPreview(Long.valueOf(targetIds.size()), this.getDeletionThreshold());
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        OperationReport operationReport = new OperationReport();
        LockedFolderInferenceTree tree = this.createTree(targetIds);
        Closure closure = input -> {
            LockedFolderInferenceTree.Node node = (LockedFolderInferenceTree.Node)((Object)((Object)input));
            this.doOneDelete((Long)node.getKey(), operationReport);
        };
        tree.doBottomUp(closure);
        return operationReport;
    }

    private void doOneDelete(Long nodeId, OperationReport operationReport) {
        ActionWordLibraryNode targetNode = (ActionWordLibraryNode)this.actionWordLibraryNodeDao.getReferenceById(nodeId);
        ActionWordTreeLibraryNode parentNode = targetNode.getParent();
        parentNode.removeChild((ActionWordTreeLibraryNode)targetNode);
        AWLNDeletionVisitor visitor = new AWLNDeletionVisitor(operationReport, targetNode);
        targetNode.getEntity().accept((ActionWordTreeEntityVisitor)visitor);
        this.actionWordLibraryNodeDao.delete(targetNode);
    }

    private LockedFolderInferenceTree createTree(List<Long> targetIds) {
        int descendantNumber = targetIds.size();
        List currentLayerIds = targetIds;
        LockedFolderInferenceTree tree = new LockedFolderInferenceTree();
        ArrayList<Long[]> pairedIds = new ArrayList<Long[]>();
        this.addMultipleChildToParent(null, targetIds, pairedIds);
        while (descendantNumber > 0) {
            for (Long id : currentLayerIds) {
                List descendantIds = this.actionWordLibraryNodeDao.findAllFirstLevelDescendantIds(id);
                this.addMultipleChildToParent(id, descendantIds, pairedIds);
                currentLayerIds = descendantIds;
                descendantNumber = descendantIds.size();
            }
        }
        tree.build(pairedIds);
        return tree;
    }

    private void addMultipleChildToParent(Long parentId, List<Long> childIds, List<Long[]> pairs) {
        for (Long id : childIds) {
            this.addPairToList(parentId, id, pairs);
        }
    }

    private void addPairToList(Long parentId, Long childId, List<Long[]> pairs) {
        Long[] pair = new Long[]{parentId, childId};
        pairs.add(pair);
    }

    private long getDeletionThreshold() {
        String strThreshold = this.configurationService.findConfiguration("squash.control.deletion.threshold");
        return Long.parseLong(strThreshold);
    }
}

